/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bridge;

import com.vmware.transport.bridge.AbstractFrame;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class Request<ReqP>
extends AbstractFrame {
    private String targetUser;
    private String request;
    private String channel;
    private Object headers;
    private Map<String, Object> sessionAttributes;
    private Boolean isRejected = false;

    public <T> T getSessionAttribute(String attrKey) {
        if (this.sessionAttributes == null) {
            return null;
        }
        return (T)this.sessionAttributes.get(attrKey);
    }

    public Request() {
    }

    public Request(Integer version, UUID id, String request, ReqP payload) {
        super(version, id, payload);
        this.request = request;
    }

    public Request(Integer version, UUID id, String request, ReqP payload, String channel) {
        this(version, id, request, payload);
        this.channel = channel;
    }

    public Request(UUID id, String request, ReqP payload) {
        this(1, id, request, payload);
    }

    public Request(String request, ReqP payload) {
        this(1, UUID.randomUUID(), request, payload);
    }

    public Request(String request) {
        this(1, UUID.randomUUID(), request, null);
    }

    public Request(UUID id, String request) {
        this(1, id, request, null);
    }

    @Override
    public String toString() {
        return "Request ID: " + this.getId();
    }

    @Generated
    public String getTargetUser() {
        return this.targetUser;
    }

    @Generated
    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser;
    }

    @Generated
    public String getRequest() {
        return this.request;
    }

    @Generated
    public void setRequest(String request) {
        this.request = request;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public Object getHeaders() {
        return this.headers;
    }

    @Generated
    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    @Generated
    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    @Generated
    public void setSessionAttributes(Map<String, Object> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    @Generated
    public Boolean getIsRejected() {
        return this.isRejected;
    }

    @Generated
    public void setIsRejected(Boolean isRejected) {
        this.isRejected = isRejected;
    }
}

