/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.mappers.IndexMapper;

public class ReversedCharSequence
implements CharSequence {
    private final CharSequence myChars;
    private final int myStartIndex;
    private final int myEndIndex;
    private int myHash;

    private ReversedCharSequence(CharSequence chars, int start, int end) {
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("[" + start + "," + end + ") not in [0," + this.length() + ")");
        }
        this.myChars = chars;
        this.myStartIndex = start;
        this.myEndIndex = end;
    }

    public IndexMapper getIndexMapper() {
        return new IndexMapper(){

            @Override
            public int map(int index) {
                return ReversedCharSequence.this.reversedIndex(index);
            }
        };
    }

    public int reversedIndex(int index) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("" + index + " not in [0," + (this.length() - 1) + "]");
        }
        return this.myEndIndex - 1 - index;
    }

    @Override
    public int length() {
        return this.myEndIndex - this.myStartIndex;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("" + index + " not in [0," + (this.length() - 1) + ")");
        }
        return this.myChars.charAt(this.reversedIndex(index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length()) {
            throw new IndexOutOfBoundsException("[" + start + ", " + end + ") not in [0," + (this.length() - 1) + ")");
        }
        int startIndex = this.reversedIndex(end) + 1;
        int endIndex = startIndex + end - start;
        return startIndex == this.myStartIndex && endIndex == this.myEndIndex ? this : new ReversedCharSequence(this.myChars, startIndex, endIndex);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        sb.append(this);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharSequence)) {
            return false;
        }
        if (o instanceof String || o instanceof ReversedCharSequence) {
            return this.hashCode() == o.hashCode();
        }
        CharSequence os = (CharSequence)o;
        if (this.length() != os.length()) {
            return false;
        }
        int iMax = this.length();
        for (int i = 0; i < iMax; ++i) {
            if (this.charAt(i) == os.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0 && this.length() > 0) {
            int i = this.myEndIndex;
            while (i-- > this.myStartIndex) {
                h = 31 * h + this.myChars.charAt(i);
            }
            this.myHash = h;
        }
        return h;
    }

    public static CharSequence of(CharSequence chars) {
        return ReversedCharSequence.of(chars, 0, chars.length());
    }

    public static CharSequence of(CharSequence chars, int start) {
        return ReversedCharSequence.of(chars, start, chars.length());
    }

    public static CharSequence of(CharSequence chars, int start, int end) {
        if (chars instanceof ReversedCharSequence) {
            ReversedCharSequence reversedChars = (ReversedCharSequence)chars;
            int startIndex = reversedChars.reversedIndex(end) + 1;
            int endIndex = startIndex + end - start;
            return startIndex == 0 && endIndex == chars.length() ? reversedChars.myChars : reversedChars.myChars.subSequence(startIndex, endIndex);
        }
        return new ReversedCharSequence(chars, start, end);
    }
}

