/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.BiConsumer;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.MutableAttribute;
import java.util.LinkedHashMap;
import java.util.Map;

public class MutableAttributeImpl
implements MutableAttribute {
    private final String myName;
    private final char myValueListDelimiter;
    private final char myValueNameDelimiter;
    private String myValue;
    private LinkedHashMap<String, String> myValues;

    private MutableAttributeImpl(String name, String value, char valueListDelimiter, char valueNameDelimiter) {
        this.myName = name;
        this.myValueListDelimiter = valueListDelimiter;
        this.myValueNameDelimiter = valueNameDelimiter;
        this.myValue = value == null ? "" : value;
        this.myValues = null;
    }

    @Override
    public char getValueListDelimiter() {
        return this.myValueListDelimiter;
    }

    @Override
    public char getValueNameDelimiter() {
        return this.myValueNameDelimiter;
    }

    @Override
    public Attribute toImmutable() {
        return AttributeImpl.of(this);
    }

    @Override
    public MutableAttribute toMutable() {
        return this;
    }

    @Override
    public MutableAttribute copy() {
        return MutableAttributeImpl.of(this);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getValue() {
        if (this.myValue == null) {
            this.myValue = this.valueFromMap();
        }
        return this.myValue;
    }

    public void resetToValuesMap() {
        if (this.myValues == null) {
            throw new IllegalStateException("resetToValuesMap called when myValues is null");
        }
        this.myValue = null;
    }

    protected Map<String, String> getValueMap() {
        if (this.myValues == null) {
            this.myValues = new LinkedHashMap();
            if (this.myValueListDelimiter != '\u0000') {
                if (!this.myValue.isEmpty()) {
                    int lastPos = 0;
                    while (lastPos < this.myValue.length()) {
                        int endPos;
                        int pos = this.myValue.indexOf(this.myValueListDelimiter, lastPos);
                        int n = endPos = pos == -1 ? this.myValue.length() : pos;
                        if (lastPos < endPos) {
                            int namePos;
                            String value = this.myValue.substring(lastPos, endPos);
                            int n2 = namePos = this.myValueNameDelimiter != '\u0000' ? value.indexOf(this.myValueNameDelimiter) : -1;
                            if (namePos == -1) {
                                this.myValues.put(value, "");
                            } else {
                                this.myValues.put(value.substring(0, namePos), value.substring(namePos + 1));
                            }
                        }
                        if (pos != -1) {
                            lastPos = endPos + 1;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.myValues.put(this.myValue, "");
            }
        }
        return this.myValues;
    }

    protected String valueFromMap() {
        if (this.myValueListDelimiter != '\u0000') {
            StringBuilder sb = new StringBuilder();
            if (this.myValueNameDelimiter != '\u0000') {
                for (Map.Entry<String, String> entry : this.myValues.entrySet()) {
                    if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) continue;
                    sb.append(entry.getKey()).append(this.myValueNameDelimiter).append(entry.getValue()).append(this.myValueListDelimiter);
                }
            } else {
                for (String key : this.myValues.keySet()) {
                    if (key.isEmpty()) continue;
                    sb.append(key).append(this.myValueListDelimiter);
                }
            }
            if (this.myValueListDelimiter == ' ' && sb.length() > 0) {
                sb.delete(sb.length() - 1, sb.length());
            }
            this.myValue = sb.toString();
        } else {
            this.myValue = this.myValues == null || this.myValues.isEmpty() ? "" : this.myValues.keySet().iterator().next();
        }
        return this.myValue;
    }

    @Override
    public boolean isNonRendering() {
        return this.myName.indexOf(32) != -1 || this.myValue.isEmpty() && NON_RENDERING_WHEN_EMPTY.contains(this.myName);
    }

    @Override
    public MutableAttributeImpl replaceValue(String value) {
        if (this.myValue == null || value == null || !this.myValue.equals(value)) {
            this.myValue = value == null ? "" : value;
            this.myValues = null;
        }
        return this;
    }

    @Override
    public MutableAttributeImpl setValue(String value) {
        if (this.myValueListDelimiter != '\u0000') {
            if (value != null && !value.isEmpty()) {
                final Map<String, String> valueMap = this.getValueMap();
                this.forEachValue(value, new BiConsumer<String, String>(){

                    @Override
                    public void accept(String itemName, String itemValue) {
                        if (MutableAttributeImpl.this.myValueNameDelimiter != '\u0000' && itemValue.isEmpty()) {
                            valueMap.remove(itemName);
                        } else {
                            valueMap.put(itemName, itemValue);
                        }
                    }
                });
                this.myValue = null;
            }
        } else if (this.myValue == null || value == null || !this.myValue.equals(value)) {
            this.myValue = value == null ? "" : value;
            this.myValues = null;
        }
        return this;
    }

    private void forEachValue(String value, BiConsumer<String, String> consumer) {
        int lastPos = 0;
        while (lastPos < value.length()) {
            String valueItem;
            int endPos;
            int pos = value.indexOf(this.myValueListDelimiter, lastPos);
            int n = endPos = pos == -1 ? value.length() : pos;
            if (lastPos < endPos && !(valueItem = value.substring(lastPos, endPos).trim()).isEmpty()) {
                int namePos = this.myValueNameDelimiter == '\u0000' ? -1 : valueItem.indexOf(this.myValueNameDelimiter);
                String itemName = namePos == -1 ? valueItem : valueItem.substring(0, namePos);
                String itemValue = namePos == -1 ? "" : valueItem.substring(namePos + 1);
                consumer.accept(itemName, itemValue);
            }
            if (pos == -1) break;
            lastPos = endPos + 1;
        }
    }

    @Override
    public MutableAttributeImpl removeValue(String value) {
        if (this.myValueListDelimiter != '\u0000') {
            if (value != null && !value.isEmpty()) {
                final Map<String, String> valueMap = this.getValueMap();
                final boolean[] removed = new boolean[]{false};
                this.forEachValue(value, new BiConsumer<String, String>(){

                    @Override
                    public void accept(String itemName, String itemValue) {
                        if (valueMap.remove(itemName) != null) {
                            removed[0] = true;
                        }
                    }
                });
                if (removed[0]) {
                    this.myValue = null;
                }
            }
        } else if (this.myValue == null || !this.myValue.equals(value)) {
            this.myValue = "";
            this.myValues = null;
        }
        return this;
    }

    @Override
    public boolean containsValue(String value) {
        return AttributeImpl.indexOfValue(this.myValue, value, this.myValueListDelimiter, this.myValueNameDelimiter) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.myName.equals(attribute.getName())) {
            return false;
        }
        return this.getValue().equals(attribute.getValue());
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.getValue().hashCode();
        return result;
    }

    public String toString() {
        return "MutableAttributeImpl { myName='" + this.myName + '\'' + ", myValue='" + this.getValue() + '\'' + " }";
    }

    public static MutableAttributeImpl of(Attribute other) {
        return MutableAttributeImpl.of(other.getName(), other.getValue(), other.getValueListDelimiter(), other.getValueNameDelimiter());
    }

    public static MutableAttributeImpl of(String attrName) {
        return MutableAttributeImpl.of(attrName, attrName, '\u0000', '\u0000');
    }

    public static MutableAttributeImpl of(String attrName, String value) {
        return MutableAttributeImpl.of(attrName, value, '\u0000', '\u0000');
    }

    public static MutableAttributeImpl of(String attrName, String value, char valueListDelimiter) {
        return MutableAttributeImpl.of(attrName, value, valueListDelimiter, '\u0000');
    }

    public static MutableAttributeImpl of(String attrName, String value, char valueListDelimiter, char valueNameDelimiter) {
        if ("class".equals(attrName)) {
            return new MutableAttributeImpl(attrName, value, ' ', '\u0000');
        }
        if ("style".equals(attrName)) {
            return new MutableAttributeImpl(attrName, value, ';', ':');
        }
        return new MutableAttributeImpl(attrName, value, valueListDelimiter, valueNameDelimiter);
    }
}

