/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.FormattingAppendableImpl;
import com.vladsch.flexmark.util.html.HtmlFormattingAppendable;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.io.IOException;

public abstract class HtmlFormattingAppendableBase<T extends HtmlFormattingAppendableBase>
implements HtmlFormattingAppendable {
    private final FormattingAppendable out;
    private Attributes currentAttributes;
    private boolean indentIndentingChildren = false;
    private boolean lineOnChildText = false;
    private boolean withAttributes = false;

    public HtmlFormattingAppendableBase(Appendable out) {
        this(out, 0, false);
    }

    public HtmlFormattingAppendableBase(FormattingAppendable other, Appendable out, boolean inheritIndent) {
        this(out, inheritIndent ? other.getIndentPrefix().length() : 0, false);
    }

    public HtmlFormattingAppendableBase(Appendable out, int indentSize, boolean allFormatOptions) {
        this.out = new FormattingAppendableImpl(out, allFormatOptions);
        this.out.setIndentPrefix(RepeatedCharSequence.of(" ", indentSize).toString());
    }

    public HtmlFormattingAppendableBase(Appendable out, int indentSize, int formatOptions) {
        this.out = new FormattingAppendableImpl(out, formatOptions);
        this.out.setIndentPrefix(RepeatedCharSequence.of(" ", indentSize).toString());
    }

    protected abstract T chaining();

    public T openPre() {
        this.out.openPreFormatted(true);
        return this.chaining();
    }

    public T closePre() {
        this.out.closePreFormatted();
        return this.chaining();
    }

    @Override
    public boolean inPre() {
        return this.out.isPreFormatted();
    }

    private boolean haveOptions(int options) {
        return (this.out.getOptions() & options) != 0;
    }

    public T raw(String s) {
        this.out.append(s);
        return this.chaining();
    }

    public T rawPre(String s) {
        this.out.openPreFormatted(true).append(s).closePreFormatted();
        return this.chaining();
    }

    public T rawIndentedPre(String s) {
        CharSequence prefix = this.out.getPrefix();
        this.out.setPrefix(this.out.getTotalIndentPrefix());
        this.out.openPreFormatted(false).append(s).closePreFormatted();
        this.out.setPrefix(prefix);
        return this.chaining();
    }

    public T text(String text) {
        this.out.append(Escaping.escapeHtml(text, false));
        return this.chaining();
    }

    public T attr(String name, String value) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        this.currentAttributes.replaceValue(name, value);
        return this.chaining();
    }

    public T attr(Attribute attribute) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        this.currentAttributes.replaceValue(attribute.getName(), attribute.getValue());
        return this.chaining();
    }

    public T attr(Attributes attributes) {
        if (!attributes.isEmpty()) {
            if (this.currentAttributes == null) {
                this.currentAttributes = new Attributes(attributes);
            } else {
                this.currentAttributes.replaceValues(attributes);
            }
        }
        return this.chaining();
    }

    @Override
    public HtmlFormattingAppendable withAttr() {
        this.withAttributes = true;
        return this.chaining();
    }

    @Override
    public Attributes getAttributes() {
        return this.currentAttributes;
    }

    public T setAttributes(Attributes attributes) {
        this.currentAttributes = attributes;
        return this.chaining();
    }

    public T withCondLine() {
        this.lineOnChildText = true;
        return this.chaining();
    }

    public T withCondIndent() {
        this.indentIndentingChildren = true;
        return this.chaining();
    }

    public T tag(String name) {
        return (T)this.tag(name, false);
    }

    public T tagVoid(String name) {
        return (T)this.tag(name, true);
    }

    public T tag(String name, boolean voidElement) {
        Attributes attributes = null;
        if (this.withAttributes) {
            attributes = this.currentAttributes;
            this.currentAttributes = null;
            this.withAttributes = false;
        }
        this.out.append("<");
        this.out.append(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes.values()) {
                String attributeValue = attribute.getValue();
                if (attribute.isNonRendering()) continue;
                this.out.append(" ");
                this.out.append(Escaping.escapeHtml(attribute.getName(), true));
                this.out.append("=\"");
                this.out.append(Escaping.escapeHtml(attributeValue, true));
                this.out.append("\"");
            }
        }
        if (voidElement) {
            this.out.append(" />");
        } else {
            this.out.append(">");
        }
        return this.chaining();
    }

    public T tag(String name, boolean withIndent, boolean withLine, Runnable runnable) {
        if (withIndent) {
            this.out.willIndent();
            this.out.line();
        }
        this.tag(name, false);
        if (withIndent) {
            this.out.indent();
        }
        final boolean isLineOnChildText = this.lineOnChildText;
        final boolean isIndentIndentingChildren = this.indentIndentingChildren;
        this.lineOnChildText = false;
        this.indentIndentingChildren = false;
        if (isLineOnChildText || isIndentIndentingChildren) {
            this.out.openConditional(new ConditionalFormatter(){

                @Override
                public void apply(boolean firstAppend, boolean onIndent, boolean onLine, boolean onText) {
                    if (onIndent) {
                        if (isIndentIndentingChildren) {
                            HtmlFormattingAppendableBase.this.out.indent();
                        } else {
                            HtmlFormattingAppendableBase.this.out.line();
                        }
                    } else if (firstAppend) {
                        if (isLineOnChildText) {
                            HtmlFormattingAppendableBase.this.out.line();
                        } else if (onLine) {
                            HtmlFormattingAppendableBase.this.out.line();
                        }
                    }
                }
            });
        }
        runnable.run();
        if (isLineOnChildText || isIndentIndentingChildren) {
            this.out.closeConditional(new ConditionalFormatter(){

                @Override
                public void apply(boolean firstAppend, boolean onIndent, boolean onLine, boolean onText) {
                    if (onIndent) {
                        if (isIndentIndentingChildren) {
                            HtmlFormattingAppendableBase.this.out.unIndent();
                        }
                    } else if (onText && isLineOnChildText) {
                        HtmlFormattingAppendableBase.this.out.line();
                    }
                }
            });
        }
        if (withIndent) {
            this.out.unIndent();
        }
        if (withLine) {
            this.out.line();
        }
        this.out.append("</");
        this.out.append(name);
        this.out.append(">");
        if (withIndent) {
            this.line();
        }
        return this.chaining();
    }

    public T tagVoidLine(String name) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.line()).tagVoid(name)).line();
        return this.chaining();
    }

    public T tagLine(String name) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.line()).tag(name)).line();
        return this.chaining();
    }

    public T tagLine(String name, boolean voidElement) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.line()).tag(name, voidElement)).line();
        return this.chaining();
    }

    public T tagLine(String name, Runnable runnable) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.line()).tag(name, false, false, runnable)).line();
        return this.chaining();
    }

    public T tagIndent(String name, Runnable runnable) {
        this.tag(name, true, false, runnable);
        return this.chaining();
    }

    public T tagLineIndent(String name, Runnable runnable) {
        this.tag(name, true, true, runnable);
        return this.chaining();
    }

    @Override
    public int getOptions() {
        return this.out.getOptions();
    }

    public T setOptions(int options) {
        this.out.setOptions(options);
        return this.chaining();
    }

    @Override
    public int getModCount() {
        return this.out.getModCount();
    }

    @Override
    public boolean isPreFormatted() {
        return this.out.isPreFormatted();
    }

    public T line() {
        this.out.line();
        return this.chaining();
    }

    public T blankLine() {
        this.out.blankLine();
        return this.chaining();
    }

    public T lineIf(boolean predicate) {
        this.out.lineIf(predicate);
        return this.chaining();
    }

    public T indent() {
        this.out.indent();
        return this.chaining();
    }

    public T willIndent() {
        this.out.willIndent();
        return this.chaining();
    }

    public T unIndent() {
        this.out.unIndent();
        return this.chaining();
    }

    @Override
    public IOException getIOException() {
        return this.out.getIOException();
    }

    public T append(CharSequence csq) {
        this.out.append(csq);
        return this.chaining();
    }

    public T append(CharSequence csq, int start, int end) {
        this.out.append(csq, start, end);
        return this.chaining();
    }

    public T append(char c) {
        this.out.append(c);
        return this.chaining();
    }

    public T flush() {
        this.out.flush();
        return this.chaining();
    }

    public T flush(int maxBlankLines) {
        this.out.flush(maxBlankLines);
        return this.chaining();
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.out.getIndentPrefix();
    }

    public T setIndentPrefix(CharSequence prefix) {
        this.out.setIndentPrefix(prefix);
        return this.chaining();
    }

    @Override
    public CharSequence getPrefix() {
        return this.out.getPrefix();
    }

    public T setPrefix(CharSequence prefix) {
        this.out.setPrefix(prefix);
        return this.chaining();
    }

    @Override
    public CharSequence getTotalIndentPrefix() {
        return this.out.getTotalIndentPrefix();
    }

    public T line(Ref<Boolean> lineRef) {
        this.out.line(lineRef);
        return this.chaining();
    }

    public T lineIf(Ref<Boolean> lineRef) {
        this.out.lineIf(lineRef);
        return this.chaining();
    }

    public T blankLineIf(boolean predicate) {
        this.out.blankLineIf(predicate);
        return this.chaining();
    }

    public T blankLine(int count) {
        this.out.blankLine(count);
        return this.chaining();
    }

    @Override
    public int getIndent() {
        return this.out.getIndent();
    }

    public T setIndentOffset(int indentOffset) {
        this.out.setIndentOffset(indentOffset);
        return this.chaining();
    }

    @Override
    public int getLineCount() {
        return this.out.getLineCount();
    }

    @Override
    public int getOffsetBefore() {
        return this.out.getOffsetBefore();
    }

    @Override
    public int getOffsetAfter() {
        return this.out.getOffsetAfter();
    }

    public T openPreFormatted(boolean keepIndent) {
        this.out.openPreFormatted(true);
        return this.chaining();
    }

    public T closePreFormatted() {
        this.out.closePreFormatted();
        return this.chaining();
    }

    public T openConditional(ConditionalFormatter openFormatter) {
        this.out.openConditional(openFormatter);
        return this.chaining();
    }

    public T closeConditional(ConditionalFormatter closeFormatter) {
        this.out.closeConditional(closeFormatter);
        return this.chaining();
    }
}

