/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Html5Entities;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final String XML_SPECIAL = "[&<>\"]";
    private static final Pattern XML_SPECIAL_RE = Pattern.compile("[&<>\"]");
    private static final Pattern XML_SPECIAL_OR_ENTITY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});|[&<>\"]", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Replacer UNSAFE_CHAR_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            switch (input) {
                case "&": {
                    sb.append("&amp;");
                    break;
                }
                case "<": {
                    sb.append("&lt;");
                    break;
                }
                case ">": {
                    sb.append("&gt;");
                    break;
                }
                case "\"": {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(input);
                }
            }
        }

        @Override
        public void replace(BasedSequence input, ReplacedTextMapper textMapper) {
            switch (input.toString()) {
                case "&": {
                    textMapper.addReplacedText(input, PrefixedSubSequence.of("&amp;", BasedSequence.NULL));
                    break;
                }
                case "<": {
                    textMapper.addReplacedText(input, PrefixedSubSequence.of("&lt;", BasedSequence.NULL));
                    break;
                }
                case ">": {
                    textMapper.addReplacedText(input, PrefixedSubSequence.of("&gt;", BasedSequence.NULL));
                    break;
                }
                case "\"": {
                    textMapper.addReplacedText(input, PrefixedSubSequence.of("&quot;", BasedSequence.NULL));
                    break;
                }
                default: {
                    textMapper.addOriginalText(input);
                }
            }
        }
    };
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            if (input.charAt(0) == '\\') {
                sb.append(input, 1, input.length());
            } else {
                sb.append(Html5Entities.entityToString(input));
            }
        }

        @Override
        public void replace(BasedSequence input, ReplacedTextMapper textMapper) {
            if (input.charAt(0) == '\\') {
                textMapper.addReplacedText(input, input.subSequence(1, input.length()));
            } else {
                textMapper.addReplacedText(input, Html5Entities.entityToSequence(input));
            }
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            if (input.startsWith("%")) {
                if (input.length() == 3) {
                    sb.append(input);
                } else {
                    sb.append("%25");
                    sb.append(input, 1, input.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = input.getBytes(Charset.forName("UTF-8"))) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }

        @Override
        public void replace(BasedSequence input, ReplacedTextMapper textMapper) {
            if (input.startsWith("%")) {
                if (input.length() == 3) {
                    textMapper.addOriginalText(input);
                } else {
                    textMapper.addReplacedText(input.subSequence(0, 1), PrefixedSubSequence.of("%25", BasedSequence.NULL));
                    textMapper.addOriginalText(input.subSequence(1, input.length()));
                }
            } else {
                byte[] bytes = input.toString().getBytes(Charset.forName("UTF-8"));
                StringBuilder sbItem = new StringBuilder();
                for (byte b : bytes) {
                    sbItem.append('%');
                    sbItem.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sbItem.append(HEX_DIGITS[b & 0xF]);
                }
                textMapper.addReplacedText(input, PrefixedSubSequence.of(sbItem.toString(), BasedSequence.NULL));
            }
        }
    };

    public static String escapeHtml(String input, boolean preserveEntities) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, input, UNSAFE_CHAR_REPLACER);
    }

    public static BasedSequence escapeHtml(BasedSequence input, boolean preserveEntities, ReplacedTextMapper textMapper) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, input, UNSAFE_CHAR_REPLACER, textMapper);
    }

    public static String unescapeString(String s) {
        if (BACKSLASH_OR_AMP.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return s;
    }

    public static BasedSequence unescape(BasedSequence s, ReplacedTextMapper textMapper) {
        int indexOfAny = s.indexOfAny('\\', '&');
        if (indexOfAny != -1) {
            textMapper.addOriginalText(s.subSequence(0, indexOfAny));
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s.subSequence(indexOfAny), UNESCAPE_REPLACER, textMapper);
        }
        return s;
    }

    public static String normalizeEndWithEOL(CharSequence input) {
        return Escaping.normalizeEOL(input, true);
    }

    public static String normalizeEOL(CharSequence input) {
        return Escaping.normalizeEOL(input, false);
    }

    public static String normalizeEOL(CharSequence input, boolean endWithEOL) {
        StringBuilder sb = new StringBuilder(input.length());
        int iMax = input.length();
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = input.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                sb.append("\n");
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (hadCR) {
                sb.append('\n');
            }
            sb.append(c);
            hadCR = false;
            hadEOL = false;
        }
        if (endWithEOL && !hadEOL) {
            sb.append('\n');
        }
        return sb.toString();
    }

    public static BasedSequence normalizeEndWithEOL(BasedSequence input, ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(input, textMapper, true);
    }

    public static BasedSequence normalizeEOL(BasedSequence input, ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(input, textMapper, false);
    }

    public static BasedSequence normalizeEOL(BasedSequence input, ReplacedTextMapper textMapper, boolean endWithEOL) {
        int iMax = input.length();
        int lastPos = 0;
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = input.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                if (!hadCR) continue;
                if (lastPos < i - 1) {
                    textMapper.addOriginalText(input.subSequence(lastPos, i - 1));
                }
                lastPos = i;
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (!hadCR) continue;
            if (lastPos < i - 1) {
                textMapper.addOriginalText(input.subSequence(lastPos, i + 1));
            }
            textMapper.addReplacedText(input.subSequence(i - 1, i), BasedSequence.EOL);
            lastPos = i;
            hadCR = false;
            hadEOL = false;
        }
        if (!hadCR) {
            if (lastPos < iMax) {
                textMapper.addOriginalText(input.subSequence(lastPos, iMax));
            }
            if (!hadEOL && endWithEOL) {
                textMapper.addReplacedText(input.subSequence(iMax - 1, iMax), BasedSequence.EOL);
            }
        }
        return textMapper.getReplacedSequence();
    }

    public static String percentEncodeUrl(String s) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s, URI_REPLACER);
    }

    public static String normalizeReference(CharSequence input, boolean changeCase) {
        if (changeCase) {
            return Escaping.collapseWhitespace(input.toString(), true).toLowerCase();
        }
        return Escaping.collapseWhitespace(input.toString(), true);
    }

    public static String normalizeReferenceChars(CharSequence input, boolean changeCase) {
        if (input.length() > 1) {
            int stripEnd = input.charAt(input.length() - 1) == ':' ? 2 : 1;
            int stripStart = input.charAt(0) == '!' ? 2 : 1;
            return Escaping.normalizeReference(input.subSequence(stripStart, input.length() - stripEnd), changeCase);
        }
        return input.toString();
    }

    public static String collapseWhitespace(CharSequence input, boolean trim) {
        StringBuilder sb = new StringBuilder(input.length());
        int iMax = input.length();
        boolean hadSpace = false;
        for (int i = 0; i < iMax; ++i) {
            char c = input.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                hadSpace = true;
                continue;
            }
            if (hadSpace && (!trim || sb.length() > 0)) {
                sb.append(' ');
            }
            sb.append(c);
            hadSpace = false;
        }
        if (hadSpace && !trim) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String replaceAll(Pattern p, String s, Replacer replacer) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            sb.append(s, lastEnd, s.length());
        }
        return sb.toString();
    }

    private static BasedSequence replaceAll(Pattern p, BasedSequence s, Replacer replacer, ReplacedTextMapper textMapper) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            textMapper.addOriginalText(s);
            return s;
        }
        int lastEnd = 0;
        do {
            textMapper.addOriginalText(s.subSequence(lastEnd, matcher.start()));
            replacer.replace(s.subSequence(matcher.start(), matcher.end()), textMapper);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            textMapper.addOriginalText(s.subSequence(lastEnd, s.length()));
        }
        return textMapper.getReplacedSequence();
    }

    static interface Replacer {
        public void replace(String var1, StringBuilder var2);

        public void replace(BasedSequence var1, ReplacedTextMapper var2);
    }
}

