/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class PrefixedSubSequence
extends SubSequence {
    private final String prefix;
    private final int prefixLength;

    public PrefixedSubSequence(String prefix, CharSequence base) {
        this(prefix, base, 0, base.length());
    }

    public PrefixedSubSequence(String prefix, CharSequence base, int startOffset, int endOffset) {
        super(base, startOffset, endOffset);
        this.prefix = prefix;
        this.prefixLength = prefix.length();
    }

    public PrefixedSubSequence(String prefix, BasedSequence charSequence) {
        this(prefix, charSequence.getBase(), charSequence.getStartOffset(), charSequence.getEndOffset());
    }

    public PrefixedSubSequence(String prefix, BasedSequence charSequence, int startOffset, int endOffset) {
        super(charSequence.getBase(), startOffset, endOffset);
        this.prefix = prefix;
        this.prefixLength = prefix.length();
    }

    public PrefixedSubSequence(String prefix, PrefixedSubSequence subSequence) {
        this(prefix + subSequence.prefix, subSequence.base, subSequence.startOffset, subSequence.endOffset);
    }

    @Override
    public int length() {
        return this.prefixLength + super.length();
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < this.prefixLength) {
            return -1;
        }
        return super.getIndexOffset(index - this.prefixLength);
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || this.startOffset + index >= this.endOffset + this.prefixLength) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + index);
        }
        if (index < this.prefixLength) {
            return this.prefix.charAt(index);
        }
        return super.charAt(index - this.prefixLength);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start < 0 || this.startOffset + start > this.endOffset + this.prefixLength) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || this.startOffset + end > this.endOffset + this.prefixLength) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        if (start < this.prefixLength) {
            if (end <= this.prefixLength) {
                return new PrefixedSubSequence(this.prefix.substring(start, end), this.base, this.startOffset, this.startOffset);
            }
            return new PrefixedSubSequence(this.prefix.substring(start), this.base, this.startOffset, this.startOffset + end - this.prefixLength);
        }
        return new SubSequence(this.base, this.startOffset + start - this.prefixLength, this.startOffset + end - this.prefixLength);
    }

    @Override
    public String toString() {
        return this.prefix + String.valueOf(this.base.subSequence(this.startOffset, this.endOffset));
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }
}

