/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.List;

public class SegmentedSequence
extends BasedSequenceImpl {
    protected final CharSequence base;
    protected final char[] nonBaseChars;
    protected final int[] baseOffsets;
    protected final int baseStartOffset;
    protected final int length;

    @Override
    public CharSequence getBase() {
        return this.base;
    }

    @Override
    public int getStartOffset() {
        int iMax = this.baseOffsets.length;
        if (this.nonBaseChars != null) {
            for (int i = this.baseStartOffset; i < iMax; ++i) {
                if (this.baseOffsets[i] < 0) continue;
                return this.baseOffsets[i];
            }
            return 0;
        }
        return iMax > 0 ? this.baseOffsets[this.baseStartOffset] : 0;
    }

    @Override
    public int getEndOffset() {
        int iMax = this.baseOffsets.length;
        if (this.nonBaseChars != null) {
            int i = iMax;
            while (i-- > this.baseStartOffset) {
                if (this.baseOffsets[i] < 0) continue;
                return this.baseOffsets[i];
            }
            return 0;
        }
        if (this.length == 0) {
            return iMax > 0 ? this.baseOffsets[this.baseStartOffset] : 0;
        }
        return iMax > 0 ? this.baseOffsets[this.baseStartOffset + this.length - 1] + 1 : 0;
    }

    public int[] getBaseOffsets() {
        return this.baseOffsets;
    }

    public int getBaseStartOffset() {
        return this.baseStartOffset;
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        if (index == this.length) {
            if (index == 0) {
                throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
            }
            int offset = this.baseOffsets[this.baseStartOffset + index - 1];
            if (offset < 0) {
                return -1;
            }
            return offset + 1;
        }
        int offset = this.baseOffsets[this.baseStartOffset + index];
        return offset < 0 ? -1 : offset;
    }

    public static BasedSequence of(List<BasedSequence> segments, BasedSequence empty) {
        if (segments.size() == 0) {
            return empty;
        }
        BasedSequence lastSegment = null;
        BasedSequence firstSegment = segments.get(0);
        CharSequence base = firstSegment.getBase();
        ArrayList<BasedSequence> mergedSequences = new ArrayList<BasedSequence>();
        for (BasedSequence basedSequence : segments) {
            assert (base == basedSequence.getBase()) : "all segments must come from the same base sequence";
            if (basedSequence instanceof PrefixedSubSequence || basedSequence instanceof SegmentedSequence) {
                if (lastSegment != null) {
                    mergedSequences.add(lastSegment);
                }
                mergedSequences.add(basedSequence);
                lastSegment = null;
                continue;
            }
            if (lastSegment == null) {
                lastSegment = basedSequence;
                continue;
            }
            if (lastSegment.getEndOffset() != basedSequence.getStartOffset()) {
                mergedSequences.add(lastSegment);
                lastSegment = basedSequence;
                continue;
            }
            lastSegment = lastSegment.baseSubSequence(lastSegment.getStartOffset(), basedSequence.getEndOffset());
        }
        if (lastSegment != null) {
            mergedSequences.add(lastSegment);
        }
        if (mergedSequences.size() == 1) {
            return (BasedSequence)mergedSequences.get(0);
        }
        return new SegmentedSequence(mergedSequences);
    }

    private SegmentedSequence(List<BasedSequence> segments) {
        this.base = segments.get(0).getBase();
        int length = 0;
        CharSequence base = segments.size() > 0 ? segments.get(0).getBase() : null;
        for (BasedSequence basedSequence : segments) {
            assert (base == basedSequence.getBase()) : "all segments must come from the same base sequence";
            assert (basedSequence.getStartOffset() >= length) : "segments must be in increasing index order from base sequence start=" + basedSequence.getStartOffset() + ", length=" + length;
            length += basedSequence.length();
        }
        this.baseStartOffset = 0;
        this.length = length;
        this.baseOffsets = new int[length];
        int i = 0;
        length = 0;
        StringBuilder sb = null;
        for (BasedSequence basedSequence : segments) {
            int ciMax = basedSequence.length();
            for (int ci = 0; ci < ciMax; ++ci) {
                int offset = basedSequence.getIndexOffset(ci);
                if (offset < 0) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(basedSequence.charAt(ci));
                    offset = -sb.length();
                }
                this.baseOffsets[ci + length] = offset;
            }
            length += ciMax;
            ++i;
        }
        this.nonBaseChars = (char[])(sb != null ? sb.toString().toCharArray() : null);
    }

    private SegmentedSequence(CharSequence base, int[] baseOffsets, int baseStartOffset, char[] nonBaseChars, int length) {
        this.base = base;
        this.baseOffsets = baseOffsets;
        this.baseStartOffset = baseStartOffset;
        this.nonBaseChars = nonBaseChars;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        int offset = this.baseOffsets[this.baseStartOffset + index];
        if (offset < 0) {
            return this.nonBaseChars[-offset - 1];
        }
        return this.base.charAt(offset);
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || end > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        return new SubSequence(this.base, start, end);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start < 0 || start > this.length) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || end > this.length) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        if (this.nonBaseChars != null) {
            return new SegmentedSequence(this.base, this.baseOffsets, this.baseStartOffset + start, this.nonBaseChars, end - start);
        }
        return new SegmentedSequence(this.base, this.baseOffsets, this.baseStartOffset + start, this.nonBaseChars, end - start);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }
}

