/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.dependency;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.dependency.Dependent;
import com.vladsch.flexmark.util.dependency.DependentItem;
import com.vladsch.flexmark.util.dependency.DependentItemMap;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DependencyHandler<D extends Dependent<D>, S, R extends ResolvedDependencies<S>> {
    protected abstract S createStage(List<D> var1);

    protected abstract Class<? extends D> getDependentClass(D var1);

    protected abstract R createResolvedDependencies(List<S> var1);

    public R resolveDependencies(List<D> dependentsList) {
        if (dependentsList.size() == 0) {
            return this.createResolvedDependencies(Collections.EMPTY_LIST);
        }
        if (dependentsList.size() == 1) {
            HashMap nodeMap = new HashMap();
            Dependent dependent = (Dependent)dependentsList.get(0);
            List<Dependent> dependents = Collections.singletonList(dependent);
            return this.createResolvedDependencies(Collections.singletonList(this.createStage(dependents)));
        }
        int dependentCount = dependentsList.size();
        DependentItemMap dependentItemMap = new DependentItemMap(dependentCount);
        for (Dependent dependent : dependentsList) {
            Class<Dependent> dependentClass = this.getDependentClass(dependent);
            if (dependentItemMap.containsKey(dependentClass)) {
                throw new IllegalStateException("Dependent class " + dependentClass + " is duplicated. Only one instance can be present in the list");
            }
            DependentItem<Dependent> item2 = new DependentItem<Dependent>(dependentItemMap.size(), dependent, this.getDependentClass(dependent), dependent.affectsGlobalScope());
            dependentItemMap.put(dependentClass, item2);
        }
        for (Map.Entry entry : dependentItemMap) {
            Set beforeDependents;
            Class dependentClass22;
            DependentItem item3 = (DependentItem)entry.getValue();
            Set afterDependencies = ((Dependent)item3.dependent).getAfterDependents();
            if (afterDependencies != null && afterDependencies.size() > 0) {
                for (Class dependentClass22 : afterDependencies) {
                    DependentItem dependentItem = (DependentItem)dependentItemMap.get(dependentClass22);
                    if (dependentItem == null) continue;
                    item3.addDependency(dependentItem);
                    dependentItem.addDependent(item3);
                }
            }
            if ((beforeDependents = ((Dependent)item3.dependent).getBeforeDependents()) == null || beforeDependents.size() <= 0) continue;
            dependentClass22 = beforeDependents.iterator();
            while (dependentClass22.hasNext()) {
                Class dependentClass3 = (Class)dependentClass22.next();
                DependentItem dependentItem = (DependentItem)dependentItemMap.get(dependentClass3);
                if (dependentItem == null) continue;
                dependentItem.addDependency(item3);
                item3.addDependent(dependentItem);
            }
        }
        dependentItemMap = this.prioritize(dependentItemMap);
        dependentCount = dependentItemMap.size();
        BitSet newReady = new BitSet(dependentCount);
        Ref<BitSet> ref = new Ref<BitSet>(newReady);
        dependentItemMap.valueIterator().forEachRemaining(item -> {
            if (!item.hasDependencies()) {
                ((BitSet)newReadyRef.value).set(item.index);
            }
        });
        BitSet dependents = new BitSet(dependentCount);
        dependents.set(0, dependentItemMap.size());
        ArrayList<S> dependencyStages = new ArrayList<S>();
        while (newReady.nextSetBit(0) != -1) {
            int i;
            ArrayList stageDependents = new ArrayList();
            BitSet nextDependents = new BitSet();
            while ((i = newReady.nextSetBit(0)) >= 0) {
                newReady.clear(i);
                DependentItem item4 = (DependentItem)dependentItemMap.getValue(i);
                stageDependents.add(item4.dependent);
                dependents.clear(i);
                if (item4.hasDependents()) {
                    int j;
                    while ((j = item4.dependents.nextSetBit(0)) >= 0) {
                        item4.dependents.clear(j);
                        DependentItem dependentItem = (DependentItem)dependentItemMap.getValue(j);
                        if (dependentItem.removeDependency(item4)) continue;
                        if (item4.isGlobalScope) {
                            nextDependents.set(j);
                            continue;
                        }
                        newReady.set(j);
                    }
                    continue;
                }
                if (!item4.isGlobalScope) continue;
                nextDependents.or(newReady);
                break;
            }
            newReady = nextDependents;
            dependencyStages.add(this.createStage(stageDependents));
        }
        if (dependents.nextSetBit(0) != -1) {
            throw new IllegalStateException("have dependents with dependency cycles" + dependents);
        }
        return this.createResolvedDependencies(dependencyStages);
    }

    protected DependentItemMap<D> prioritize(DependentItemMap<D> dependentMap) {
        return dependentMap;
    }
}

