/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.OrderedMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.mappers.NodeClassifier;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClassifyingNodeTracker
implements NodeTracker {
    protected final ClassificationBag<Class<?>, Node> myNodeClassifier;
    private final NodeTracker myHost;
    private final OrderedMap<Class<?>, Set<Class<?>>> myExclusionMap;
    private final OrderedSet<Class<?>> myExclusionSet;
    private final HashMap<Integer, BitSet> myNodeAncestryMap;

    public ClassifyingNodeTracker(NodeTracker host, Map<Class<? extends Node>, Set<Class<?>>> exclusionMap) {
        this.myHost = host;
        this.myNodeClassifier = new ClassificationBag(NodeClassifier.INSTANCE);
        this.myExclusionMap = new OrderedMap(exclusionMap.size());
        this.myExclusionMap.putAll(exclusionMap);
        this.myExclusionSet = new OrderedSet();
        this.myExclusionMap.valueIterable().forEach(this.myExclusionSet::addAll);
        this.myNodeAncestryMap = new HashMap();
    }

    public OrderedMap<Class<?>, Set<Class<?>>> getExclusionMap() {
        return this.myExclusionMap;
    }

    public HashMap<Integer, BitSet> getNodeAncestryMap() {
        return this.myNodeAncestryMap;
    }

    public OrderedSet<Class<?>> getExclusionSet() {
        return this.myExclusionSet;
    }

    public ClassificationBag<Class<?>, Node> getNodeClassifier() {
        return this.myNodeClassifier;
    }

    private void validateLinked(Node node) {
        if (node.getNext() == null && node.getParent() == null) {
            throw new IllegalStateException("Added block " + node + " is not linked into the AST");
        }
    }

    @Override
    public void nodeAdded(Node node) {
        this.validateLinked(node);
        this.myNodeClassifier.add(node);
        if (this.myHost != null) {
            this.myHost.nodeAdded(node);
        }
    }

    @Override
    public void nodeAddedWithChildren(Node node) {
        this.validateLinked(node);
        this.myNodeClassifier.add(node);
        this.addNodes(node.getChildren());
        if (this.myHost != null) {
            this.myHost.nodeAddedWithChildren(node);
        }
    }

    @Override
    public void nodeAddedWithDescendants(Node node) {
        this.validateLinked(node);
        this.myNodeClassifier.add(node);
        this.addNodes(node.getDescendants());
        if (this.myHost != null) {
            this.myHost.nodeAddedWithDescendants(node);
        }
    }

    private void addNodes(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            this.myNodeClassifier.add(child);
        }
    }

    private void validateUnlinked(Node node) {
        if (node.getNext() != null || node.getParent() != null) {
            throw new IllegalStateException("Removed block " + node + " is still linked in the AST");
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        this.nodeRemovedWithDescendants(node);
    }

    @Override
    public void nodeRemovedWithChildren(Node node) {
        this.nodeRemovedWithDescendants(node);
    }

    @Override
    public void nodeRemovedWithDescendants(Node node) {
        this.validateUnlinked(node);
        this.myNodeClassifier.add(node);
        this.removeNodes(node.getDescendants());
        if (this.myHost != null) {
            this.myHost.nodeRemovedWithDescendants(node);
        }
    }

    private void removeNodes(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            this.myNodeClassifier.add(child);
        }
    }

    public OrderedSet<Node> getItems() {
        return this.myNodeClassifier.getItems();
    }

    public <X> ReversibleIterable<X> getCategoryItems(Class<? extends X> nodeClass, Set<? extends Class<?>> classes) {
        return this.myNodeClassifier.getCategoryItems(nodeClass, (Collection<Class<?>>)classes);
    }
}

