/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class BitSetIterator
implements ReversibleIterator<Integer> {
    private final BitSet myBitSet;
    private final boolean myIsReversed;
    private int myNext;
    private int myLast;

    public BitSetIterator(BitSet bitSet) {
        this(bitSet, false);
    }

    public BitSetIterator(BitSet bitSet, boolean reversed) {
        this.myBitSet = bitSet;
        this.myIsReversed = reversed;
        this.myNext = reversed ? bitSet.previousSetBit(bitSet.length()) : bitSet.nextSetBit(0);
        this.myLast = -1;
    }

    @Override
    public boolean isReversed() {
        return this.myIsReversed;
    }

    @Override
    public boolean hasNext() {
        return this.myNext != -1;
    }

    @Override
    public Integer next() {
        if (this.myNext == -1) {
            throw new NoSuchElementException();
        }
        this.myLast = this.myNext;
        this.myNext = this.myIsReversed ? (this.myNext == 0 ? -1 : this.myBitSet.previousSetBit(this.myNext - 1)) : this.myBitSet.nextSetBit(this.myNext + 1);
        return this.myLast;
    }

    @Override
    public void remove() {
        if (this.myLast == -1) {
            throw new NoSuchElementException();
        }
        this.myBitSet.clear(this.myLast);
    }

    @Override
    public void forEachRemaining(Consumer<? super Integer> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

