/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.dependency;

import java.util.BitSet;

public class DependentItem<D> {
    public final int index;
    public final D dependent;
    public final Class<? extends D> dependentClass;
    public final boolean isGlobalScope;
    BitSet dependencies;
    BitSet dependents;

    public DependentItem(int index, D dependent, Class<? extends D> dependentClass, boolean isGlobalScope) {
        this.index = index;
        this.dependent = dependent;
        this.dependentClass = dependentClass;
        this.isGlobalScope = isGlobalScope;
    }

    public void addDependency(DependentItem<D> dependency) {
        if (this.dependencies == null) {
            this.dependencies = new BitSet();
        }
        this.dependencies.set(dependency.index);
    }

    public void addDependency(BitSet dependencies) {
        if (this.dependencies == null) {
            this.dependencies = new BitSet();
        }
        this.dependencies.or(dependencies);
    }

    public boolean removeDependency(DependentItem<D> dependency) {
        if (this.dependencies != null) {
            this.dependencies.clear(dependency.index);
        }
        return this.hasDependencies();
    }

    public boolean removeDependency(BitSet dependencies) {
        if (this.dependencies != null) {
            this.dependencies.andNot(dependencies);
        }
        return this.hasDependencies();
    }

    public void addDependent(DependentItem<D> dependent) {
        if (this.dependents == null) {
            this.dependents = new BitSet();
        }
        this.dependents.set(dependent.index);
    }

    public void addDependent(BitSet dependents) {
        if (this.dependents == null) {
            this.dependents = new BitSet();
        }
        this.dependents.or(dependents);
    }

    public void removeDependent(DependentItem<D> dependent) {
        if (this.dependents != null) {
            this.dependents.clear(dependent.index);
        }
    }

    public void removeDependent(BitSet dependents) {
        if (this.dependents != null) {
            this.dependents.andNot(dependents);
        }
    }

    public boolean hasDependencies() {
        return this.dependencies != null && this.dependencies.nextSetBit(0) != -1;
    }

    public boolean hasDependents() {
        return this.dependents != null && this.dependents.nextSetBit(0) != -1;
    }
}

