/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;

public class TableFormatOptions
implements MutableDataSetter {
    public static final char INTELLIJ_DUMMY_IDENTIFIER_CHAR = '\u001f';
    public static final String INTELLIJ_DUMMY_IDENTIFIER = "\u001f";
    public static final DataKey<Boolean> FORMAT_TABLE_LEAD_TRAIL_PIPES = new DataKey<Boolean>("FORMAT_TABLE_LEAD_TRAIL_PIPES", true);
    public static final DataKey<Boolean> FORMAT_TABLE_SPACE_AROUND_PIPES = new DataKey<Boolean>("FORMAT_TABLE_SPACE_AROUND_PIPES", true);
    public static final DataKey<Boolean> FORMAT_TABLE_ADJUST_COLUMN_WIDTH = new DataKey<Boolean>("FORMAT_TABLE_ADJUST_COLUMN_WIDTH", true);
    public static final DataKey<Boolean> FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT = new DataKey<Boolean>("FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT", true);
    public static final DataKey<Boolean> FORMAT_TABLE_FILL_MISSING_COLUMNS = new DataKey<Boolean>("FORMAT_TABLE_FILL_MISSING_COLUMNS", false);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_LEFT_ALIGN_MARKER = new DataKey<DiscretionaryText>("FORMAT_TABLE_LEFT_ALIGN_MARKER", DiscretionaryText.AS_IS);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH = new DataKey<Integer>("FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH", 3);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_DASHES = new DataKey<Integer>("FORMAT_TABLE_MIN_SEPARATOR_DASHES", 1);
    public static final DataKey<Boolean> FORMAT_TABLE_TRIM_CELL_WHITESPACE = new DataKey<Boolean>("FORMAT_TABLE_TRIM_CELL_WHITESPACE", true);
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = new DataKey<TableCaptionHandling>("FORMAT_TABLE_CAPTION", TableCaptionHandling.AS_IS);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = new DataKey<DiscretionaryText>("FORMAT_TABLE_CAPTION_SPACES", DiscretionaryText.AS_IS);
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = new DataKey<String>("FORMAT_TABLE_INDENT_PREFIX", "");
    public static final DataKey<TableManipulator> FORMAT_TABLE_MANIPULATOR = new DataKey<TableManipulator>("FORMAT_TABLE_MANIPULATOR", TableManipulator.NULL);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = new DataKey<CharWidthProvider>("FORMAT_CHAR_WIDTH_PROVIDER", CharWidthProvider.NULL);
    public static final DataKey<Boolean> FORMAT_TABLE_DUMP_TRACKING_OFFSETS = new DataKey<Boolean>("FORMAT_TABLE_DUMP_TRACKING_OFFSETS", false);
    @Deprecated
    public static final DataKey<Boolean> REMOVE_CAPTION = new DataKey<Boolean>("REMOVE_CAPTION", false);
    @Deprecated
    public static final DataKey<Boolean> LEAD_TRAIL_PIPES = FORMAT_TABLE_LEAD_TRAIL_PIPES;
    @Deprecated
    public static final DataKey<Boolean> SPACE_AROUND_PIPES = FORMAT_TABLE_SPACE_AROUND_PIPES;
    @Deprecated
    public static final DataKey<Boolean> ADJUST_COLUMN_WIDTH = FORMAT_TABLE_ADJUST_COLUMN_WIDTH;
    @Deprecated
    public static final DataKey<Boolean> APPLY_COLUMN_ALIGNMENT = FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT;
    @Deprecated
    public static final DataKey<Boolean> FILL_MISSING_COLUMNS = FORMAT_TABLE_FILL_MISSING_COLUMNS;
    @Deprecated
    public static final DataKey<DiscretionaryText> LEFT_ALIGN_MARKER = FORMAT_TABLE_LEFT_ALIGN_MARKER;
    @Deprecated
    public static final DataKey<Integer> MIN_SEPARATOR_COLUMN_WIDTH = FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH;
    @Deprecated
    public static final DataKey<Integer> MIN_SEPARATOR_DASHES = FORMAT_TABLE_MIN_SEPARATOR_DASHES;
    @Deprecated
    public static final DataKey<Boolean> TRIM_CELL_WHITESPACE = FORMAT_TABLE_TRIM_CELL_WHITESPACE;
    @Deprecated
    public static final DataKey<CharWidthProvider> CHAR_WIDTH_PROVIDER = FORMAT_CHAR_WIDTH_PROVIDER;
    public final boolean leadTrailPipes;
    public final boolean spaceAroundPipes;
    public final boolean adjustColumnWidth;
    public final boolean applyColumnAlignment;
    public final boolean fillMissingColumns;
    @Deprecated
    public final boolean removeCaption;
    public final boolean trimCellWhitespace;
    public final boolean dumpIntellijOffsets;
    public final DiscretionaryText leftAlignMarker;
    public final TableCaptionHandling formatTableCaption;
    public final DiscretionaryText formatTableCaptionSpaces;
    public final int minSeparatorColumnWidth;
    public final int minSeparatorDashes;
    public final CharWidthProvider charWidthProvider;
    public final String formatTableIndentPrefix;
    public final TableManipulator tableManipulator;
    public final int spaceWidth;
    public final int spacePad;
    public final int pipeWidth;
    public final int colonWidth;
    public final int dashWidth;

    public TableFormatOptions() {
        this(null);
    }

    public TableFormatOptions(DataHolder options) {
        this.leadTrailPipes = FORMAT_TABLE_LEAD_TRAIL_PIPES.getFrom(options);
        this.spaceAroundPipes = FORMAT_TABLE_SPACE_AROUND_PIPES.getFrom(options);
        this.adjustColumnWidth = FORMAT_TABLE_ADJUST_COLUMN_WIDTH.getFrom(options);
        this.applyColumnAlignment = FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT.getFrom(options);
        this.fillMissingColumns = FORMAT_TABLE_FILL_MISSING_COLUMNS.getFrom(options);
        this.leftAlignMarker = FORMAT_TABLE_LEFT_ALIGN_MARKER.getFrom(options);
        this.removeCaption = REMOVE_CAPTION.getFrom(options);
        this.minSeparatorColumnWidth = FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH.getFrom(options);
        this.minSeparatorDashes = FORMAT_TABLE_MIN_SEPARATOR_DASHES.getFrom(options);
        this.charWidthProvider = FORMAT_CHAR_WIDTH_PROVIDER.getFrom(options);
        this.formatTableCaption = FORMAT_TABLE_CAPTION.getFrom(options);
        this.formatTableCaptionSpaces = FORMAT_TABLE_CAPTION_SPACES.getFrom(options);
        this.formatTableIndentPrefix = FORMAT_TABLE_INDENT_PREFIX.getFrom(options);
        this.trimCellWhitespace = FORMAT_TABLE_TRIM_CELL_WHITESPACE.getFrom(options);
        this.tableManipulator = FORMAT_TABLE_MANIPULATOR.getFrom(options);
        this.dumpIntellijOffsets = FORMAT_TABLE_DUMP_TRACKING_OFFSETS.getFrom(options);
        this.spaceWidth = this.charWidthProvider.spaceWidth();
        this.spacePad = this.spaceAroundPipes ? 2 * this.spaceWidth : 0;
        this.pipeWidth = this.charWidthProvider.charWidth('|');
        this.colonWidth = this.charWidthProvider.charWidth(':');
        this.dashWidth = this.charWidthProvider.charWidth('-');
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(FORMAT_TABLE_LEAD_TRAIL_PIPES, this.leadTrailPipes);
        dataHolder.set(FORMAT_TABLE_SPACE_AROUND_PIPES, this.spaceAroundPipes);
        dataHolder.set(FORMAT_TABLE_ADJUST_COLUMN_WIDTH, this.adjustColumnWidth);
        dataHolder.set(FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT, this.applyColumnAlignment);
        dataHolder.set(FORMAT_TABLE_FILL_MISSING_COLUMNS, this.fillMissingColumns);
        dataHolder.set(FORMAT_TABLE_LEFT_ALIGN_MARKER, this.leftAlignMarker);
        dataHolder.set(REMOVE_CAPTION, this.removeCaption);
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH, this.minSeparatorColumnWidth);
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_DASHES, this.minSeparatorDashes);
        dataHolder.set(FORMAT_CHAR_WIDTH_PROVIDER, this.charWidthProvider);
        dataHolder.set(FORMAT_TABLE_CAPTION, this.formatTableCaption);
        dataHolder.set(FORMAT_TABLE_CAPTION_SPACES, this.formatTableCaptionSpaces);
        dataHolder.set(FORMAT_TABLE_INDENT_PREFIX, this.formatTableIndentPrefix);
        dataHolder.set(FORMAT_TABLE_TRIM_CELL_WHITESPACE, this.trimCellWhitespace);
        dataHolder.set(FORMAT_TABLE_MANIPULATOR, this.tableManipulator);
        dataHolder.set(FORMAT_TABLE_DUMP_TRACKING_OFFSETS, this.dumpIntellijOffsets);
        return dataHolder;
    }
}

