/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitorBase;
import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.collection.ClassifyingNodeTracker;
import com.vladsch.flexmark.util.collection.CopyOnWriteRef;
import com.vladsch.flexmark.util.collection.OrderedMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class NodeClassifierVisitor
extends NodeVisitorBase
implements NodeTracker {
    private final OrderedMap<Class<?>, Set<Class<?>>> myExclusionMap;
    private final OrderedSet<Class<?>> myExclusionSet;
    private final HashMap<Integer, BitSet> myNodeAncestryMap;
    private final Stack<BitSet> myNodeAncestryBitSetStack = new Stack();
    private final CopyOnWriteRef<BitSet> myNodeAncestryBitSet = new CopyOnWriteRef<BitSet>(new BitSet(), new Computable<BitSet, BitSet>(){

        @Override
        public BitSet compute(BitSet value) {
            return value != null ? (BitSet)value.clone() : new BitSet();
        }
    });
    private static final BitSet EMPTY_SET = new BitSet();
    private boolean myClassificationDone = false;
    private final ClassifyingNodeTracker myClassifyingNodeTracker;

    public NodeClassifierVisitor(Map<Class<? extends Node>, Set<Class<?>>> exclusionMap) {
        this.myClassifyingNodeTracker = new ClassifyingNodeTracker(this, exclusionMap);
        this.myExclusionMap = this.myClassifyingNodeTracker.getExclusionMap();
        this.myNodeAncestryMap = this.myClassifyingNodeTracker.getNodeAncestryMap();
        this.myExclusionSet = this.myClassifyingNodeTracker.getExclusionSet();
    }

    public ClassifyingNodeTracker classify(Node node) {
        assert (!this.myClassificationDone);
        this.visit(node);
        this.myClassificationDone = true;
        return this.myClassifyingNodeTracker;
    }

    @Override
    public void visit(Node node) {
        this.visitChildren(node);
    }

    @Override
    public void nodeRemoved(Node node) {
    }

    @Override
    public void nodeRemovedWithChildren(Node node) {
    }

    @Override
    public void nodeRemovedWithDescendants(Node node) {
    }

    @Override
    public void nodeAddedWithChildren(Node node) {
        this.nodeAdded(node);
    }

    @Override
    public void nodeAddedWithDescendants(Node node) {
        this.nodeAdded(node);
    }

    @Override
    public void nodeAdded(Node node) {
        if (this.myClassificationDone) {
            if (node.getParent() == null) {
                throw new IllegalStateException("Node must be inserted into the document before calling node tracker nodeAdded functions");
            }
            if (!(node.getParent() instanceof Document)) {
                int parentIndex = this.myClassifyingNodeTracker.getItems().indexOf(node.getParent());
                if (parentIndex == -1) {
                    throw new IllegalStateException("Parent node: " + node.getParent() + " of " + node + " is not tracked, some post processor forgot to call tracker.nodeAdded().");
                }
                BitSet ancestorBitSet = this.myNodeAncestryMap.get(parentIndex);
                this.myNodeAncestryBitSet.setValue(ancestorBitSet);
            }
            this.myNodeAncestryBitSetStack.clear();
            this.visit(node);
        }
    }

    void pushNodeAncestry() {
        if (!this.myExclusionMap.isEmpty()) {
            this.myNodeAncestryBitSetStack.push(this.myNodeAncestryBitSet.getImmutable());
        }
    }

    void popNodeAncestry() {
        this.myNodeAncestryBitSet.setValue(this.myNodeAncestryBitSetStack.pop());
    }

    boolean updateNodeAncestry(Node node, CopyOnWriteRef<BitSet> nodeAncestryBitSet) {
        Node parent = node.getParent();
        if (!this.myExclusionMap.isEmpty() && !(node instanceof Document)) {
            BitSet oldBitSet;
            node.getClass();
            BitSet bitSet = nodeAncestryBitSet.getPeek();
            int index = this.myClassifyingNodeTracker.getItems().indexOf(node);
            if (index == -1) {
                throw new IllegalStateException("Node: " + node + " is not tracked, some post processor forgot to call tracker.nodeAdded().");
            }
            if (this.myExclusionSet != null && !this.myExclusionSet.isEmpty()) {
                for (Class clazz : this.myExclusionSet) {
                    if (!clazz.isInstance(node)) continue;
                    int i = this.myExclusionSet.indexOf(clazz);
                    assert (i != -1);
                    if (bitSet.get(i) || nodeAncestryBitSet.isMutable()) continue;
                    bitSet = nodeAncestryBitSet.getMutable();
                    bitSet.set(i);
                }
            }
            if (this.myClassificationDone && this.myNodeAncestryBitSetStack.size() > 1 && (oldBitSet = this.myNodeAncestryMap.get(index)) != null && oldBitSet.equals(bitSet)) {
                return false;
            }
            if (!bitSet.isEmpty()) {
                this.myNodeAncestryMap.put(index, nodeAncestryBitSet.getImmutable());
            }
        }
        return true;
    }

    @Override
    public void visitChildren(Node parent) {
        if (!this.myClassificationDone && !(parent instanceof Document)) {
            this.myClassifyingNodeTracker.nodeAdded(parent);
        }
        if (parent.getFirstChild() != null) {
            this.pushNodeAncestry();
            if (this.updateNodeAncestry(parent, this.myNodeAncestryBitSet)) {
                super.visitChildren(parent);
            }
            this.popNodeAncestry();
        } else {
            this.updateNodeAncestry(parent, this.myNodeAncestryBitSet);
        }
    }
}

