/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Html5Entities;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_ONLY = Pattern.compile("[\\\\]");
    private static final Pattern ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]", 2);
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern AMP_ONLY = Pattern.compile("[\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ENTITY_ONLY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final String XML_SPECIAL = "[&<>\"]";
    private static final Pattern XML_SPECIAL_RE = Pattern.compile("[&<>\"]");
    private static final Pattern XML_SPECIAL_OR_ENTITY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});|[&<>\"]", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Pattern COLLAPSE_WHITESPACE = Pattern.compile("[ \t]{2,}");
    private static final Replacer UNSAFE_CHAR_REPLACER = new Replacer(){

        @Override
        public void replace(String s, StringBuilder sb) {
            if (s.equals("&")) {
                sb.append("&amp;");
            } else if (s.equals("<")) {
                sb.append("&lt;");
            } else if (s.equals(">")) {
                sb.append("&gt;");
            } else if (s.equals("\"")) {
                sb.append("&quot;");
            } else {
                sb.append(s);
            }
        }

        @Override
        public void replace(BasedSequence s, ReplacedTextMapper textMapper) {
            String s1 = s.toString();
            if (s1.equals("&")) {
                textMapper.addReplacedText(s, PrefixedSubSequence.of("&amp;", BasedSequence.NULL));
            } else if (s1.equals("<")) {
                textMapper.addReplacedText(s, PrefixedSubSequence.of("&lt;", BasedSequence.NULL));
            } else if (s1.equals(">")) {
                textMapper.addReplacedText(s, PrefixedSubSequence.of("&gt;", BasedSequence.NULL));
            } else if (s1.equals("\"")) {
                textMapper.addReplacedText(s, PrefixedSubSequence.of("&quot;", BasedSequence.NULL));
            } else {
                textMapper.addOriginalText(s);
            }
        }
    };
    private static final Replacer COLLAPSE_WHITESPACE_REPLACER = new Replacer(){

        @Override
        public void replace(String s, StringBuilder sb) {
            sb.append(" ");
        }

        @Override
        public void replace(BasedSequence s, ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(s, s.subSequence(0, 1));
        }
    };
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String s, StringBuilder sb) {
            if (s.charAt(0) == '\\') {
                sb.append(s, 1, s.length());
            } else {
                sb.append(Html5Entities.entityToString(s));
            }
        }

        @Override
        public void replace(BasedSequence s, ReplacedTextMapper textMapper) {
            if (s.charAt(0) == '\\') {
                textMapper.addReplacedText(s, s.subSequence(1, s.length()));
            } else {
                textMapper.addReplacedText(s, Html5Entities.entityToSequence(s));
            }
        }
    };
    private static final Replacer ENTITY_REPLACER = new Replacer(){

        @Override
        public void replace(String s, StringBuilder sb) {
            sb.append(Html5Entities.entityToString(s));
        }

        @Override
        public void replace(BasedSequence s, ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(s, Html5Entities.entityToSequence(s));
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String s, StringBuilder sb) {
            if (s.startsWith("%")) {
                if (s.length() == 3) {
                    sb.append(s);
                } else {
                    sb.append("%25");
                    sb.append(s, 1, s.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = s.getBytes(Charset.forName("UTF-8"))) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }

        @Override
        public void replace(BasedSequence s, ReplacedTextMapper textMapper) {
            if (s.startsWith("%")) {
                if (s.length() == 3) {
                    textMapper.addOriginalText(s);
                } else {
                    textMapper.addReplacedText(s.subSequence(0, 1), PrefixedSubSequence.of("%25", BasedSequence.NULL));
                    textMapper.addOriginalText(s.subSequence(1, s.length()));
                }
            } else {
                byte[] bytes = s.toString().getBytes(Charset.forName("UTF-8"));
                StringBuilder sbItem = new StringBuilder();
                for (byte b : bytes) {
                    sbItem.append('%');
                    sbItem.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sbItem.append(HEX_DIGITS[b & 0xF]);
                }
                textMapper.addReplacedText(s, PrefixedSubSequence.of(sbItem.toString(), BasedSequence.NULL));
            }
        }
    };
    private static Random random = new Random(9766L);

    public static String escapeHtml(CharSequence s, boolean preserveEntities) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s, UNSAFE_CHAR_REPLACER);
    }

    public static BasedSequence escapeHtml(BasedSequence s, boolean preserveEntities, ReplacedTextMapper textMapper) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s, UNSAFE_CHAR_REPLACER, textMapper);
    }

    public static String unescapeString(CharSequence s) {
        if (BACKSLASH_OR_AMP.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return s instanceof String ? (String)s : String.valueOf(s);
    }

    public static String unescapeString(CharSequence s, boolean unescapeEntities) {
        if (unescapeEntities) {
            if (BACKSLASH_OR_AMP.matcher(s).find()) {
                return Escaping.replaceAll(ESCAPED_CHAR, s, UNESCAPE_REPLACER);
            }
            return s instanceof String ? (String)s : String.valueOf(s);
        }
        if (BACKSLASH_ONLY.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return s instanceof String ? (String)s : String.valueOf(s);
    }

    public static BasedSequence unescape(BasedSequence s, ReplacedTextMapper textMapper) {
        int indexOfAny = s.indexOfAny('\\', '&');
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER, textMapper);
        }
        return s;
    }

    public static String unescapeHtml(CharSequence s) {
        if (AMP_ONLY.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_ONLY, s, ENTITY_REPLACER);
        }
        return s instanceof String ? (String)s : String.valueOf(s);
    }

    public static BasedSequence unescapeHtml(BasedSequence s, ReplacedTextMapper textMapper) {
        int indexOfAny = s.indexOf('&');
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_ONLY, s, ENTITY_REPLACER, textMapper);
        }
        return s;
    }

    public static String normalizeEndWithEOL(CharSequence s) {
        return Escaping.normalizeEOL(s, true);
    }

    public static String normalizeEOL(CharSequence s) {
        return Escaping.normalizeEOL(s, false);
    }

    public static String normalizeEOL(CharSequence s, boolean endWithEOL) {
        StringBuilder sb = new StringBuilder(s.length());
        int iMax = s.length();
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                sb.append("\n");
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (hadCR) {
                sb.append('\n');
            }
            sb.append(c);
            hadCR = false;
            hadEOL = false;
        }
        if (endWithEOL && !hadEOL) {
            sb.append('\n');
        }
        return sb.toString();
    }

    public static BasedSequence normalizeEndWithEOL(BasedSequence s, ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s, textMapper, true);
    }

    public static BasedSequence normalizeEOL(BasedSequence s, ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s, textMapper, false);
    }

    public static BasedSequence normalizeEOL(BasedSequence s, ReplacedTextMapper textMapper, boolean endWithEOL) {
        int iMax = s.length();
        int lastPos = 0;
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                if (!hadCR) continue;
                if (lastPos < i - 1) {
                    textMapper.addOriginalText(s.subSequence(lastPos, i - 1));
                }
                lastPos = i;
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (!hadCR) continue;
            if (lastPos < i - 1) {
                textMapper.addOriginalText(s.subSequence(lastPos, i + 1));
            }
            textMapper.addReplacedText(s.subSequence(i - 1, i), BasedSequence.EOL);
            lastPos = i;
            hadCR = false;
            hadEOL = false;
        }
        if (!hadCR) {
            if (lastPos < iMax) {
                textMapper.addOriginalText(s.subSequence(lastPos, iMax));
            }
            if (!hadEOL && endWithEOL) {
                textMapper.addReplacedText(s.subSequence(iMax - 1, iMax), BasedSequence.EOL);
            }
        }
        return textMapper.getReplacedSequence();
    }

    public static String percentEncodeUrl(CharSequence s) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s, URI_REPLACER);
    }

    public static String normalizeReference(CharSequence s, boolean changeCase) {
        if (changeCase) {
            return Escaping.collapseWhitespace(s.toString(), true).toLowerCase();
        }
        return Escaping.collapseWhitespace(s.toString(), true);
    }

    private static String encode(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return null;
    }

    public static String obfuscate(String email, boolean randomize) {
        if (!randomize) {
            random = new Random(0L);
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < email.length(); ++i) {
            char c = email.charAt(i);
            switch (random.nextInt(5)) {
                case 0: 
                case 1: {
                    sb.append("&#").append((int)c).append(';');
                    continue block5;
                }
                case 2: 
                case 3: {
                    sb.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue block5;
                }
                case 4: {
                    String encoded = Escaping.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String normalizeReferenceChars(CharSequence s, boolean changeCase) {
        if (s.length() > 1) {
            int stripEnd = s.charAt(s.length() - 1) == ':' ? 2 : 1;
            int stripStart = s.charAt(0) == '!' ? 2 : 1;
            return Escaping.normalizeReference(s.subSequence(stripStart, s.length() - stripEnd), changeCase);
        }
        return s instanceof String ? (String)s : String.valueOf(s);
    }

    public static String collapseWhitespace(CharSequence s, boolean trim) {
        StringBuilder sb = new StringBuilder(s.length());
        int iMax = s.length();
        boolean hadSpace = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                hadSpace = true;
                continue;
            }
            if (hadSpace && (!trim || sb.length() > 0)) {
                sb.append(' ');
            }
            sb.append(c);
            hadSpace = false;
        }
        if (hadSpace && !trim) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static BasedSequence collapseWhitespace(BasedSequence s, ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(COLLAPSE_WHITESPACE, s, COLLAPSE_WHITESPACE_REPLACER, textMapper);
    }

    private static String replaceAll(Pattern p, CharSequence s, Replacer replacer) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            return s instanceof String ? (String)s : String.valueOf(s);
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            sb.append(s, lastEnd, s.length());
        }
        return sb.toString();
    }

    private static BasedSequence replaceAll(Pattern p, BasedSequence s, Replacer replacer, ReplacedTextMapper textMapper) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            textMapper.addOriginalText(s);
            return s;
        }
        int lastEnd = 0;
        do {
            textMapper.addOriginalText(s.subSequence(lastEnd, matcher.start()));
            replacer.replace(s.subSequence(matcher.start(), matcher.end()), textMapper);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            textMapper.addOriginalText(s.subSequence(lastEnd, s.length()));
        }
        return textMapper.getReplacedSequence();
    }

    static interface Replacer {
        public void replace(String var1, StringBuilder var2);

        public void replace(BasedSequence var1, ReplacedTextMapper var2);
    }
}

