/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.IndexedItemBitSetMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;

public class ClassificationBag<K, V> {
    private final OrderedSet<V> myItems;
    private final IndexedItemBitSetMap<K, V> myBag;
    private final CollectionHost<V> myHost;

    public ClassificationBag(Computable<K, V> mapper) {
        this(0, mapper);
    }

    public ClassificationBag(Computable<K, V> mapper, CollectionHost<V> host) {
        this(0, mapper, host);
    }

    public ClassificationBag(int capacity, Computable<K, V> mapper) {
        this(capacity, mapper, null);
    }

    public ClassificationBag(int capacity, Computable<K, V> mapper, CollectionHost<V> host) {
        this.myHost = host;
        this.myItems = new OrderedSet(capacity, new CollectionHost<V>(){

            @Override
            public void adding(int index, V v, Object v2) {
                if (ClassificationBag.this.myHost != null && !ClassificationBag.this.myHost.skipHostUpdate()) {
                    ClassificationBag.this.myHost.adding(index, v, v2);
                }
                ClassificationBag.this.myBag.addItem(v, index);
            }

            @Override
            public Object removing(int index, V v) {
                if (ClassificationBag.this.myHost != null && !ClassificationBag.this.myHost.skipHostUpdate()) {
                    ClassificationBag.this.myHost.removing(index, v);
                }
                ClassificationBag.this.myBag.removeItem(v, index);
                return null;
            }

            @Override
            public void clearing() {
                if (ClassificationBag.this.myHost != null && !ClassificationBag.this.myHost.skipHostUpdate()) {
                    ClassificationBag.this.myHost.clearing();
                }
                ClassificationBag.this.myBag.clear();
            }

            @Override
            public void addingNulls(int index) {
                if (ClassificationBag.this.myHost != null && !ClassificationBag.this.myHost.skipHostUpdate()) {
                    ClassificationBag.this.myHost.addingNulls(index);
                }
            }

            @Override
            public boolean skipHostUpdate() {
                return false;
            }

            @Override
            public int getIteratorModificationCount() {
                return ClassificationBag.this.getModificationCount();
            }
        });
        this.myBag = new IndexedItemBitSetMap<K, V>(mapper);
    }

    public OrderedSet<V> getItems() {
        return this.myItems;
    }

    public int getModificationCount() {
        return this.myItems.getModificationCount();
    }

    public boolean add(V item) {
        return this.myItems.add(item);
    }

    public boolean remove(V item) {
        return this.myItems.remove(item);
    }

    public boolean remove(int index) {
        return this.myItems.removeIndex(index);
    }

    public boolean contains(V item) {
        return this.myItems.contains(item);
    }

    public boolean containsCategory(K category) {
        BitSet bitSet = (BitSet)this.myBag.get(category);
        return bitSet != null && !bitSet.isEmpty();
    }

    public BitSet getCategorySet(K category) {
        return (BitSet)this.myBag.get(category);
    }

    public int getCategoryCount(K category) {
        BitSet bitSet = (BitSet)this.myBag.get(category);
        return bitSet == null ? 0 : bitSet.cardinality();
    }

    public Map<K, BitSet> getCategoryMap() {
        return this.myBag;
    }

    public void clear() {
        this.myItems.clear();
    }

    @SafeVarargs
    public final <X> ReversibleIterable<X> getCategoryItems(Class<? extends X> xClass, K ... categories) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), false));
    }

    public final <X> ReversibleIterable<X> getCategoryItems(Class<? extends X> xClass, Collection<? extends K> categories) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), false));
    }

    public final <X> ReversibleIterable<X> getCategoryItems(Class<? extends X> xClass, BitSet bitSet) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(bitSet, false));
    }

    @SafeVarargs
    public final <X> ReversibleIterable<X> getCategoryItemsReversed(Class<? extends X> xClass, K ... categories) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), true));
    }

    public final <X> ReversibleIterable<X> getCategoryItemsReversed(Class<? extends X> xClass, Collection<? extends K> categories) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), true));
    }

    public final <X> ReversibleIterable<X> getCategoryItemsReversed(Class<? extends X> xClass, BitSet bitSet) {
        return new IndexedIterable(this.myItems.getConcurrentModsIndexedProxy(), new BitSetIterable(bitSet, true));
    }

    @SafeVarargs
    public final BitSet categoriesBitSet(K ... categories) {
        BitSet bitSet = new BitSet();
        for (K category : categories) {
            if (!this.containsCategory(category)) continue;
            bitSet.or((BitSet)this.myBag.get(category));
        }
        return bitSet;
    }

    public final BitSet categoriesBitSet(Collection<? extends K> categories) {
        BitSet bitSet = new BitSet();
        for (K category : categories) {
            if (!this.containsCategory(category)) continue;
            bitSet.or((BitSet)this.myBag.get(category));
        }
        return bitSet;
    }
}

