/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util;

import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.RunnableValue;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static String ifNullOr(String receiver, boolean condition, String altValue) {
        return receiver == null || condition ? altValue : receiver;
    }

    public static String ifNullOrNot(String receiver, boolean condition, String altValue) {
        return receiver == null || !condition ? altValue : receiver;
    }

    public static String ifNullOr(String receiver, Computable<Boolean, String> condition, String altValue) {
        return receiver == null || condition.compute(receiver) != false ? altValue : receiver;
    }

    public static String ifNullOrNot(String receiver, Computable<Boolean, String> condition, String altValue) {
        return receiver == null || condition.compute(receiver) == false ? altValue : receiver;
    }

    public static String ifNullOrEmpty(String receiver, String altValue) {
        return receiver == null || receiver.isEmpty() ? altValue : receiver;
    }

    public static String ifNullOrBlank(String receiver, String altValue) {
        return receiver == null || Utils.isBlank(receiver) ? altValue : receiver;
    }

    public static String ifEmpty(String receiver, String arg) {
        if (receiver != null && !receiver.isEmpty()) {
            return receiver;
        }
        return arg;
    }

    public static String ifEmpty(String receiver, String ifEmptyArg, String ifNotEmptyArg) {
        return receiver == null || receiver.isEmpty() ? ifEmptyArg : ifNotEmptyArg;
    }

    public static String ifEmptyNullArgs(String receiver, String ifEmptyArg, String ifNotEmptyArg) {
        return receiver == null || receiver.isEmpty() ? ifEmptyArg : ifNotEmptyArg;
    }

    public static String ifEmpty(String receiver, RunnableValue<String> arg) {
        if (receiver != null && !receiver.isEmpty()) {
            return receiver;
        }
        return arg.run();
    }

    public static String ifEmpty(String receiver, RunnableValue<String> ifEmptyArg, RunnableValue<String> ifNotEmptyArg) {
        return receiver == null || receiver.isEmpty() ? ifEmptyArg.run() : ifNotEmptyArg.run();
    }

    public static boolean isBlank(String receiver) {
        return receiver == null || receiver.trim().isEmpty();
    }

    public static String orEmpty(String receiver) {
        return receiver == null ? "" : receiver;
    }

    public static String wrapWith(String receiver, char prefixSuffix) {
        return Utils.wrapWith(receiver, prefixSuffix, prefixSuffix);
    }

    public static String wrapWith(String receiver, char prefix, char suffix) {
        return receiver == null || receiver.isEmpty() ? "" : prefix + receiver + suffix;
    }

    public static String wrapWith(String receiver, String prefixSuffix) {
        return Utils.wrapWith(prefixSuffix, prefixSuffix);
    }

    public static String wrapWith(String receiver, String prefix, String suffix) {
        return receiver == null || receiver.isEmpty() ? "" : prefix + receiver + suffix;
    }

    public static String suffixWith(String receiver, char suffix) {
        return Utils.suffixWith(receiver, suffix, false);
    }

    public static String suffixWith(String receiver, char suffix, boolean ignoreCase) {
        if (receiver != null && !receiver.isEmpty() && !Utils.endsWith((CharSequence)receiver, String.valueOf(suffix), ignoreCase)) {
            return receiver + suffix;
        }
        return Utils.orEmpty(receiver);
    }

    public static String suffixWith(String receiver, String suffix) {
        return Utils.suffixWith(receiver, suffix, false);
    }

    public static String suffixWith(String receiver, String suffix, boolean ignoreCase) {
        if (!(receiver == null || receiver.isEmpty() || suffix.isEmpty() || Utils.endsWith((CharSequence)receiver, suffix, ignoreCase))) {
            return receiver + suffix;
        }
        return Utils.orEmpty(receiver);
    }

    public static String prefixWith(String receiver, char prefix) {
        return Utils.prefixWith(receiver, prefix, false);
    }

    public static String prefixWith(String receiver, char prefix, boolean ignoreCase) {
        if (receiver != null && !receiver.isEmpty() && !Utils.startsWith((CharSequence)receiver, String.valueOf(prefix), ignoreCase)) {
            return prefix + receiver;
        }
        return Utils.orEmpty(receiver);
    }

    public static String prefixWith(String receiver, String prefix) {
        return Utils.prefixWith(receiver, prefix, false);
    }

    public static String prefixWith(String receiver, String prefix, boolean ignoreCase) {
        if (!(receiver == null || receiver.isEmpty() || prefix.isEmpty() || Utils.startsWith((CharSequence)receiver, prefix, ignoreCase))) {
            return prefix + receiver;
        }
        return Utils.orEmpty(receiver);
    }

    public static boolean isIn(String receiver, String ... list) {
        if (receiver == null) {
            return false;
        }
        for (String item : list) {
            if (!receiver.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String receiver, String ... needles) {
        return Utils.endsWith(receiver, false, needles);
    }

    public static boolean endsWith(String receiver, boolean ignoreCase, String ... needles) {
        if (receiver == null) {
            return false;
        }
        for (String needle : needles) {
            if (!Utils.endsWith(receiver, ignoreCase, needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String receiver, String ... needles) {
        return Utils.startsWith(receiver, false, needles);
    }

    public static boolean startsWith(String receiver, boolean ignoreCase, String ... needles) {
        if (receiver == null) {
            return false;
        }
        for (String needle : needles) {
            if (!Utils.startsWith(receiver, ignoreCase, needle)) continue;
            return true;
        }
        return false;
    }

    public static int count(String receiver, char c, int startIndex, int endIndex) {
        if (receiver == null) {
            return 0;
        }
        int count = 0;
        int lastIndex = Math.min(receiver.length(), endIndex);
        for (int pos = startIndex; pos >= 0 && pos <= lastIndex && (pos = receiver.indexOf(c, pos)) >= 0; ++pos) {
            ++count;
        }
        return count;
    }

    public static int count(String receiver, String c, int startIndex, int endIndex) {
        if (receiver == null) {
            return 0;
        }
        int count = 0;
        int lastIndex = Math.min(receiver.length(), endIndex);
        for (int pos = startIndex; pos >= 0 && pos <= lastIndex && (pos = receiver.indexOf(c, pos)) >= 0; ++pos) {
            ++count;
        }
        return count;
    }

    public static String urlDecode(String receiver, String charSet) {
        try {
            return URLDecoder.decode(receiver, charSet != null ? charSet : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return Utils.orEmpty(receiver);
        }
        catch (IllegalArgumentException e) {
            return Utils.orEmpty(receiver);
        }
    }

    public static String urlEncode(String receiver, String charSet) {
        try {
            return URLEncoder.encode(receiver, charSet != null ? charSet : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return Utils.orEmpty(receiver);
        }
    }

    public static String removeStart(String receiver, char prefix) {
        if (receiver != null) {
            if (receiver.startsWith(String.valueOf(prefix))) {
                return receiver.substring(1);
            }
            return receiver;
        }
        return "";
    }

    public static String removeStart(String receiver, String prefix) {
        if (receiver != null) {
            if (receiver.startsWith(String.valueOf(prefix))) {
                return receiver.substring(prefix.length());
            }
            return receiver;
        }
        return "";
    }

    public static String removeEnd(String receiver, char prefix) {
        if (receiver != null) {
            if (receiver.startsWith(String.valueOf(prefix))) {
                return receiver.substring(0, receiver.length() - 1);
            }
            return receiver;
        }
        return "";
    }

    public static String removeEnd(String receiver, String prefix) {
        if (receiver != null) {
            if (receiver.startsWith(String.valueOf(prefix))) {
                return receiver.substring(0, receiver.length() - prefix.length());
            }
            return receiver;
        }
        return "";
    }

    public static <T> List<? extends T> stringSorted(Collection<? extends T> receiver, final Computable<String, T> stringer) {
        ArrayList<? extends T> result = new ArrayList<T>(receiver);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((String)stringer.compute(o1)).compareTo((String)stringer.compute(o2));
            }
        });
        return result;
    }

    public static String regexGroup(String receiver) {
        return "(?:" + Utils.orEmpty(receiver) + ")";
    }

    public static boolean regionMatches(CharSequence receiver, int thisOffset, String other, int otherOffset, int length, boolean ignoreCase) {
        if (ignoreCase) {
            for (int i = 0; i < length; ++i) {
                if (Character.toLowerCase(receiver.charAt(i + thisOffset)) == Character.toLowerCase(other.charAt(i + otherOffset))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (receiver.charAt(i + thisOffset) == other.charAt(i + otherOffset)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean endsWith(CharSequence receiver, String suffix, boolean ignoreCase) {
        return receiver.length() >= suffix.length() && Utils.regionMatches(receiver, receiver.length() - suffix.length(), suffix, 0, suffix.length(), ignoreCase);
    }

    public static boolean startsWith(CharSequence receiver, String prefix, boolean ignoreCase) {
        return receiver.length() >= prefix.length() && Utils.regionMatches(receiver, 0, prefix, 0, prefix.length(), ignoreCase);
    }

    public static String splice(String[] receiver, String delimiter) {
        StringBuilder result = new StringBuilder(receiver.length * (delimiter.length() + 10));
        String delim = "";
        for (String elem : receiver) {
            result.append(delim);
            delim = delimiter;
            result.append(elem);
        }
        return result.toString();
    }

    public static String splice(Collection<String> receiver, String delimiter, boolean skipNullOrEmpty) {
        StringBuilder result = new StringBuilder(receiver.size() * (delimiter.length() + 10));
        String delim = "";
        for (String elem : receiver) {
            if ((elem == null || elem.isEmpty()) && skipNullOrEmpty) continue;
            if (!skipNullOrEmpty || !elem.startsWith(delimiter) && !Utils.endsWith(result.toString(), delimiter)) {
                result.append(delim);
            }
            delim = delimiter;
            result.append(Utils.orEmpty(elem));
        }
        return result.toString();
    }

    public static int max(int receiver, int ... others) {
        int max = receiver;
        for (int other : others) {
            if (max >= other) continue;
            max = other;
        }
        return max;
    }

    public static int min(int receiver, int ... others) {
        int min = receiver;
        for (int other : others) {
            if (min <= other) continue;
            min = other;
        }
        return min;
    }

    public static int minLimit(int receiver, int ... minBound) {
        return Utils.max(receiver, minBound);
    }

    public static int maxLimit(int receiver, int ... maxBound) {
        return Utils.min(receiver, maxBound);
    }

    public static int rangeLimit(int receiver, int minBound, int maxBound) {
        if (receiver < minBound) {
            return minBound;
        }
        if (receiver > maxBound) {
            return maxBound;
        }
        return receiver;
    }

    public static <K, V> V putIfMissing(Map<K, V> receiver, K key, RunnableValue<V> value) {
        V elem = receiver.get(key);
        if (elem == null) {
            elem = value.run();
            receiver.put(key, elem);
        }
        return elem;
    }

    public static <K, V> Map<K, V> withDefaults(Map<K, V> receiver, Map<K, V> defaults) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.putAll(receiver);
        for (final Map.Entry<K, V> entry : defaults.entrySet()) {
            Utils.putIfMissing(map, entry.getKey(), new RunnableValue<V>(){

                @Override
                public V run() {
                    return entry.getValue();
                }
            });
        }
        return map;
    }
}

