/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Html5Entities;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Escaping {
    public static final String ESCAPABLE_CHARS = "\"#$%&'()*+,./:;<=>?@[]\\^_`{|}~-";
    public static final String ESCAPABLE = "[!" + "\"#$%&'()*+,./:;<=>?@[]\\^_`{|}~-".replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]") + "]";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_ONLY = Pattern.compile("[\\\\]");
    private static final Pattern ESCAPED_CHAR = Pattern.compile("\\\\" + ESCAPABLE, 2);
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern AMP_ONLY = Pattern.compile("[\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\" + ESCAPABLE + '|' + "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ENTITY_ONLY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final String XML_SPECIAL = "[&<>\"]";
    private static final Pattern XML_SPECIAL_RE = Pattern.compile("[&<>\"]");
    private static final Pattern XML_SPECIAL_OR_ENTITY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});|[&<>\"]", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final Pattern ESCAPE_URI_DECODE = Pattern.compile("(%[a-fA-F0-9]{2})");
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Pattern COLLAPSE_WHITESPACE = Pattern.compile("[ \t]{2,}");
    private static final Replacer UNSAFE_CHAR_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            if (s.equals("&")) {
                sb.append("&amp;");
            } else if (s.equals("<")) {
                sb.append("&lt;");
            } else if (s.equals(">")) {
                sb.append("&gt;");
            } else if (s.equals("\"")) {
                sb.append("&quot;");
            } else {
                sb.append(s);
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            String s1 = original.subSequence(startIndex, endIndex).toString();
            if (s1.equals("&")) {
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&amp;", BasedSequence.NULL));
            } else if (s1.equals("<")) {
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&lt;", BasedSequence.NULL));
            } else if (s1.equals(">")) {
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&gt;", BasedSequence.NULL));
            } else if (s1.equals("\"")) {
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&quot;", BasedSequence.NULL));
            } else {
                textMapper.addOriginalText(startIndex, endIndex);
            }
        }
    };
    private static final Replacer COLLAPSE_WHITESPACE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            sb.append(" ");
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, original.subSequence(startIndex, startIndex + 1));
        }
    };
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            if (s.charAt(0) == '\\') {
                sb.append(s, 1, s.length());
            } else {
                sb.append(Html5Entities.entityToString(s));
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            if (original.charAt(startIndex) == '\\') {
                textMapper.addReplacedText(startIndex, endIndex, original.subSequence(startIndex + 1, endIndex));
            } else {
                textMapper.addReplacedText(startIndex, endIndex, Html5Entities.entityToSequence(original.subSequence(startIndex, endIndex)));
            }
        }
    };
    private static final Replacer REMOVE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, original.subSequence(endIndex, endIndex));
        }
    };
    private static final Replacer ENTITY_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            sb.append(Html5Entities.entityToString(s));
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, Html5Entities.entityToSequence(original.subSequence(startIndex, endIndex)));
        }
    };
    private static final Replacer URL_ENCODE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            if (s.startsWith("%")) {
                if (s.length() == 3) {
                    sb.append(s);
                } else {
                    sb.append("%25");
                    sb.append(s, 1, s.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = s.getBytes(StandardCharsets.UTF_8)) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            BasedSequence s = original.subSequence(startIndex, endIndex);
            if (s.startsWith("%")) {
                if (s.length() == 3) {
                    textMapper.addOriginalText(startIndex, endIndex);
                } else {
                    textMapper.addReplacedText(startIndex, startIndex + 1, PrefixedSubSequence.prefixOf("%25", BasedSequence.NULL));
                    textMapper.addOriginalText(startIndex + 1, endIndex);
                }
            } else {
                byte[] bytes = s.toString().getBytes(StandardCharsets.UTF_8);
                StringBuilder sbItem = new StringBuilder();
                for (byte b : bytes) {
                    sbItem.append('%');
                    sbItem.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sbItem.append(HEX_DIGITS[b & 0xF]);
                }
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf(sbItem.toString(), BasedSequence.NULL));
            }
        }
    };
    private static final Replacer URL_DECODE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s, @NotNull StringBuilder sb) {
            String urlDecoded = Utils.urlDecode((String)s, null);
            sb.append(urlDecoded);
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            BasedSequence s = original.subSequence(startIndex, endIndex);
            String decoded = Utils.urlDecode((String)s.toString(), null);
            textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf(decoded, BasedSequence.NULL));
        }
    };
    @NotNull
    public static final CharPredicate AMP_BACKSLASH_SET = CharPredicate.anyOf((char[])new char[]{'\\', '&'});
    private static Random random = new Random(9766L);

    public static String escapeHtml(@NotNull CharSequence s, boolean preserveEntities) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s, UNSAFE_CHAR_REPLACER);
    }

    @NotNull
    public static BasedSequence escapeHtml(@NotNull BasedSequence s, boolean preserveEntities, @NotNull ReplacedTextMapper textMapper) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s, UNSAFE_CHAR_REPLACER, textMapper);
    }

    @NotNull
    public static String unescapeString(@NotNull CharSequence s) {
        if (BACKSLASH_OR_AMP.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return String.valueOf(s);
    }

    @NotNull
    public static String unescapeString(@NotNull CharSequence s, boolean unescapeEntities) {
        if (unescapeEntities) {
            if (BACKSLASH_OR_AMP.matcher(s).find()) {
                return Escaping.replaceAll(ESCAPED_CHAR, s, UNESCAPE_REPLACER);
            }
            return String.valueOf(s);
        }
        if (BACKSLASH_ONLY.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return String.valueOf(s);
    }

    @NotNull
    public static BasedSequence unescape(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        int indexOfAny = s.indexOfAny(AMP_BACKSLASH_SET);
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER, textMapper);
        }
        return s;
    }

    @NotNull
    public static BasedSequence removeAll(@NotNull BasedSequence s, @NotNull CharSequence remove, @NotNull ReplacedTextMapper textMapper) {
        int indexOf = s.indexOf(remove);
        if (indexOf != -1) {
            return Escaping.replaceAll(Pattern.compile("\\Q" + remove + "\\E"), s, REMOVE_REPLACER, textMapper);
        }
        return s;
    }

    @NotNull
    public static String unescapeHtml(@NotNull CharSequence s) {
        if (AMP_ONLY.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_ONLY, s, ENTITY_REPLACER);
        }
        return String.valueOf(s);
    }

    @NotNull
    public static BasedSequence unescapeHtml(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        int indexOfAny = s.indexOf('&');
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_ONLY, s, ENTITY_REPLACER, textMapper);
        }
        return s;
    }

    @NotNull
    public static String normalizeEndWithEOL(@NotNull CharSequence s) {
        return Escaping.normalizeEOL(s, true);
    }

    @NotNull
    public static String normalizeEOL(@NotNull CharSequence s) {
        return Escaping.normalizeEOL(s, false);
    }

    @NotNull
    public static String normalizeEOL(@NotNull CharSequence s, boolean endWithEOL) {
        StringBuilder sb = new StringBuilder(s.length());
        int iMax = s.length();
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                sb.append("\n");
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (hadCR) {
                sb.append('\n');
            }
            sb.append(c);
            hadCR = false;
            hadEOL = false;
        }
        if (endWithEOL && !hadEOL) {
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    public static BasedSequence normalizeEndWithEOL(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s, textMapper, true);
    }

    @NotNull
    public static BasedSequence normalizeEOL(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s, textMapper, false);
    }

    @NotNull
    public static BasedSequence normalizeEOL(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper, boolean endWithEOL) {
        int iMax = s.length();
        int lastPos = 0;
        boolean hadCR = false;
        boolean hadEOL = false;
        if (textMapper.isModified()) {
            textMapper.startNestedReplacement(s);
        }
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                if (!hadCR) continue;
                if (lastPos < i - 1) {
                    textMapper.addOriginalText(lastPos, i - 1);
                }
                lastPos = i;
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (!hadCR) continue;
            if (lastPos < i - 1) {
                textMapper.addOriginalText(lastPos, i + 1);
            }
            textMapper.addReplacedText(i - 1, i, BasedSequence.EOL);
            lastPos = i;
            hadCR = false;
            hadEOL = false;
        }
        if (!hadCR) {
            if (lastPos < iMax) {
                textMapper.addOriginalText(lastPos, iMax);
            }
            if (!hadEOL && endWithEOL) {
                textMapper.addReplacedText(iMax - 1, iMax, BasedSequence.EOL);
            }
        }
        return textMapper.getReplacedSequence();
    }

    @NotNull
    public static String percentEncodeUrl(@NotNull CharSequence s) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s, URL_ENCODE_REPLACER);
    }

    @NotNull
    public static BasedSequence percentEncodeUrl(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s, URL_ENCODE_REPLACER, textMapper);
    }

    @NotNull
    public static String percentDecodeUrl(@NotNull CharSequence s) {
        return Escaping.replaceAll(ESCAPE_URI_DECODE, s, URL_DECODE_REPLACER);
    }

    @NotNull
    public static BasedSequence percentDecodeUrl(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(ESCAPE_URI_DECODE, s, URL_DECODE_REPLACER, textMapper);
    }

    @NotNull
    public static String normalizeReference(@NotNull CharSequence s, boolean changeCase) {
        if (changeCase) {
            return Escaping.collapseWhitespace(s.toString(), true).toLowerCase();
        }
        return Escaping.collapseWhitespace(s.toString(), true);
    }

    @Nullable
    private static String encode(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return null;
    }

    @NotNull
    public static String obfuscate(@NotNull String email, boolean randomize) {
        if (!randomize) {
            random = new Random(0L);
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < email.length(); ++i) {
            char c = email.charAt(i);
            switch (random.nextInt(5)) {
                case 0: 
                case 1: {
                    sb.append("&#").append((int)c).append(';');
                    continue block5;
                }
                case 2: 
                case 3: {
                    sb.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue block5;
                }
                case 4: {
                    String encoded = Escaping.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    public static String normalizeReferenceChars(@NotNull CharSequence s, boolean changeCase) {
        if (s.length() > 1) {
            int stripEnd = s.charAt(s.length() - 1) == ':' ? 2 : 1;
            int stripStart = s.charAt(0) == '!' ? 2 : 1;
            return Escaping.normalizeReference(s.subSequence(stripStart, s.length() - stripEnd), changeCase);
        }
        return String.valueOf(s);
    }

    @NotNull
    public static String collapseWhitespace(@NotNull CharSequence s, boolean trim) {
        StringBuilder sb = new StringBuilder(s.length());
        int iMax = s.length();
        boolean hadSpace = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                hadSpace = true;
                continue;
            }
            if (hadSpace && (!trim || sb.length() > 0)) {
                sb.append(' ');
            }
            sb.append(c);
            hadSpace = false;
        }
        if (hadSpace && !trim) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @NotNull
    public static BasedSequence collapseWhitespace(@NotNull BasedSequence s, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(COLLAPSE_WHITESPACE, s, COLLAPSE_WHITESPACE_REPLACER, textMapper);
    }

    @NotNull
    private static String replaceAll(@NotNull Pattern p, @NotNull CharSequence s, @NotNull Replacer replacer) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            return String.valueOf(s);
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            sb.append(s, lastEnd, s.length());
        }
        return sb.toString();
    }

    @NotNull
    private static BasedSequence replaceAll(Pattern p, @NotNull BasedSequence s, @NotNull Replacer replacer, @NotNull ReplacedTextMapper textMapper) {
        Matcher matcher = p.matcher(s);
        if (textMapper.isModified()) {
            textMapper.startNestedReplacement(s);
        }
        if (!matcher.find()) {
            textMapper.addOriginalText(0, s.length());
            return s;
        }
        int lastEnd = 0;
        do {
            textMapper.addOriginalText(lastEnd, matcher.start());
            replacer.replace(s, matcher.start(), matcher.end(), textMapper);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            textMapper.addOriginalText(lastEnd, s.length());
        }
        return textMapper.getReplacedSequence();
    }

    static interface Replacer {
        public void replace(@NotNull String var1, @NotNull StringBuilder var2);

        public void replace(@NotNull BasedSequence var1, int var2, int var3, @NotNull ReplacedTextMapper var4);
    }
}

