/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtils {
    public static <T> boolean contained(T value, T[] array) {
        return ArrayUtils.indexOf(value, array) != -1;
    }

    public static boolean contained(int value, int[] array) {
        for (int item : array) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    public static <T> T firstOf(T[] ts, Predicate<? super T> predicate) {
        return ArrayUtils.firstOf(ts, 0, ts.length, predicate);
    }

    public static <T> T firstOf(T[] ts, int fromIndex, Predicate<? super T> predicate) {
        return ArrayUtils.firstOf(ts, fromIndex, ts.length, predicate);
    }

    @Nullable
    public static <T> T firstOf(T[] ts, int fromIndex, int endIndex, Predicate<? super T> predicate) {
        int i = ArrayUtils.indexOf(ts, fromIndex, endIndex, predicate);
        return i == -1 ? null : (T)ts[i];
    }

    public static <T> int indexOf(T t, T[] ts) {
        return ArrayUtils.indexOf(t, ts, 0, ts.length);
    }

    public static <T> int indexOf(T t, T[] ts, int fromIndex) {
        return ArrayUtils.indexOf(t, ts, fromIndex, ts.length);
    }

    public static <T> int indexOf(T t, T[] ts, int fromIndex, int endIndex) {
        return ArrayUtils.indexOf(ts, fromIndex, endIndex, t1 -> Objects.equals(t, t1));
    }

    public static <T> int indexOf(T[] ts, Predicate<? super T> predicate) {
        return ArrayUtils.indexOf(ts, 0, ts.length, predicate);
    }

    public static <T> int indexOf(T[] ts, int fromIndex, Predicate<? super T> predicate) {
        return ArrayUtils.indexOf(ts, fromIndex, ts.length, predicate);
    }

    public static <T> int indexOf(T[] ts, int fromIndex, int endIndex, Predicate<? super T> predicate) {
        int iMax = ts.length;
        if (endIndex > 0) {
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (endIndex > iMax) {
                endIndex = iMax;
            }
            if (fromIndex < endIndex) {
                for (int i = fromIndex; i < endIndex; ++i) {
                    if (!predicate.test(ts[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static <T> T lastOf(T[] ts, Predicate<? super T> predicate) {
        return ArrayUtils.lastOf(ts, 0, ts.length, predicate);
    }

    public static <T> T lastOf(T[] ts, int fromIndex, Predicate<? super T> predicate) {
        return ArrayUtils.lastOf(ts, 0, fromIndex, predicate);
    }

    public static <T> T lastOf(T[] ts, int startIndex, int fromIndex, Predicate<? super T> predicate) {
        int i = ArrayUtils.lastIndexOf(ts, startIndex, fromIndex, predicate);
        return i == -1 ? null : (T)ts[i];
    }

    public static <T> int lastIndexOf(T t, T[] ts) {
        return ArrayUtils.lastIndexOf(t, ts, 0, ts.length);
    }

    public static <T> int lastIndexOf(T t, T[] ts, int fromIndex) {
        return ArrayUtils.lastIndexOf(t, ts, 0, fromIndex);
    }

    public static <T> int lastIndexOf(T t, T[] ts, int startIndex, int fromIndex) {
        return ArrayUtils.lastIndexOf(ts, startIndex, fromIndex, t1 -> Objects.equals(t, t1));
    }

    public static <T> int lastIndexOf(T[] ts, Predicate<? super T> predicate) {
        return ArrayUtils.lastIndexOf(ts, 0, ts.length, predicate);
    }

    public static <T> int lastIndexOf(T[] ts, int fromIndex, Predicate<? super T> predicate) {
        return ArrayUtils.lastIndexOf(ts, 0, fromIndex, predicate);
    }

    public static <T> int lastIndexOf(T[] ts, int startIndex, int fromIndex, Predicate<? super T> predicate) {
        int iMax = ts.length;
        if (fromIndex >= 0) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (fromIndex >= iMax) {
                fromIndex = iMax - 1;
            }
            if (startIndex < fromIndex) {
                for (int i = fromIndex; i >= startIndex; --i) {
                    if (!predicate.test(ts[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int[] toArray(@NotNull BitSet bitSet) {
        int i = bitSet.cardinality();
        int[] bits = new int[i];
        int lastSet = bitSet.length();
        while (lastSet >= 0 && (lastSet = bitSet.previousSetBit(lastSet - 1)) >= 0) {
            bits[--i] = lastSet;
        }
        assert (i == 0);
        return bits;
    }
}

