/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.tree.BasedOffsetTracker;
import com.vladsch.flexmark.util.sequence.builder.tree.OffsetInfo;
import com.vladsch.flexmark.util.sequence.mappers.SpaceMapper;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownParagraph {
    private static final char MARKDOWN_START_LINE_CHAR = '\u2028';
    public static final List<SpecialLeadInHandler> EMPTY_LEAD_IN_HANDLERS = Collections.emptyList();
    public static final List<TrackedOffset> EMPTY_OFFSET_LIST = Collections.emptyList();
    @NotNull
    final BasedSequence baseSeq;
    @NotNull
    final BasedSequence altSeq;
    @NotNull
    final CharWidthProvider charWidthProvider;
    private BasedSequence firstIndent = BasedSequence.NULL;
    private BasedSequence indent = BasedSequence.NULL;
    private int firstWidthOffset = 0;
    int width = 0;
    boolean keepHardLineBreaks = true;
    boolean keepSoftLineBreaks = false;
    boolean unEscapeSpecialLeadInChars = true;
    boolean escapeSpecialLeadInChars = true;
    boolean restoreTrackedSpaces = false;
    @Nullable
    DataHolder options = null;
    @NotNull
    List<? extends SpecialLeadInHandler> leadInHandlers = EMPTY_LEAD_IN_HANDLERS;
    private List<TrackedOffset> trackedOffsets = EMPTY_OFFSET_LIST;
    private boolean trackedOffsetsSorted = true;

    public MarkdownParagraph(CharSequence chars) {
        this(BasedSequence.of((CharSequence)chars));
    }

    public MarkdownParagraph(BasedSequence chars) {
        this(chars, chars, CharWidthProvider.NULL);
    }

    public MarkdownParagraph(@NotNull BasedSequence chars, @NotNull CharWidthProvider charWidthProvider) {
        this(chars, chars, charWidthProvider);
    }

    public MarkdownParagraph(@NotNull BasedSequence chars, @NotNull BasedSequence altChars, @NotNull CharWidthProvider charWidthProvider) {
        this.baseSeq = chars;
        this.altSeq = altChars;
        this.charWidthProvider = charWidthProvider;
    }

    public BasedSequence wrapTextNotTracked() {
        if (this.getFirstWidth() <= 0) {
            return this.baseSeq;
        }
        LeftAlignedWrapping wrapping = new LeftAlignedWrapping(this.baseSeq);
        return wrapping.wrapText();
    }

    @NotNull
    public Range getContinuationStartSplice(int offset, boolean afterSpace, boolean afterDelete) {
        BasedSequence baseSequence = this.altSeq.getBaseSequence();
        assert (offset >= 0 && offset <= baseSequence.length());
        if (afterSpace && afterDelete) {
            int previousNonBlank;
            BasedOffsetTracker preFormatTracker = BasedOffsetTracker.create((BasedSequence)this.altSeq);
            int startOfLine = baseSequence.startOfLine(offset);
            if (startOfLine > this.altSeq.getStartOffset() && !baseSequence.isCharAt(offset, CharPredicate.SPACE_TAB_NBSP_LINE_SEP) && (previousNonBlank = baseSequence.lastIndexOfAnyNot(CharPredicate.SPACE_TAB_NBSP_EOL, offset - 1)) < startOfLine) {
                @NotNull OffsetInfo offsetInfo = preFormatTracker.getOffsetInfo(offset, true);
                int offsetIndex = offsetInfo.endIndex;
                int previousNonBlankIndex = this.altSeq.lastIndexOfAnyNot(CharPredicate.SPACE_TAB_NBSP_EOL, offsetIndex - 1);
                return Range.of((int)(previousNonBlankIndex + 1), (int)offsetIndex);
            }
        }
        return Range.NULL;
    }

    @NotNull
    BasedSequence resolveTrackedOffsets(@NotNull BasedSequence unwrapped, @NotNull BasedSequence wrapped) {
        int iMax;
        BasedOffsetTracker tracker = BasedOffsetTracker.create((BasedSequence)wrapped);
        int i = iMax = this.trackedOffsets.size();
        while (i-- > 0) {
            OffsetInfo info;
            TrackedOffset trackedOffset = this.trackedOffsets.get(i);
            int offset = trackedOffset.getOffset();
            boolean baseIsWhiteSpaceAtOffset = unwrapped.isBaseCharAt(offset, CharPredicate.WHITESPACE_NBSP);
            if (baseIsWhiteSpaceAtOffset && !unwrapped.isBaseCharAt(offset - 1, CharPredicate.WHITESPACE_NBSP)) {
                info = tracker.getOffsetInfo(offset - 1, false);
                trackedOffset.setIndex(info.endIndex);
                continue;
            }
            if (!baseIsWhiteSpaceAtOffset && unwrapped.isBaseCharAt(offset + 1, CharPredicate.WHITESPACE_NBSP)) {
                info = tracker.getOffsetInfo(offset, false);
                trackedOffset.setIndex(info.startIndex);
                continue;
            }
            info = tracker.getOffsetInfo(offset, true);
            trackedOffset.setIndex(info.endIndex);
        }
        return wrapped;
    }

    public BasedSequence wrapText() {
        int iMax;
        if (this.getFirstWidth() <= 0) {
            return this.baseSeq;
        }
        if (this.trackedOffsets.isEmpty()) {
            return this.wrapTextNotTracked();
        }
        this.sortedTrackedOffsets();
        BasedSequence baseSpliced = this.baseSeq;
        BasedSequence altSpliced = this.altSeq;
        Range lastRange = Range.NULL;
        int i = iMax = this.trackedOffsets.size();
        while (i-- > 0) {
            TrackedOffset trackedOffset = this.trackedOffsets.get(i);
            if (!lastRange.isEmpty() && lastRange.contains(trackedOffset.getOffset()) || !(lastRange = this.getContinuationStartSplice(trackedOffset.getOffset(), trackedOffset.isAfterSpaceEdit(), trackedOffset.isAfterDelete())).isNotEmpty()) continue;
            trackedOffset.setSpliced(true);
            baseSpliced = (BasedSequence)baseSpliced.delete(lastRange.getStart(), lastRange.getEnd());
            altSpliced = (BasedSequence)altSpliced.delete(lastRange.getStart(), lastRange.getEnd());
        }
        assert (baseSpliced.equals(altSpliced));
        LeftAlignedWrapping textWrapper = new LeftAlignedWrapping(baseSpliced);
        BasedSequence wrapped = textWrapper.wrapText();
        if (this.restoreTrackedSpaces) {
            if (this.indent.isNotEmpty() || this.firstIndent.isNotEmpty()) {
                throw new IllegalStateException("restoreTrackedSpaces is not supported with indentation applied by MarkdownParagraph");
            }
            wrapped = this.resolveTrackedOffsetsEdit(baseSpliced, altSpliced, wrapped);
        } else {
            wrapped = this.resolveTrackedOffsets(this.baseSeq, wrapped);
        }
        return wrapped;
    }

    BasedSequence resolveTrackedOffsetsEdit(BasedSequence baseSpliced, BasedSequence altSpliced, BasedSequence wrapped) {
        Boolean inTest = (Boolean)SharedDataKeys.RUNNING_TESTS.get(this.options);
        BasedSequence spliced = BasedSequence.of((CharSequence)baseSpliced.toString());
        LeftAlignedWrapping altTextWrapper = new LeftAlignedWrapping(spliced);
        BasedSequence altWrapped = ((SequenceBuilder)spliced.getBuilder().append((CharSequence)altTextWrapper.wrapText())).toSequence(altSpliced, CharPredicate.LINE_SEP, CharPredicate.SPACE_TAB_EOL);
        BasedOffsetTracker tracker = BasedOffsetTracker.create((BasedSequence)this.altSeq);
        BasedOffsetTracker altTracker = BasedOffsetTracker.create((BasedSequence)altWrapped);
        int iMax = this.trackedOffsets.size();
        BasedSequence baseSequence = this.altSeq.getBaseSequence();
        BasedSequence altUnwrapped = this.altSeq;
        int restoredAppendSpaces = 0;
        int i = iMax;
        while (i-- > 0) {
            int anchorIndex;
            int anchorOffset;
            TrackedOffset trackedOffset = this.trackedOffsets.get(i);
            int offset = trackedOffset.getOffset();
            int countedSpacesBefore = baseSequence.countTrailing(CharPredicate.SPACE_TAB_NBSP, offset);
            int countedSpacesAfter = baseSequence.countLeading(CharPredicate.SPACE_TAB_NBSP, offset);
            int countedWhitespaceBefore = baseSequence.countTrailing(CharPredicate.SPACE_TAB_NBSP_EOL, offset);
            int countedWhiteSpaceAfter = baseSequence.countLeading(CharPredicate.SPACE_TAB_NBSP_EOL, offset);
            if (inTest.booleanValue()) {
                assert (trackedOffset.getSpacesBefore() == countedSpacesBefore);
                assert (trackedOffset.getSpacesAfter() == countedSpacesAfter);
            }
            char baseCharAt = baseSequence.safeCharAt(offset);
            char prevBaseCharAt = baseSequence.safeCharAt(offset - countedSpacesBefore - 1);
            char nextBaseCharAt = baseSequence.safeCharAt(offset + countedSpacesAfter);
            int anchorDelta = 0;
            boolean isLineSep = false;
            String anchorResolvedBy = "";
            if (inTest.booleanValue()) {
                System.out.println(trackedOffset);
            }
            if (!CharPredicate.SPACE_TAB_NBSP.test(baseCharAt)) {
                anchorOffset = offset;
                anchorIndex = tracker.getOffsetInfo((int)anchorOffset, (boolean)false).startIndex;
                if (altUnwrapped.safeCharAt(anchorIndex - 1) == '\u2028') {
                    isLineSep = true;
                    anchorResolvedBy = "LSep ";
                }
            } else if (!CharPredicate.SPACE_TAB_NBSP_EOL.test(prevBaseCharAt)) {
                anchorOffset = offset - countedWhitespaceBefore;
                anchorIndex = tracker.getOffsetInfo((int)(anchorOffset - 1), (boolean)false).endIndex;
                anchorResolvedBy = "Prev ";
            } else if (!CharPredicate.SPACE_TAB_NBSP_EOL.test(nextBaseCharAt)) {
                anchorOffset = offset + countedWhiteSpaceAfter;
                anchorIndex = tracker.getOffsetInfo((int)anchorOffset, (boolean)false).startIndex;
                anchorResolvedBy = "Next ";
            } else {
                throw new IllegalStateException(String.format("Should not be here. altSeq: '%s'", altUnwrapped));
            }
            if (inTest.booleanValue()) {
                System.out.println(String.format("%sBaseSequence offset: `%s`", anchorResolvedBy, ((BasedSequence)baseSequence.safeSubSequence(offset - 10, offset)).toVisibleWhitespaceString() + "|" + ((BasedSequence)baseSequence.safeSubSequence(offset, offset + 10)).toVisibleWhitespaceString()));
                System.out.println(String.format("%sBaseSequence anchor: `%s`", anchorResolvedBy, ((BasedSequence)baseSequence.safeSubSequence(anchorOffset - 10, anchorOffset)).toVisibleWhitespaceString() + "|" + ((BasedSequence)baseSequence.safeSubSequence(anchorOffset, anchorOffset + 10)).toVisibleWhitespaceString()));
                System.out.println(String.format("%saltUnwrapped anchor: `%s`", anchorResolvedBy, ((BasedSequence)altUnwrapped.safeSubSequence(anchorIndex - 10, anchorIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)altUnwrapped.safeSubSequence(anchorIndex, anchorIndex + 10)).toVisibleWhitespaceString()));
            }
            int wrappedIndex = altTracker.getOffsetInfo((int)anchorOffset, (boolean)false).startIndex;
            if (inTest.booleanValue()) {
                System.out.println(String.format("altWrapped anchor: `%s`", ((BasedSequence)altWrapped.safeSubSequence(wrappedIndex - 10, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)altWrapped.safeSubSequence(wrappedIndex, wrappedIndex + 10)).toVisibleWhitespaceString()));
                System.out.println(String.format("wrapped anchor: `%s`", ((BasedSequence)wrapped.safeSubSequence(wrappedIndex - 10, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)wrapped.safeSubSequence(wrappedIndex, wrappedIndex + 10)).toVisibleWhitespaceString()));
            }
            assert (SpaceMapper.areEquivalent((char)baseSequence.safeCharAt(anchorOffset), (char)altUnwrapped.safeCharAt(anchorIndex + anchorDelta)) || baseSequence.isCharAt(anchorOffset, CharPredicate.WHITESPACE_NBSP_OR_NUL) && altUnwrapped.isCharAt(anchorIndex + anchorDelta, CharPredicate.WHITESPACE_NBSP_OR_NUL)) : String.format("baseSeq.charAt(%d): '%s':0x%04x != altUnwrapped.charAt(%d=%d+%d): '%s':0x%04x, baseSequence anchor: '%s', altUnwrapped anchor: '%s', altWrapped anchor: '%s', wrapped anchor: '%s'", anchorOffset, String.valueOf(baseSequence.safeCharAt(anchorOffset)), (int)baseSequence.safeCharAt(anchorOffset), anchorIndex + anchorDelta, anchorIndex, anchorDelta, String.valueOf(altUnwrapped.safeCharAt(anchorIndex + anchorDelta)), (int)altUnwrapped.safeCharAt(anchorIndex + anchorDelta), ((BasedSequence)baseSequence.safeSubSequence(anchorOffset - 10, anchorOffset)).toVisibleWhitespaceString() + "|" + ((BasedSequence)baseSequence.safeSubSequence(anchorOffset, anchorOffset + 10)).toVisibleWhitespaceString(), ((BasedSequence)altUnwrapped.safeSubSequence(anchorIndex + anchorDelta - 10, anchorIndex + anchorDelta)).toVisibleWhitespaceString() + "|" + ((BasedSequence)altUnwrapped.safeSubSequence(anchorIndex + anchorDelta, anchorIndex + anchorDelta + 10)).toVisibleWhitespaceString(), ((BasedSequence)altWrapped.safeSubSequence(wrappedIndex - 10, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)altWrapped.safeSubSequence(wrappedIndex, wrappedIndex + 10)).toVisibleWhitespaceString(), ((BasedSequence)wrapped.safeSubSequence(wrappedIndex - 10, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)wrapped.safeSubSequence(wrappedIndex, wrappedIndex + 10)).toVisibleWhitespaceString());
            int wrappedAdjusted = 0;
            int unwrappedAdjusted = 0;
            int addSpacesBeforeEol = 0;
            if (CharPredicate.WHITESPACE_NBSP.test(altUnwrapped.safeCharAt(anchorIndex + anchorDelta))) {
                if (CharPredicate.WHITESPACE_NBSP_OR_NUL.test(altWrapped.safeCharAt(wrappedIndex))) {
                    unwrappedAdjusted = -1;
                    wrappedAdjusted = -1;
                } else {
                    addSpacesBeforeEol = 1;
                    unwrappedAdjusted = altUnwrapped.countLeading(CharPredicate.WHITESPACE_NBSP, anchorIndex + anchorDelta);
                }
            } else if (altUnwrapped.safeCharAt(anchorIndex + anchorDelta) == '\u2028') {
                if (!CharPredicate.WHITESPACE_NBSP.test(altUnwrapped.safeCharAt(anchorIndex + anchorDelta - 1))) {
                    --wrappedAdjusted;
                    --unwrappedAdjusted;
                } else {
                    assert (!CharPredicate.WHITESPACE_NBSP.test(altUnwrapped.safeCharAt(anchorIndex + ++anchorDelta))) : String.format("Character(%s) after LS should not be whitespace.", SequenceUtils.toVisibleWhitespaceString((CharSequence)Character.toString(altUnwrapped.safeCharAt(anchorIndex + anchorDelta))));
                    isLineSep = true;
                }
            }
            if (inTest.booleanValue()) {
                int useIndex = anchorIndex + anchorDelta + unwrappedAdjusted;
                System.out.println(String.format("adjusted altWrapped anchor: `%s`", ((BasedSequence)altWrapped.safeSubSequence(useIndex - 10, useIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)altWrapped.safeSubSequence(useIndex, useIndex + 10)).toVisibleWhitespaceString()));
                int useWrapIndex = wrappedIndex + wrappedAdjusted;
                System.out.println(String.format("adjusted wrapped anchor: `%s`", ((BasedSequence)wrapped.safeSubSequence(useWrapIndex - 10, useWrapIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)wrapped.safeSubSequence(useWrapIndex, useWrapIndex + 10)).toVisibleWhitespaceString()));
            }
            char altUnwrappedCharAt = altUnwrapped.safeCharAt(anchorIndex + anchorDelta + unwrappedAdjusted);
            char wrappedCharAt = wrapped.safeCharAt(wrappedIndex + wrappedAdjusted);
            assert (SpaceMapper.areEquivalent((char)altUnwrappedCharAt, (char)wrappedCharAt) || CharPredicate.WHITESPACE_NBSP.test(altUnwrappedCharAt) && CharPredicate.WHITESPACE_NBSP.test(wrappedCharAt)) : String.format("altUnwrapped.charAt: '%s'(%d) != wrapped.charAt: '%s'(%d) for width=%d, unwrapped: '%s', wrapped: '%s'", SequenceUtils.toVisibleWhitespaceString((CharSequence)Character.toString(altUnwrappedCharAt)), (int)altUnwrappedCharAt, SequenceUtils.toVisibleWhitespaceString((CharSequence)Character.toString(wrappedCharAt)), (int)wrappedCharAt, this.width, SequenceUtils.toVisibleWhitespaceString((CharSequence)altUnwrapped), SequenceUtils.toVisibleWhitespaceString((CharSequence)altWrapped));
            if (isLineSep) {
                wrappedIndex = Math.max(0, wrappedIndex - 1);
                if (inTest.booleanValue()) {
                    System.out.println(String.format("LSep Adj wrapped anchor: `%s`", ((BasedSequence)wrapped.safeSubSequence(wrappedIndex - 10, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)wrapped.safeSubSequence(wrappedIndex, wrappedIndex + 10)).toVisibleWhitespaceString()));
                }
            }
            if (wrapped.isCharAt(wrappedIndex - 1, CharPredicate.ANY_EOL) && countedSpacesAfter > 0) {
                wrappedIndex -= wrapped.eolEndLength(wrappedIndex);
            }
            int wrappedSpacesBefore = wrapped.countTrailing(CharPredicate.SPACE_TAB_NBSP, wrappedIndex);
            int wrappedSpacesAfter = wrapped.countLeading(CharPredicate.SPACE_TAB_NBSP, wrappedIndex);
            if (trackedOffset.isAfterSpaceEdit()) {
                if (trackedOffset.isAfterInsert()) {
                    countedSpacesBefore = Math.max(1, countedSpacesBefore);
                } else if (trackedOffset.isAfterDelete()) {
                    countedSpacesBefore = 0;
                }
            }
            int addSpacesBefore = trackedOffset.isSpliced() ? 0 : Math.max(0, countedSpacesBefore - wrappedSpacesBefore);
            int addSpacesAfter = Math.max(addSpacesBeforeEol, countedSpacesAfter - wrappedSpacesAfter);
            if (wrapped.isCharAt(wrappedIndex, CharPredicate.ANY_EOL_NUL)) {
                addSpacesAfter = 0;
                if (trackedOffset.isAfterDelete()) {
                    addSpacesBefore = Math.min(1, addSpacesBefore);
                }
            } else if (!wrapped.isCharAt(wrappedIndex - 1, CharPredicate.ANY_EOL_NUL)) {
                addSpacesBefore = Math.min(1, addSpacesBefore);
            } else if (trackedOffset.isAfterDelete() && !trackedOffset.isAfterSpaceEdit()) {
                addSpacesBefore = 0;
                addSpacesAfter = Math.min(1, addSpacesAfter);
            } else {
                if (!trackedOffset.isAfterInsert() && !trackedOffset.isAfterDelete()) {
                    addSpacesAfter = 0;
                }
                addSpacesBefore = 0;
            }
            if (addSpacesBefore + addSpacesAfter > 0) {
                int lastNonBlank = wrapped.lastIndexOfAnyNot(CharPredicate.WHITESPACE_NBSP);
                if (wrappedIndex < lastNonBlank) {
                    wrapped = (BasedSequence)wrapped.insert(wrappedIndex, RepeatedSequence.ofSpaces((int)(addSpacesBefore + addSpacesAfter)));
                    for (int j = i + 1; j < iMax; ++j) {
                        TrackedOffset trackedOffset1 = this.trackedOffsets.get(j);
                        int indexJ = trackedOffset1.getIndex();
                        trackedOffset1.setIndex(indexJ + addSpacesBefore + addSpacesAfter);
                    }
                } else {
                    restoredAppendSpaces = Math.max(restoredAppendSpaces, addSpacesBefore);
                }
                wrappedIndex += addSpacesBefore;
            }
            trackedOffset.setIndex(wrappedIndex);
            if (!inTest.booleanValue()) continue;
            System.out.println(String.format("Adj wrapped anchor: `%s`", ((BasedSequence)wrapped.safeSubSequence(wrappedIndex - 20, wrappedIndex)).toVisibleWhitespaceString() + "|" + ((BasedSequence)wrapped.safeSubSequence(wrappedIndex, wrappedIndex + 20)).toVisibleWhitespaceString()));
            System.out.println();
        }
        if (restoredAppendSpaces > 0) {
            wrapped = (BasedSequence)wrapped.appendSpaces(restoredAppendSpaces);
        }
        return wrapped;
    }

    public void addTrackedOffset(@NotNull TrackedOffset trackedOffset) {
        if (this.trackedOffsets == EMPTY_OFFSET_LIST) {
            this.trackedOffsets = new ArrayList<TrackedOffset>();
        }
        assert (trackedOffset.getOffset() >= 0 && trackedOffset.getOffset() <= this.altSeq.getBaseSequence().length());
        this.trackedOffsets.removeIf(it -> it.getOffset() == trackedOffset.getOffset());
        this.trackedOffsets.add(trackedOffset);
        this.trackedOffsetsSorted = false;
    }

    public List<TrackedOffset> getTrackedOffsets() {
        return this.sortedTrackedOffsets();
    }

    private List<TrackedOffset> sortedTrackedOffsets() {
        if (!this.trackedOffsetsSorted) {
            this.trackedOffsets.sort(Comparator.comparing(TrackedOffset::getOffset));
            this.trackedOffsetsSorted = true;
        }
        return this.trackedOffsets;
    }

    @Nullable
    public TrackedOffset getTrackedOffset(int offset) {
        this.sortedTrackedOffsets();
        for (TrackedOffset trackedOffset : this.trackedOffsets) {
            if (trackedOffset.getOffset() == offset) {
                return trackedOffset;
            }
            if (trackedOffset.getOffset() <= offset) continue;
            break;
        }
        return null;
    }

    @NotNull
    public List<? extends SpecialLeadInHandler> getLeadInHandlers() {
        return this.leadInHandlers;
    }

    public void setLeadInHandlers(@NotNull List<? extends SpecialLeadInHandler> leadInHandlers) {
        this.leadInHandlers = leadInHandlers;
    }

    @Nullable
    public DataHolder getOptions() {
        return this.options;
    }

    public void setOptions(@Nullable DataHolder options) {
        this.options = options;
    }

    public boolean isRestoreTrackedSpaces() {
        return this.restoreTrackedSpaces;
    }

    public void setRestoreTrackedSpaces(boolean restoreTrackedSpaces) {
        this.restoreTrackedSpaces = restoreTrackedSpaces;
    }

    @NotNull
    public BasedSequence getChars() {
        return this.baseSeq;
    }

    public CharSequence getFirstIndent() {
        return this.firstIndent;
    }

    public void setFirstIndent(CharSequence firstIndent) {
        this.firstIndent = BasedSequence.of((CharSequence)firstIndent);
    }

    public CharSequence getIndent() {
        return this.indent;
    }

    public void setIndent(CharSequence indent) {
        this.indent = BasedSequence.of((CharSequence)indent);
        if (this.firstIndent.isNull()) {
            this.firstIndent = this.indent;
        }
    }

    public int getFirstWidth() {
        return this.width == 0 ? 0 : Math.max(0, this.width + this.firstWidthOffset);
    }

    public int getFirstWidthOffset() {
        return this.firstWidthOffset;
    }

    public void setFirstWidthOffset(int firstWidthOffset) {
        this.firstWidthOffset = firstWidthOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = Math.max(0, width);
    }

    public boolean getKeepHardBreaks() {
        return this.keepHardLineBreaks;
    }

    public void setKeepHardBreaks(boolean keepHardBreaks) {
        this.keepHardLineBreaks = keepHardBreaks;
    }

    public boolean getKeepSoftBreaks() {
        return this.keepSoftLineBreaks;
    }

    public boolean isUnEscapeSpecialLeadIn() {
        return this.unEscapeSpecialLeadInChars;
    }

    public void setUnEscapeSpecialLeadIn(boolean unEscapeSpecialLeadInChars) {
        this.unEscapeSpecialLeadInChars = unEscapeSpecialLeadInChars;
    }

    public boolean isEscapeSpecialLeadIn() {
        return this.escapeSpecialLeadInChars;
    }

    public void setEscapeSpecialLeadIn(boolean escapeSpecialLeadInChars) {
        this.escapeSpecialLeadInChars = escapeSpecialLeadInChars;
    }

    public void setKeepSoftBreaks(boolean keepLineBreaks) {
        this.keepSoftLineBreaks = keepLineBreaks;
    }

    @NotNull
    public CharWidthProvider getCharWidthProvider() {
        return this.charWidthProvider;
    }

    public static class TextTokenizer {
        private final CharSequence chars;
        private final int maxIndex;
        private int index = 0;
        private int lastPos = 0;
        private boolean isInWord = false;
        private boolean isFirstNonBlank = true;
        private int lastConsecutiveSpaces = 0;
        @Nullable
        private Token token = null;

        TextTokenizer(@NotNull CharSequence chars) {
            this.chars = chars;
            this.maxIndex = this.chars.length();
            this.reset();
        }

        public void reset() {
            this.index = 0;
            this.lastPos = 0;
            this.isInWord = false;
            this.token = null;
            this.lastConsecutiveSpaces = 0;
            this.isFirstNonBlank = true;
            this.next();
        }

        @Nullable
        Token getToken() {
            return this.token;
        }

        @NotNull
        public List<Token> asList() {
            ArrayList<Token> tokens = new ArrayList<Token>();
            this.reset();
            while (this.token != null) {
                tokens.add(this.token);
                this.next();
            }
            return tokens;
        }

        void next() {
            this.token = null;
            while (this.index < this.maxIndex) {
                char c = this.chars.charAt(this.index);
                if (this.isInWord) {
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\u2028') {
                        this.isInWord = false;
                        boolean isFirstWord = this.isFirstNonBlank;
                        this.isFirstNonBlank = false;
                        if (this.lastPos >= this.index) continue;
                        this.token = Token.of(TextType.WORD, this.lastPos, this.index, isFirstWord);
                        this.lastPos = this.index;
                        break;
                    }
                    ++this.index;
                    continue;
                }
                if (c != ' ' && c != '\t' && c != '\n' && c != '\u2028') {
                    if (this.lastPos < this.index) {
                        this.token = Token.of(TextType.SPACE, this.lastPos, this.index);
                        this.lastPos = this.index;
                        this.isInWord = true;
                        this.lastConsecutiveSpaces = 0;
                        break;
                    }
                    this.isInWord = true;
                    this.lastConsecutiveSpaces = 0;
                    continue;
                }
                if (c == '\n') {
                    this.token = this.lastConsecutiveSpaces >= 2 ? Token.of(TextType.MARKDOWN_BREAK, this.index - this.lastConsecutiveSpaces, this.index + 1) : Token.of(TextType.BREAK, this.index, this.index + 1);
                    this.lastPos = this.index + 1;
                    this.lastConsecutiveSpaces = 0;
                    this.isFirstNonBlank = true;
                    ++this.index;
                    break;
                }
                if (c == '\u2028') {
                    this.token = Token.of(TextType.MARKDOWN_START_LINE, this.index, this.index + 1);
                    this.lastPos = this.index + 1;
                    this.lastConsecutiveSpaces = 0;
                    ++this.index;
                    break;
                }
                this.lastConsecutiveSpaces = c == ' ' ? ++this.lastConsecutiveSpaces : 0;
                ++this.index;
            }
            if (this.lastPos < this.index) {
                if (this.isInWord) {
                    this.token = Token.of(TextType.WORD, this.lastPos, this.index, this.isFirstNonBlank);
                    this.isFirstNonBlank = false;
                } else {
                    this.token = Token.of(TextType.SPACE, this.lastPos, this.index);
                }
                this.lastPos = this.index;
            }
        }
    }

    class LeftAlignedWrapping {
        @NotNull
        final BasedSequence baseSeq;
        final SequenceBuilder result;
        final TextTokenizer tokenizer;
        int col = 0;
        int lineCount = 0;
        final int spaceWidth;
        CharSequence lineIndent;
        final CharSequence nextIndent;
        int lineWidth;
        final int nextWidth;
        int wordsOnLine;
        BasedSequence lastSpace;
        @NotNull
        List<? extends SpecialLeadInHandler> leadInHandlers;
        boolean unEscapeSpecialLeadInChars;
        boolean escapeSpecialLeadInChars;

        LeftAlignedWrapping(BasedSequence baseSeq) {
            this.spaceWidth = MarkdownParagraph.this.charWidthProvider.getSpaceWidth();
            this.lineIndent = MarkdownParagraph.this.getFirstIndent();
            this.nextIndent = MarkdownParagraph.this.getIndent();
            this.lineWidth = this.spaceWidth * MarkdownParagraph.this.getFirstWidth();
            this.nextWidth = MarkdownParagraph.this.width <= 0 ? Integer.MAX_VALUE : this.spaceWidth * MarkdownParagraph.this.width;
            this.wordsOnLine = 0;
            this.lastSpace = null;
            this.leadInHandlers = MarkdownParagraph.this.leadInHandlers;
            this.unEscapeSpecialLeadInChars = MarkdownParagraph.this.unEscapeSpecialLeadInChars;
            this.escapeSpecialLeadInChars = MarkdownParagraph.this.escapeSpecialLeadInChars;
            this.baseSeq = baseSeq;
            this.result = SequenceBuilder.emptyBuilder((BasedSequence)baseSeq);
            this.tokenizer = new TextTokenizer((CharSequence)baseSeq);
        }

        void advance() {
            this.tokenizer.next();
        }

        void addToken(Token token) {
            this.addChars((CharSequence)this.baseSeq.subSequence(token.range.getStart(), token.range.getEnd()));
        }

        void addChars(CharSequence charSequence) {
            this.result.append(charSequence);
            this.col += MarkdownParagraph.this.charWidthProvider.getStringWidth(charSequence);
        }

        void addSpaces(int count) {
            this.result.append(' ', count);
            this.col += MarkdownParagraph.this.charWidthProvider.getSpaceWidth() * count;
        }

        BasedSequence addSpaces(BasedSequence sequence, int count) {
            if (count <= 0) {
                return sequence;
            }
            BasedSequence remainder = null;
            if (sequence != null) {
                this.addChars((CharSequence)sequence.subSequence(0, Math.min(sequence.length(), count)));
                if (sequence.length() > count) {
                    remainder = (BasedSequence)sequence.subSequence(count);
                }
                count = Math.max(0, count - sequence.length());
            }
            if (count > 0) {
                this.addSpaces(count);
            }
            return remainder;
        }

        void afterLineBreak() {
            this.col = 0;
            this.wordsOnLine = 0;
            ++this.lineCount;
            this.lineIndent = this.nextIndent;
            this.lineWidth = this.nextWidth;
            this.lastSpace = null;
        }

        void processLeadInEscape(List<? extends SpecialLeadInHandler> handlers, BasedSequence sequence) {
            if (sequence.isNotEmpty() && this.escapeSpecialLeadInChars) {
                for (SpecialLeadInHandler specialLeadInHandler : handlers) {
                    if (!specialLeadInHandler.escape(sequence, MarkdownParagraph.this.options, this::addChars)) continue;
                    return;
                }
            }
            this.addChars((CharSequence)sequence);
        }

        void processLeadInUnEscape(List<? extends SpecialLeadInHandler> handlers, BasedSequence sequence) {
            if (sequence.isNotEmpty() && this.unEscapeSpecialLeadInChars) {
                for (SpecialLeadInHandler specialLeadInHandler : handlers) {
                    if (!specialLeadInHandler.unEscape(sequence, MarkdownParagraph.this.options, this::addChars)) continue;
                    return;
                }
            }
            this.addChars((CharSequence)sequence);
        }

        @NotNull
        BasedSequence wrapText() {
            Token token;
            while ((token = this.tokenizer.getToken()) != null) {
                switch (token.type) {
                    case SPACE: {
                        if (this.col != 0) {
                            this.lastSpace = (BasedSequence)this.baseSeq.subSequence(token.range);
                        }
                        this.advance();
                        break;
                    }
                    case WORD: {
                        if (this.col == 0 || this.col + MarkdownParagraph.this.charWidthProvider.getStringWidth((CharSequence)token.subSequence(this.baseSeq)) + this.spaceWidth <= this.lineWidth) {
                            boolean firstNonBlank;
                            boolean bl = firstNonBlank = this.col == 0;
                            if (this.col > 0) {
                                this.lastSpace = this.addSpaces(this.lastSpace, 1);
                            } else if (!SequenceUtils.isEmpty((CharSequence)this.lineIndent)) {
                                this.addChars(this.lineIndent);
                            }
                            if (firstNonBlank && !token.isFirstWord) {
                                this.processLeadInEscape(this.leadInHandlers, (BasedSequence)this.baseSeq.subSequence(token.range));
                            } else if (!firstNonBlank && token.isFirstWord) {
                                this.processLeadInUnEscape(this.leadInHandlers, (BasedSequence)this.baseSeq.subSequence(token.range));
                            } else {
                                this.addToken(token);
                            }
                            this.advance();
                            ++this.wordsOnLine;
                            break;
                        }
                        this.addChars("\n");
                        this.afterLineBreak();
                        break;
                    }
                    case MARKDOWN_START_LINE: {
                        if (this.col > 0) {
                            this.addChars("\n");
                            this.afterLineBreak();
                        }
                        this.advance();
                        break;
                    }
                    case MARKDOWN_BREAK: {
                        if (MarkdownParagraph.this.keepHardLineBreaks) {
                            if (this.col > 0) {
                                this.addToken(token);
                                this.afterLineBreak();
                            }
                        } else {
                            this.lastSpace = (BasedSequence)this.baseSeq.subSequence(token.range);
                        }
                        this.advance();
                        break;
                    }
                    case BREAK: {
                        if (this.col > 0 && MarkdownParagraph.this.keepSoftLineBreaks) {
                            this.addToken(token);
                            this.afterLineBreak();
                        }
                        this.advance();
                    }
                }
            }
            return this.result.toSequence();
        }
    }

    public static class Token {
        @NotNull
        public final TextType type;
        @NotNull
        public final Range range;
        public final boolean isFirstWord;

        private Token(@NotNull TextType type, @NotNull Range range, boolean isFirstWord) {
            this.type = type;
            this.range = range;
            this.isFirstWord = isFirstWord;
        }

        public String toString() {
            return "token: " + (Object)((Object)this.type) + " " + this.range + (this.isFirstWord ? " isFirst" : "");
        }

        public BasedSequence subSequence(BasedSequence charSequence) {
            return this.range.basedSubSequence((CharSequence)charSequence);
        }

        public CharSequence subSequence(CharSequence charSequence) {
            return this.range.charSubSequence(charSequence);
        }

        @NotNull
        public static Token of(@NotNull TextType type, @NotNull Range range) {
            return new Token(type, range, false);
        }

        @NotNull
        public static Token of(@NotNull TextType type, int start, int end) {
            return new Token(type, Range.of((int)start, (int)end), false);
        }

        @NotNull
        public static Token of(@NotNull TextType type, @NotNull Range range, boolean isFirstWord) {
            return new Token(type, range, isFirstWord);
        }

        @NotNull
        public static Token of(@NotNull TextType type, int start, int end, boolean isFirstWord) {
            return new Token(type, Range.of((int)start, (int)end), isFirstWord);
        }
    }

    public static enum TextType {
        WORD,
        SPACE,
        BREAK,
        MARKDOWN_BREAK,
        MARKDOWN_START_LINE;

    }
}

