/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection;

import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitIntegerSet
implements Set<Integer>,
ReversibleIterable<Integer> {
    public static final int[] EMPTY_INT = new int[0];
    @NotNull
    private final BitSet myBits;
    private final boolean myReversed;

    public BitIntegerSet() {
        this(0);
    }

    public BitIntegerSet(int i) {
        this.myBits = new BitSet(i);
        this.myReversed = false;
    }

    public BitIntegerSet(@NotNull BitSet other) {
        this.myBits = (BitSet)other.clone();
        this.myReversed = false;
    }

    public BitIntegerSet(@NotNull BitIntegerSet other) {
        this(other, other.isReversed());
    }

    private BitIntegerSet(@NotNull BitIntegerSet other, boolean reversed) {
        this.myBits = (BitSet)other.myBits.clone();
        this.myReversed = reversed;
    }

    public int cardinality() {
        return this.myBits.cardinality();
    }

    public int cardinality(int start) {
        return this.cardinality(start, this.myBits.length());
    }

    public int cardinality(int start, int end) {
        int count = 0;
        if (start >= 0 && end > 0 && start < end) {
            int firstBit = this.myBits.nextSetBit(0);
            int lastBit = this.myBits.previousSetBit(this.myBits.length()) + 1;
            if (start < firstBit) {
                start = firstBit;
            }
            if (end > lastBit) {
                end = lastBit;
            }
            if (start <= end && this.myBits.length() > 0) {
                int startIndex = start >> 6;
                int endIndex = end >> 6;
                long startMask = -1L << (start & 0x3F);
                long endMask = -1L << (end & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
                if (endMask == 0L) {
                    --endIndex;
                    endMask = -1L;
                }
                long[] words = this.myBits.toLongArray();
                for (int i = startIndex; i <= endIndex; ++i) {
                    long word = words[i];
                    if (i == startIndex) {
                        word &= startMask;
                    }
                    if (i == endIndex) {
                        word &= endMask;
                    }
                    count += Long.bitCount(word);
                }
            }
        }
        return count;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return o instanceof Integer && this.myBits.get((Integer)o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] array = new Object[this.cardinality()];
        int i = 0;
        for (Integer bitIndex : this) {
            array[i++] = bitIndex;
        }
        return array;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        Object[] objects = array;
        int count = this.cardinality();
        if (!array.getClass().getComponentType().isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("Cannot store Integer in array of " + array.getClass().getName());
        }
        if (array.length < count) {
            objects = array.getClass() == Object[].class ? new Object[count] : (Object[])Array.newInstance(array.getClass().getComponentType(), count);
        }
        int i = 0;
        for (Integer bitIndex : this) {
            array[i++] = bitIndex;
        }
        if (objects.length > ++i) {
            objects[i] = null;
        }
        return objects;
    }

    @Override
    public boolean add(@NotNull Integer item) {
        boolean old = this.myBits.get(item);
        this.myBits.set(item);
        return old;
    }

    @NotNull
    public int[] toArray(@Nullable int[] array) {
        return this.toArray(array, 0);
    }

    @NotNull
    public int[] toArray(@Nullable int[] array, int destinationIndex) {
        int arrayLength;
        int n = arrayLength = array == null ? 0 : array.length;
        assert (destinationIndex <= arrayLength);
        int[] useArray = array;
        int size = this.cardinality();
        if (size == 0) {
            return useArray == null ? EMPTY_INT : useArray;
        }
        if (array == null || arrayLength < destinationIndex + size) {
            useArray = new int[destinationIndex + size];
            if (array != null) {
                System.arraycopy(array, 0, useArray, 0, destinationIndex);
            }
        }
        int[] i = new int[]{destinationIndex};
        int[] finalUseArray = useArray;
        this.forEach((int value) -> {
            int n = i[0];
            i[0] = n + 1;
            finalUseArray[n] = value;
        });
        return finalUseArray;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (!(o instanceof Integer) || !this.myBits.get((Integer)o)) {
            return false;
        }
        this.myBits.clear((Integer)o);
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        if (collection instanceof BitIntegerSet) {
            BitSet other = ((BitIntegerSet)collection).myBits;
            BitSet bitSet = (BitSet)this.myBits.clone();
            bitSet.xor(other);
            bitSet.and(other);
            return bitSet.isEmpty();
        }
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int ... collection) {
        return this.addAll(collection, 0, Integer.MAX_VALUE);
    }

    public boolean addAll(@NotNull int[] collection, int startIndex) {
        return this.addAll(collection, startIndex, Integer.MAX_VALUE);
    }

    public boolean addAll(@NotNull int[] collection, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        boolean changed = false;
        int iMax = Math.min(collection.length, endIndex);
        for (int i = startIndex; i < iMax; ++i) {
            if (!this.add(collection[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> collection) {
        if (collection instanceof BitIntegerSet) {
            BitSet other = ((BitIntegerSet)collection).myBits;
            BitSet bitSet = (BitSet)this.myBits.clone();
            this.myBits.or(other);
            bitSet.xor(bitSet);
            return !bitSet.isEmpty();
        }
        boolean changed = false;
        for (Integer n : collection) {
            if (!this.add(n)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        BitSet other;
        if (!(collection instanceof BitSet)) {
            other = new BitSet();
            for (Object o : collection) {
                if (!this.contains(o)) continue;
                other.set((Integer)o);
            }
        } else {
            other = (BitSet)((Object)collection);
        }
        BitSet bitSet = (BitSet)this.myBits.clone();
        this.myBits.and(other);
        bitSet.xor(bitSet);
        return !bitSet.isEmpty();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        if (collection instanceof BitIntegerSet) {
            BitSet other = ((BitIntegerSet)collection).myBits;
            BitSet bitSet = (BitSet)this.myBits.clone();
            this.myBits.andNot(other);
            bitSet.xor(bitSet);
            return !bitSet.isEmpty();
        }
        boolean changed = false;
        for (Object o : collection) {
            if (!this.contains(o)) continue;
            this.myBits.clear((Integer)o);
            changed = true;
        }
        return changed;
    }

    @Override
    public void forEach(@NotNull Consumer<? super Integer> consumer) {
        int index = this.myBits.nextSetBit(0);
        while (index >= 0) {
            consumer.accept((Integer)index);
            index = this.myBits.nextSetBit(index + 1);
        }
    }

    public void forEach(@NotNull IntConsumer consumer) {
        int index = this.myBits.nextSetBit(0);
        while (index >= 0) {
            consumer.accept(index);
            index = this.myBits.nextSetBit(index + 1);
        }
    }

    @Override
    public int size() {
        return this.myBits.length();
    }

    @Override
    public boolean isEmpty() {
        return this.myBits.isEmpty();
    }

    @Override
    public void clear() {
        this.myBits.clear();
    }

    @NotNull
    public static BitIntegerSet valueOf(@NotNull long[] longs) {
        return new BitIntegerSet(BitSet.valueOf(longs));
    }

    @NotNull
    public static BitIntegerSet valueOf(@NotNull LongBuffer buffer) {
        return new BitIntegerSet(BitSet.valueOf(buffer));
    }

    @NotNull
    public static BitIntegerSet valueOf(@NotNull byte[] bytes) {
        return new BitIntegerSet(BitSet.valueOf(bytes));
    }

    @NotNull
    public static BitIntegerSet valueOf(@NotNull ByteBuffer buffer) {
        return new BitIntegerSet(BitSet.valueOf(buffer));
    }

    @NotNull
    public byte[] toByteArray() {
        return this.myBits.toByteArray();
    }

    @NotNull
    public long[] toLongArray() {
        return this.myBits.toLongArray();
    }

    @NotNull
    public BitIntegerSet flip(int i) {
        this.myBits.flip(i);
        return this;
    }

    @NotNull
    public BitIntegerSet flip(int i, int i1) {
        this.myBits.flip(i, i1);
        return this;
    }

    @NotNull
    public BitIntegerSet set(int i) {
        this.myBits.set(i);
        return this;
    }

    @NotNull
    public BitIntegerSet set(int i, boolean b) {
        this.myBits.set(i, b);
        return this;
    }

    @NotNull
    public BitIntegerSet set(int i, int i1) {
        this.myBits.set(i, i1);
        return this;
    }

    @NotNull
    public BitIntegerSet set(int i, int i1, boolean b) {
        this.myBits.set(i, i1, b);
        return this;
    }

    @NotNull
    public BitIntegerSet clear(int i) {
        this.myBits.clear(i);
        return this;
    }

    @NotNull
    public BitIntegerSet clear(int i, int i1) {
        this.myBits.clear(i, i1);
        return this;
    }

    @NotNull
    public BitIntegerSet and(@NotNull BitSet set) {
        this.myBits.and(set);
        return this;
    }

    @NotNull
    public BitIntegerSet or(@NotNull BitSet set) {
        this.myBits.or(set);
        return this;
    }

    @NotNull
    public BitIntegerSet xor(@NotNull BitSet set) {
        this.myBits.xor(set);
        return this;
    }

    @NotNull
    public BitIntegerSet andNot(@NotNull BitSet set) {
        this.myBits.andNot(set);
        return this;
    }

    @NotNull
    public BitIntegerSet and(@NotNull BitIntegerSet set) {
        this.myBits.and(set.myBits);
        return this;
    }

    @NotNull
    public BitIntegerSet or(@NotNull BitIntegerSet set) {
        this.myBits.or(set.myBits);
        return this;
    }

    @NotNull
    public BitIntegerSet xor(@NotNull BitIntegerSet set) {
        this.myBits.xor(set.myBits);
        return this;
    }

    @NotNull
    public BitIntegerSet andNot(@NotNull BitIntegerSet set) {
        this.myBits.andNot(set.myBits);
        return this;
    }

    public boolean get(int i) {
        return this.myBits.get(i);
    }

    @NotNull
    public BitIntegerSet get(int i, int i1) {
        return new BitIntegerSet(this.myBits.get(i, i1));
    }

    public int nextSetBit(int i) {
        return this.myBits.nextSetBit(i);
    }

    public int nextClearBit(int i) {
        return this.myBits.nextClearBit(i);
    }

    public int previousSetBit(int i) {
        return this.myBits.previousSetBit(i);
    }

    public int previousClearBit(int i) {
        return this.myBits.previousClearBit(i);
    }

    public boolean intersects(BitSet set) {
        return this.myBits.intersects(set);
    }

    @NotNull
    public BitSet bitSet() {
        return this.myBits;
    }

    @Override
    @NotNull
    public ReversibleIterator<Integer> iterator() {
        return new BitSetIterator(this.myBits, this.myReversed);
    }

    @NotNull
    public ReversibleIterable<Integer> reversed() {
        return new BitIntegerSet(this, !this.myReversed);
    }

    public boolean isReversed() {
        return this.myReversed;
    }

    @NotNull
    public ReversibleIterator<Integer> reversedIterator() {
        return new BitSetIterator(this.myBits, !this.myReversed);
    }
}

