/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.sequence.managed;

import com.vladsch.flexmark.experimental.util.sequence.managed.BaseSequenceEntry;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSequenceManager {
    @NotNull
    private final WeakHashMap<Object, WeakReference<BasedSequence>> baseMap = new WeakHashMap();
    @NotNull
    private final WeakHashMap<BasedSequence, BaseSequenceEntry> baseSet = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> BasedSequence getBaseSequence(@NotNull T object, @Nullable int[] callTypes, @NotNull Function<T, BasedSequence> factory) {
        int callType = 0;
        WeakHashMap<Object, WeakReference<BasedSequence>> weakHashMap = this.baseMap;
        synchronized (weakHashMap) {
            WeakReference<BasedSequence> baseEntry = this.baseMap.get(object);
            if (baseEntry != null) {
                BasedSequence baseSeq = (BasedSequence)baseEntry.get();
                if (baseSeq != null) {
                    if (callTypes != null) {
                        callTypes[0] = callType;
                    }
                    return baseSeq;
                }
                this.baseMap.remove(object);
            }
            callType = 10;
            int[] equalsCall = new int[]{0};
            for (Map.Entry<BasedSequence, BaseSequenceEntry> entry : this.baseSet.entrySet()) {
                if (entry == null) continue;
                if (entry.getValue().testEquals(entry.getKey(), object, equalsCall)) {
                    callType = Math.max(callType, 10 + equalsCall[0]);
                    if (callTypes != null) {
                        callTypes[0] = callType;
                    }
                    return entry.getKey();
                }
                callType = Math.max(callType, 10 + equalsCall[0]);
            }
            BasedSequence newBaseSeq = factory.apply(object);
            assert (newBaseSeq == newBaseSeq.getBaseSequence());
            assert (newBaseSeq.getBase() == object);
            callType += 10;
            if (callTypes != null) {
                callTypes[0] = callType;
            }
            this.baseMap.put(object, new WeakReference<BasedSequence>(newBaseSeq));
            this.baseSet.put(newBaseSeq, new BaseSequenceEntry());
            return newBaseSeq;
        }
    }
}

