/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.AstCollectingVisitor;
import com.vladsch.flexmark.test.util.ExampleOption;
import com.vladsch.flexmark.test.util.FlexmarkResourceUrlResolver;
import com.vladsch.flexmark.test.util.LoadUnloadDataKeyAggregator;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.ResourceResolverManager;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.test.util.spec.SpecReader;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.misc.Extension;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RichSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;

public class TestUtils {
    public static final char MARKUP_CARET_CHAR = '\u2999';
    public static final char MARKUP_SELECTION_START_CHAR = '\u27e6';
    public static final char MARKUP_SELECTION_END_CHAR = '\u27e7';
    public static final String MARKUP_CARET = Character.toString('\u2999');
    public static final String MARKUP_SELECTION_START = Character.toString('\u27e6');
    public static final String MARKUP_SELECTION_END = Character.toString('\u27e7');
    @NotNull
    public static final CharPredicate CARET_PREDICATE = CharPredicate.anyOf((char[])new char[]{'\u2999'});
    @NotNull
    public static final CharPredicate MARKUP_PREDICATE = CharPredicate.anyOf((char[])new char[]{'\u2999', '\u27e6', '\u27e7'});
    public static final int[] EMPTY_OFFSETS = new int[0];
    public static final char DISABLED_OPTION_PREFIX_CHAR = '-';
    public static final String DISABLED_OPTION_PREFIX;
    public static final String EMBED_TIMED_OPTION_NAME = "EMBED_TIMED";
    public static final String FAIL_OPTION_NAME = "FAIL";
    public static final String FILE_EOL_OPTION_NAME = "FILE_EOL";
    public static final String IGNORE_OPTION_NAME = "IGNORE";
    public static final String NO_FILE_EOL_OPTION_NAME = "NO_FILE_EOL";
    public static final String TIMED_ITERATIONS_OPTION_NAME = "TIMED_ITERATIONS";
    public static final String TIMED_OPTION_NAME = "TIMED";
    public static final DataKey<Boolean> EMBED_TIMED;
    public static final DataKey<Boolean> FAIL;
    public static final DataKey<Boolean> IGNORE;
    public static final DataKey<Boolean> NO_FILE_EOL;
    public static final DataKey<Boolean> TIMED;
    public static final DataKey<Integer> TIMED_ITERATIONS;
    public static final String TIMED_FORMAT_STRING = "Timing %s: parse %.3f ms, render %.3f ms, total %.3f\n";
    public static final DataKey<String> INCLUDED_DOCUMENT;
    public static final DataKey<String> SOURCE_PREFIX;
    public static final DataKey<String> SOURCE_SUFFIX;
    public static final DataKey<String> SOURCE_INDENT;
    public static final DataHolder NO_FILE_EOL_FALSE;
    public static final DataKey<Collection<Class<? extends Extension>>> UNLOAD_EXTENSIONS;
    public static final DataKey<Collection<Extension>> LOAD_EXTENSIONS;
    private static final DataHolder EMPTY_OPTIONS;
    public static final DataKey<BiFunction<String, String, DataHolder>> CUSTOM_OPTION;
    public static final String FILE_PROTOCOL = "file://";
    public static final String BANNER_PADDING = "------------------------------------------------------------------------";
    public static final int BANNER_LENGTH;

    public static DataHolder processOption(@NotNull Map<String, ? extends DataHolder> optionsMap, @NotNull String option) {
        DataHolder dataHolder = null;
        if (!option.startsWith(DISABLED_OPTION_PREFIX)) {
            dataHolder = optionsMap.get(option);
            String customOption = option;
            String params = null;
            if (dataHolder == null) {
                ExampleOption exampleOption = ExampleOption.of(option);
                if (exampleOption.isCustom) {
                    customOption = exampleOption.getOptionName();
                    params = exampleOption.getCustomParams();
                    dataHolder = optionsMap.get(customOption);
                }
            }
            if (dataHolder != null && dataHolder.contains(CUSTOM_OPTION)) {
                BiFunction customHandler = (BiFunction)CUSTOM_OPTION.get(dataHolder);
                dataHolder = (DataHolder)customHandler.apply(customOption, params);
            }
        }
        return dataHolder;
    }

    @NotNull
    public static <T> HashMap<String, T> buildOptionsMap(@NotNull String[] options, @NotNull BiFunction<ExampleOption, Integer, T> factory) {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        int i = 0;
        for (String option : options) {
            hashMap.put(option, factory.apply(ExampleOption.of(option), i));
            ++i;
        }
        return hashMap;
    }

    @NotNull
    public static <T> HashMap<String, T> buildOptionsMap(boolean ensureAllBuiltInPresent, @NotNull Object[][] options, @NotNull BiFunction<ExampleOption, Object[], T> factory) {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        HashSet<String> builtInSet = new HashSet<String>(ExampleOption.getBuiltInOptions().keySet());
        for (Object[] optionData : options) {
            assert (optionData[0] instanceof String);
            String option = (String)optionData[0];
            ExampleOption exampleOption = ExampleOption.of(option);
            hashMap.put(option, factory.apply(exampleOption, optionData));
            if (!exampleOption.isBuiltIn || !exampleOption.isValid || exampleOption.isCustom || exampleOption.isDisabled) continue;
            builtInSet.remove(exampleOption.getOptionName());
        }
        if (ensureAllBuiltInPresent && !builtInSet.isEmpty()) {
            DelimitedBuilder sb = new DelimitedBuilder(",\n    ");
            sb.append("    ");
            for (String option : builtInSet) {
                sb.append(option).mark();
            }
            throw new IllegalStateException("Not all built-in options present. Missing:\n" + sb.toString());
        }
        return hashMap;
    }

    @NotNull
    public static Pair<String, Integer> addSpecSection(@NotNull String headingLine, @NotNull String headingText, String[] sectionHeadings) {
        String section;
        assert (sectionHeadings.length == 7);
        int lastSectionLevel = Math.max(1, Math.min(6, RichSequence.of((CharSequence)headingLine).countLeading(CharPredicate.HASH)));
        sectionHeadings[lastSectionLevel] = headingText;
        int iMax = 7;
        for (int i = lastSectionLevel + 1; i < iMax; ++i) {
            sectionHeadings[i] = null;
        }
        StringBuilder sb = new StringBuilder();
        String sep = "";
        int level = 0;
        for (String heading : sectionHeadings) {
            if (heading != null && level > 1) {
                sb.append(sep).append(heading);
                sep = " - ";
                if (level == lastSectionLevel) break;
            }
            ++level;
        }
        if ((section = sb.toString()).isEmpty()) {
            section = headingText;
        }
        return Pair.of((Object)section, (Object)lastSectionLevel);
    }

    public static DataHolder getOptions(@NotNull SpecExample example, @Nullable String optionSets, @NotNull Function<String, DataHolder> optionsProvider) {
        if (optionSets == null) {
            return null;
        }
        String[] optionNames = optionSets.replace('\u00a0', ' ').split(",");
        MutableDataSet options = null;
        block16: for (String optionName : optionNames) {
            String option = optionName.trim();
            if (option.isEmpty() || option.startsWith("-")) continue;
            switch (option) {
                case "IGNORE": {
                    TestUtils.throwIgnoredOption(example, optionSets, option);
                    continue block16;
                }
                case "FAIL": {
                    options = TestUtils.addOption(options, FAIL, true);
                    continue block16;
                }
                case "NO_FILE_EOL": {
                    options = TestUtils.addOption(options, NO_FILE_EOL, true);
                    continue block16;
                }
                case "FILE_EOL": {
                    options = TestUtils.addOption(options, NO_FILE_EOL, false);
                    continue block16;
                }
                case "TIMED": {
                    options = TestUtils.addOption(options, TIMED, true);
                    continue block16;
                }
                case "EMBED_TIMED": {
                    options = TestUtils.addOption(options, EMBED_TIMED, true);
                    continue block16;
                }
                default: {
                    if (options == null) {
                        options = optionsProvider.apply(option);
                        if (options == null) {
                            TestUtils.throwIllegalStateException(example, option);
                        }
                        options = options.toImmutable();
                    } else {
                        DataHolder dataSet = optionsProvider.apply(option);
                        if (dataSet != null) {
                            options = DataSet.aggregateActions((DataHolder)options.toImmutable(), (DataHolder)dataSet);
                        } else {
                            TestUtils.throwIllegalStateException(example, option);
                        }
                    }
                    if (!options.contains(IGNORE) || !((Boolean)IGNORE.get((DataHolder)options)).booleanValue()) continue block16;
                    TestUtils.throwIgnoredOption(example, optionSets, option);
                }
            }
        }
        return options == null ? null : options.toImmutable();
    }

    public static <T> MutableDataSet addOption(DataHolder options, DataKey<T> key, T value) {
        if (options == null) {
            return new MutableDataSet().set(key, value);
        }
        return new MutableDataSet(options).set(key, value);
    }

    public static void throwIllegalStateException(@NotNull SpecExample example, @NotNull String option) {
        throw new IllegalStateException("Option " + option + " is not implemented in the RenderingTestCase subclass\n" + example.getFileUrlWithLineNumber(-1));
    }

    public static void throwIgnoredOption(@NotNull SpecExample example, @NotNull String optionSets, @NotNull String option) {
        throw new AssumptionViolatedException("Ignored: example(" + example.getSection() + ": " + example.getExampleNumber() + ") options(" + optionSets + ") is using " + option + " option\n" + example.getFileUrlWithLineNumber(-1));
    }

    @NotNull
    public static String ast(@NotNull Node node) {
        return new AstCollectingVisitor().collectAndGetAstText(node);
    }

    public static BasedSequence stripIndent(BasedSequence input, CharSequence sourceIndent) {
        BasedSequence result = input;
        if (sourceIndent.length() != 0) {
            ArrayList<BasedSequence> segments = new ArrayList<BasedSequence>();
            int lastPos = 0;
            int length = input.length();
            while (lastPos < length) {
                int end;
                int pos = input.indexOf(sourceIndent, lastPos);
                int n = end = pos == -1 ? length : pos;
                if (lastPos < end && (pos <= 0 || input.charAt(pos - 1) == '\n')) {
                    segments.add(input.subSequence(lastPos, end));
                }
                lastPos = end + sourceIndent.length();
            }
            result = SegmentedSequence.create((BasedSequence)input, segments);
        }
        return result;
    }

    public static String addSpecExample(boolean includeExampleStart, String source, String html, String ast, String optionsSet) {
        StringBuilder sb = new StringBuilder();
        TestUtils.addSpecExample(includeExampleStart, sb, source, html, ast, optionsSet, false, "", 0);
        return sb.toString();
    }

    public static void addSpecExample(boolean includeExampleStart, StringBuilder sb, String source, String html, String ast, String optionsSet, boolean includeExampleCoords, String section, int number) {
        TestUtils.addSpecExample(includeExampleStart, true, sb, source, html, ast, optionsSet, includeExampleCoords, section, number);
    }

    public static void addSpecExample(boolean includeExampleStart, boolean toVisibleSpecText, StringBuilder sb, String source, String html, String ast, String optionsSet, boolean includeExampleCoords, String section, int number) {
        TestUtils.addSpecExample(false, includeExampleStart, toVisibleSpecText, sb, source, html, ast, optionsSet, includeExampleCoords, section, number);
    }

    public static void addSpecExample(boolean useTestExample, boolean includeExampleStart, boolean toVisibleSpecText, StringBuilder sb, String source, String html, String ast, String optionsSet, boolean includeExampleCoords, String section, int number) {
        TestUtils.addSpecExample(useTestExample ? "````````````````" : "````````````````````````````````", useTestExample ? "\u2026" : ".", includeExampleStart, toVisibleSpecText, sb, source, html, ast, optionsSet, includeExampleCoords, section, number);
    }

    public static void addSpecExample(CharSequence exampleBreak, CharSequence sectionBreak, boolean includeExampleStart, boolean toVisibleSpecText, Appendable out, CharSequence source, CharSequence html, CharSequence ast, CharSequence optionsSet, boolean includeExampleCoords, CharSequence section, int number) {
        TestUtils.addSpecExample(exampleBreak, sectionBreak, sectionBreak, exampleBreak, includeExampleStart, toVisibleSpecText, out, source, html, ast, optionsSet, includeExampleCoords, section, Integer.toString(number), "example", "options");
    }

    public static void addSpecExample(CharSequence exampleBreakOpen, CharSequence htmlBreak, CharSequence astBreak, CharSequence exampleBreakClose, boolean includeExampleStart, boolean toVisibleSpecText, Appendable out, CharSequence source, CharSequence html, CharSequence ast, CharSequence optionsSet, boolean includeExampleCoords, CharSequence section, CharSequence number, CharSequence exampleKeyword, CharSequence optionsKeyword) {
        try {
            if (includeExampleStart) {
                out.append(exampleBreakOpen).append(' ').append(exampleKeyword);
                if (includeExampleCoords) {
                    if (optionsSet != null && !SequenceUtils.isBlank((CharSequence)optionsSet)) {
                        out.append("(").append(section == null || section == BasedSequence.NULL ? "" : SequenceUtils.trim((CharSequence)section)).append(": ").append(number).append(")");
                    } else {
                        out.append(" ").append(section == null || section == BasedSequence.NULL ? "" : SequenceUtils.trim((CharSequence)section)).append(": ").append(number);
                    }
                }
                if (optionsSet != null && !SequenceUtils.isBlank((CharSequence)optionsSet)) {
                    out.append(' ').append(optionsKeyword).append("(").append(optionsSet).append(")");
                }
                out.append("\n");
            }
            if (toVisibleSpecText) {
                if (!SequenceUtils.isEmpty((CharSequence)source)) {
                    out.append(TestUtils.toVisibleSpecText(source));
                    if (!SequenceUtils.endsWithEOL((CharSequence)source)) {
                        out.append("\n");
                    }
                }
                out.append(htmlBreak);
                if (!SequenceUtils.endsWithEOL((CharSequence)htmlBreak)) {
                    out.append("\n");
                }
                if (html != null && !SequenceUtils.isEmpty((CharSequence)html)) {
                    out.append(TestUtils.toVisibleSpecText(html));
                    if (!SequenceUtils.endsWithEOL((CharSequence)html)) {
                        out.append("\n");
                    }
                }
            } else {
                if (!SequenceUtils.isEmpty((CharSequence)source)) {
                    out.append(source);
                    if (!SequenceUtils.endsWithEOL((CharSequence)source)) {
                        out.append("\n");
                    }
                }
                out.append(htmlBreak);
                if (!SequenceUtils.endsWithEOL((CharSequence)htmlBreak)) {
                    out.append("\n");
                }
                if (html != null && !SequenceUtils.isEmpty((CharSequence)html)) {
                    out.append(html);
                    if (!SequenceUtils.endsWithEOL((CharSequence)html)) {
                        out.append("\n");
                    }
                }
            }
            if (ast != null && ast != BasedSequence.NULL) {
                out.append(astBreak);
                if (!SequenceUtils.endsWithEOL((CharSequence)htmlBreak)) {
                    out.append("\n");
                }
                if (!SequenceUtils.isEmpty((CharSequence)ast)) {
                    out.append(ast);
                    if (!SequenceUtils.endsWithEOL((CharSequence)ast)) {
                        out.append("\n");
                    }
                }
            }
            out.append(exampleBreakClose);
            if (!SequenceUtils.endsWithEOL((CharSequence)exampleBreakClose)) {
                out.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static String showTabs(String s) {
        return TestUtils.toVisibleSpecText(s);
    }

    public static String toVisibleSpecText(String s) {
        if (s == null) {
            return "";
        }
        return TestUtils.toVisibleSpecText((CharSequence)s).toString();
    }

    public static CharSequence toVisibleSpecText(CharSequence s) {
        if (s == null) {
            return "";
        }
        BasedSequence sequence = BasedSequence.of((CharSequence)s);
        return ((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)sequence.replace((CharSequence)"\u2192", (CharSequence)"&#2192;")).replace((CharSequence)"\t", (CharSequence)"\u2192")).replace((CharSequence)"\u23ae", (CharSequence)"&#23ae;")).replace((CharSequence)"\u001f", (CharSequence)"\u23ae")).replace((CharSequence)"\u23ce", (CharSequence)"&#23ce;")).replace((CharSequence)"\r", (CharSequence)"\u23ce")).replace((CharSequence)"\u27a5", (CharSequence)"&#27a5;")).replace((CharSequence)SequenceUtils.LINE_SEP, (CharSequence)"\u27a5");
    }

    @Deprecated
    public static String unShowTabs(String s) {
        return TestUtils.fromVisibleSpecText(s);
    }

    public static String fromVisibleSpecText(String s) {
        if (s == null) {
            return "";
        }
        return TestUtils.fromVisibleSpecText((CharSequence)s).toString();
    }

    public static CharSequence fromVisibleSpecText(CharSequence s) {
        if (s == null) {
            return "";
        }
        BasedSequence sequence = BasedSequence.of((CharSequence)s);
        return ((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)((BasedSequence)sequence.replace((CharSequence)"\u27a5", (CharSequence)SequenceUtils.LINE_SEP)).replace((CharSequence)"&#27a5;", (CharSequence)"\u27a5")).replace((CharSequence)"\u23ce", (CharSequence)"\r")).replace((CharSequence)"&#23ce;", (CharSequence)"\u23ce")).replace((CharSequence)"\u23ae", (CharSequence)"\u001f")).replace((CharSequence)"&#23ae;", (CharSequence)"\u23ae")).replace((CharSequence)"\u2192", (CharSequence)"\t")).replace((CharSequence)"&#2192;", (CharSequence)"\u2192");
    }

    public static String trimTrailingEOL(String parseSource) {
        int pos;
        if (!(parseSource.isEmpty() || parseSource.charAt(parseSource.length() - 1) != '\n' || (pos = parseSource.lastIndexOf(10, parseSource.length() - 2)) != -1 && parseSource.substring(pos + 1).trim().isEmpty())) {
            parseSource = parseSource.substring(0, parseSource.length() - 1);
        }
        return parseSource;
    }

    public static String getFormattedTimingInfo(int iterations, long start, long parse, long render) {
        return TestUtils.getFormattedTimingInfo(null, 0, iterations, start, parse, render);
    }

    public static String getFormattedTimingInfo(String section, int exampleNumber, int iterations, long start, long parse, long render) {
        return String.format(TIMED_FORMAT_STRING, TestUtils.getFormattedSection(section, exampleNumber), (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations);
    }

    @NotNull
    public static String getFormattedSection(String section, int exampleNumber) {
        return section == null ? "" : section.trim() + ": " + exampleNumber;
    }

    @NotNull
    public static String getResolvedSpecResourcePath(@NotNull String testClassName, @NotNull String resourcePath) {
        File specInfo = new File(resourcePath);
        File classInfo = new File("/" + testClassName.replace('.', '/'));
        return !specInfo.isAbsolute() ? new File(classInfo.getParent(), resourcePath).getAbsolutePath() : resourcePath;
    }

    @NotNull
    public static String getAbsoluteSpecResourcePath(@NotNull String testClassPath, @NotNull String resourceRootPath, @NotNull String resourcePath) {
        File resourceFile = resourcePath.startsWith("/") ? new File(resourceRootPath, resourcePath.substring(1)) : new File(new File(testClassPath).getParent(), resourcePath);
        return resourceFile.getAbsolutePath();
    }

    @NotNull
    public static String getSpecResourceFileUrl(@NotNull Class<?> resourceClass, @NotNull String resourcePath) {
        if (resourcePath.isEmpty()) {
            throw new IllegalStateException("Empty resource paths not supported");
        }
        String resolvedResourcePath = TestUtils.getResolvedSpecResourcePath(resourceClass.getName(), resourcePath);
        URL url = resourceClass.getResource(resolvedResourcePath);
        assert (url != null) : "Resource path: '" + resolvedResourcePath + "' not found.";
        return TestUtils.adjustedFileUrl(url);
    }

    public static ArrayList<Object[]> getTestData(@NotNull ResourceLocation location) {
        SpecReader specReader = SpecReader.createAndReadExamples(location, true);
        List<SpecExample> examples = specReader.getExamples();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{SpecExample.NULL.withResourceLocation(location)});
        for (SpecExample example : examples) {
            data.add(new Object[]{example});
        }
        return data;
    }

    @NotNull
    public static String getUrlWithLineNumber(@NotNull String fileUrl, int lineNumber) {
        return lineNumber > 0 ? fileUrl + ":" + (lineNumber + 1) : fileUrl;
    }

    public static String adjustedFileUrl(@NotNull URL url) {
        return ResourceResolverManager.adjustedFileUrl(url);
    }

    @Nullable
    public static DataHolder combineDefaultOptions(@Nullable DataHolder[] defaultOptions) {
        DataHolder combinedOptions = null;
        if (defaultOptions != null) {
            for (DataHolder options : defaultOptions) {
                combinedOptions = DataSet.aggregate(combinedOptions, (DataHolder)options);
            }
        }
        return combinedOptions == null ? null : combinedOptions.toImmutable();
    }

    @Nullable
    public static Map<String, ? extends DataHolder> optionsMaps(@Nullable Map<String, ? extends DataHolder> other, @Nullable Map<String, ? extends DataHolder> overrides) {
        if (other != null && overrides != null) {
            HashMap<String, ? extends DataHolder> map = new HashMap<String, DataHolder>(other);
            map.putAll(overrides);
            return map;
        }
        if (other != null) {
            return other;
        }
        return overrides;
    }

    @Nullable
    public static DataHolder[] dataHolders(@Nullable DataHolder other, @Nullable DataHolder[] overrides) {
        if (other == null) {
            return overrides;
        }
        if (overrides == null || overrides.length == 0) {
            return new DataHolder[]{other};
        }
        DataHolder[] holders = new DataHolder[overrides.length + 1];
        System.arraycopy(overrides, 0, holders, 1, overrides.length);
        holders[0] = other;
        return holders;
    }

    @NotNull
    public static String getTestResourceRootDirectoryForModule(@NotNull Class<?> resourceClass, @NotNull String moduleRootPackage) {
        String fileUrl = TestUtils.getSpecResourceFileUrl(resourceClass, Utils.wrapWith((String)moduleRootPackage, (String)"/", (String)".txt"));
        return Utils.removePrefix((String)Utils.removeSuffix((String)fileUrl, (String)Utils.suffixWith((String)moduleRootPackage, (String)".txt")), (String)FILE_PROTOCOL);
    }

    @NotNull
    public static String getRootDirectoryForModule(@NotNull Class<?> resourceClass, @NotNull String moduleDirectoryName) {
        String fileUrl = SpecExample.ofCaller(0, resourceClass, "", "", "").getFileUrl();
        int pos = fileUrl.indexOf(Utils.wrapWith((String)moduleDirectoryName, (char)'/'));
        if (pos != -1) {
            fileUrl = fileUrl.substring(0, pos);
        }
        fileUrl = fileUrl.substring(FILE_PROTOCOL.length());
        return fileUrl;
    }

    public static DataHolder customStringOption(@NotNull String option, @Nullable String params, @NotNull Function<String, DataHolder> resolver) {
        if (params != null) {
            String text = params.replace("\\\\", "\\").replace("\\]", "]").replace("\\t", "\t").replace("\\n", "\n").replace("\\r", "\r").replace("\\b", "\b");
            return resolver.apply(text);
        }
        return resolver.apply(null);
    }

    public static DataHolder customIntOption(@NotNull String option, @Nullable String params, @NotNull Function<Integer, DataHolder> resolver) {
        int value = -1;
        if (params != null) {
            if (!params.matches("\\d*")) {
                throw new IllegalStateException("'" + option + "' option requires a numeric or empty (for default) argument");
            }
            value = Integer.parseInt(params);
        }
        return resolver.apply(value);
    }

    public static SequenceBuilder insertCaretMarkup(BasedSequence sequence, int[] offsets) {
        SequenceBuilder builder = sequence.getBuilder();
        Arrays.sort(offsets);
        int length = sequence.length();
        int lastOffset = 0;
        for (int offset : offsets) {
            int useOffset = Math.min(length, offset);
            if (useOffset > lastOffset) {
                sequence.subSequence(lastOffset, useOffset).addSegments((IBasedSegmentBuilder)builder.getSegmentBuilder());
            }
            if (useOffset == offset) {
                builder.append((CharSequence)"\u2999");
            }
            lastOffset = useOffset;
        }
        int offset = sequence.length();
        if (offset > lastOffset) {
            sequence.subSequence(lastOffset, offset).addSegments((IBasedSegmentBuilder)builder.getSegmentBuilder());
        }
        return builder;
    }

    public static Pair<BasedSequence, int[]> extractMarkup(BasedSequence input) {
        int markup = input.countOfAny(MARKUP_PREDICATE);
        if (markup > 0) {
            int pos;
            int carets = input.countOfAny(CARET_PREDICATE);
            int[] offsets = new int[carets];
            int selections = markup - carets;
            assert (selections % 2 == 0);
            int indents = selections / 2;
            int[] starts = new int[indents];
            int[] ends = new int[indents];
            int lastPos = input.length();
            int c = carets;
            int m = markup;
            int i = indents;
            Object toWrap = input.toString();
            int endIndent = -1;
            while (lastPos >= 0 && (pos = input.lastIndexOfAny(MARKUP_PREDICATE, lastPos)) != -1) {
                char ch = input.charAt(pos);
                --m;
                switch (ch) {
                    case '\u2999': {
                        offsets[--c] = pos - m;
                        break;
                    }
                    case '\u27e6': {
                        assert (endIndent != -1);
                        starts[--i] = pos - m;
                        ends[i] = endIndent;
                        endIndent = -1;
                        break;
                    }
                    case '\u27e7': {
                        assert (endIndent == -1);
                        endIndent = pos - m;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected predicate match");
                    }
                }
                toWrap = ((String)toWrap).substring(0, pos) + ((String)toWrap).substring(pos + 1);
                lastPos = pos - 1;
            }
            assert (endIndent == -1);
            assert (c == 0) : "Unused caret pos: " + c;
            assert (i == 0) : "Unused indent pos: " + i;
            BasedSequence sequence = BasedSequence.of((CharSequence)toWrap);
            SequenceBuilder builder = sequence.getBuilder();
            int jMax = starts.length;
            int lastOffset = 0;
            for (int j = 0; j < jMax; ++j) {
                int start = starts[j];
                int end = ends[j];
                if (start > lastOffset) {
                    sequence.subSequence(lastOffset, start).addSegments((IBasedSegmentBuilder)builder.getSegmentBuilder());
                }
                lastOffset = end;
            }
            int offset = sequence.length();
            if (offset > lastOffset) {
                sequence.subSequence(lastOffset, offset).addSegments((IBasedSegmentBuilder)builder.getSegmentBuilder());
            }
            return Pair.of((Object)builder.toSequence(), (Object)offsets);
        }
        return Pair.of((Object)input, (Object)EMPTY_OFFSETS);
    }

    @NotNull
    public static String bannerText(@NotNull String message) {
        int leftPadding = 4;
        int rightPadding = BANNER_LENGTH - message.length() - 2 - leftPadding;
        return BANNER_PADDING.substring(0, leftPadding) + " " + message + " " + BANNER_PADDING.substring(0, rightPadding) + "\n";
    }

    public static void appendBanner(@NotNull StringBuilder out, @NotNull String banner) {
        TestUtils.appendBanner(out, banner, true);
    }

    public static void appendBanner(@NotNull StringBuilder out, @NotNull String banner, boolean addBlankLine) {
        if (out.length() > 0 && addBlankLine) {
            out.append("\n");
        }
        out.append(banner);
    }

    public static void appendBannerIfNeeded(@NotNull StringBuilder out, @NotNull String banner) {
        if (out.length() > 0) {
            out.append("\n");
            out.append(banner);
        }
    }

    static {
        FlexmarkResourceUrlResolver.registerUrlResolvers();
        DISABLED_OPTION_PREFIX = String.valueOf('-');
        EMBED_TIMED = new DataKey(TIMED_OPTION_NAME, (Object)false);
        FAIL = new DataKey(FAIL_OPTION_NAME, (Object)false);
        IGNORE = new DataKey(IGNORE_OPTION_NAME, (Object)false);
        NO_FILE_EOL = new DataKey(NO_FILE_EOL_OPTION_NAME, (Object)true);
        TIMED = new DataKey(TIMED_OPTION_NAME, (Object)false);
        TIMED_ITERATIONS = new DataKey(TIMED_ITERATIONS_OPTION_NAME, (Object)100);
        INCLUDED_DOCUMENT = new DataKey("INCLUDED_DOCUMENT", (Object)"");
        SOURCE_PREFIX = new DataKey("SOURCE_PREFIX", (Object)"");
        SOURCE_SUFFIX = new DataKey("SOURCE_SUFFIX", (Object)"");
        SOURCE_INDENT = new DataKey("SOURCE_INDENT", (Object)"");
        NO_FILE_EOL_FALSE = new MutableDataSet().set(NO_FILE_EOL, (Object)false).toImmutable();
        UNLOAD_EXTENSIONS = LoadUnloadDataKeyAggregator.UNLOAD_EXTENSIONS;
        LOAD_EXTENSIONS = LoadUnloadDataKeyAggregator.LOAD_EXTENSIONS;
        EMPTY_OPTIONS = new DataSet();
        CUSTOM_OPTION = new DataKey("CUSTOM_OPTION", (option, params) -> EMPTY_OPTIONS);
        BANNER_LENGTH = BANNER_PADDING.length();
    }
}

