/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExampleOption {
    private static final HashSet<String> BUILT_IN_OPTIONS_SET = new HashSet();
    private static final HashMap<String, ExampleOption> BUILT_IN_OPTIONS_MAP;
    @NotNull
    public final BasedSequence optionText;
    @NotNull
    public final BasedSequence optionName;
    @NotNull
    public final BasedSequence customParams;
    public final boolean isBuiltIn;
    public final boolean isDisabled;
    public final boolean isCustom;
    public final boolean isValid;

    private static ExampleOption build(@NotNull CharSequence option) {
        BasedSequence customParams;
        BasedSequence optionName;
        boolean isDisabled = false;
        BasedSequence optionText = BasedSequence.of((CharSequence)option);
        int pos = optionText.indexOf((CharSequence)"[");
        if (pos > 0 && pos < optionText.length() && optionText.endsWith((CharSequence)"]")) {
            optionName = optionText.subSequence(0, pos);
            customParams = optionText.subSequence(pos + 1, optionText.length() - 1);
        } else {
            optionName = optionText;
            customParams = BasedSequence.NULL;
        }
        if (optionName.startsWith((CharSequence)TestUtils.DISABLED_OPTION_PREFIX)) {
            optionName = (BasedSequence)optionName.subSequence(1);
            isDisabled = true;
        }
        return new ExampleOption(optionText, optionName, customParams, BUILT_IN_OPTIONS_SET.contains(optionName.toString()) && customParams.isNull(), isDisabled, customParams.isNotNull(), !optionName.isBlank());
    }

    public static ExampleOption of(@NotNull CharSequence optionText) {
        return ExampleOption.build(optionText);
    }

    @NotNull
    public static HashMap<String, ExampleOption> getBuiltInOptions() {
        return new HashMap<String, ExampleOption>(BUILT_IN_OPTIONS_MAP);
    }

    private ExampleOption(@NotNull BasedSequence optionText, @NotNull BasedSequence optionName, @NotNull BasedSequence customParams, boolean isBuiltIn, boolean isDisabled, boolean isCustom, boolean isValid) {
        this.optionText = optionText;
        this.optionName = optionName;
        this.customParams = customParams;
        this.isBuiltIn = isBuiltIn;
        this.isDisabled = isDisabled;
        this.isCustom = isCustom;
        this.isValid = isValid;
    }

    @NotNull
    public String getOptionText() {
        return this.optionText.toString();
    }

    @NotNull
    public String getOptionName() {
        return this.optionName.toString();
    }

    @Nullable
    public String getCustomParams() {
        return this.customParams.isNull() ? null : this.customParams.toString();
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isIgnore() {
        return this.isBuiltIn && this.optionName.equals("IGNORE");
    }

    public boolean isFail() {
        return this.isBuiltIn && this.optionName.equals("FAIL");
    }

    public boolean isTimed() {
        return this.isBuiltIn && this.optionName.equals("TIMED");
    }

    public boolean isTimedIterations() {
        return this.isBuiltIn && this.optionName.equals("TIMED_ITERATIONS");
    }

    public boolean isEmbedTimed() {
        return this.isBuiltIn && this.optionName.equals("EMBED_TIMED");
    }

    public boolean isFileEol() {
        return this.isBuiltIn && this.optionName.equals("FILE_EOL");
    }

    public boolean isNoFileEol() {
        return this.isBuiltIn && this.optionName.equals("NO_FILE_EOL");
    }

    static {
        BUILT_IN_OPTIONS_SET.add("EMBED_TIMED");
        BUILT_IN_OPTIONS_SET.add("FAIL");
        BUILT_IN_OPTIONS_SET.add("FILE_EOL");
        BUILT_IN_OPTIONS_SET.add("IGNORE");
        BUILT_IN_OPTIONS_SET.add("NO_FILE_EOL");
        BUILT_IN_OPTIONS_SET.add("TIMED_ITERATIONS");
        BUILT_IN_OPTIONS_SET.add("TIMED");
        BUILT_IN_OPTIONS_MAP = new HashMap();
        BUILT_IN_OPTIONS_MAP.put("EMBED_TIMED", ExampleOption.build("EMBED_TIMED"));
        BUILT_IN_OPTIONS_MAP.put("FAIL", ExampleOption.build("FAIL"));
        BUILT_IN_OPTIONS_MAP.put("FILE_EOL", ExampleOption.build("FILE_EOL"));
        BUILT_IN_OPTIONS_MAP.put("IGNORE", ExampleOption.build("IGNORE"));
        BUILT_IN_OPTIONS_MAP.put("NO_FILE_EOL", ExampleOption.build("NO_FILE_EOL"));
        BUILT_IN_OPTIONS_MAP.put("TIMED", ExampleOption.build("TIMED"));
    }
}

