/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettableExtractedInstance<T, S> {
    @NotNull
    private final DataKey<Consumer<S>> myConsumerKey;
    @NotNull
    private final Function<T, S> myDataExtractor;

    public SettableExtractedInstance(@NotNull DataKey<Consumer<S>> consumerKey, @NotNull Function<T, S> dataExtractor) {
        this.myConsumerKey = consumerKey;
        this.myDataExtractor = dataExtractor;
    }

    public void aggregate(@NotNull T instance, @NotNull DataHolder dataHolder) {
        if (dataHolder.contains(this.myConsumerKey)) {
            ((Consumer)this.myConsumerKey.get(dataHolder)).accept(this.myDataExtractor.apply(instance));
        }
    }

    @NotNull
    public DataHolder aggregateActions(@NotNull DataHolder dataHolder, @Nullable DataHolder other, @Nullable DataHolder overrides) {
        if (other != null && other.contains(this.myConsumerKey) && overrides != null && overrides.contains(this.myConsumerKey)) {
            Consumer otherSetter = (Consumer)this.myConsumerKey.get(other);
            Consumer overridesSetter = (Consumer)this.myConsumerKey.get(overrides);
            dataHolder = dataHolder.toMutable().set(this.myConsumerKey, otherSetter.andThen(overridesSetter));
        }
        return dataHolder;
    }
}

