/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.test.FullSpecTestCase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ComboSpecTestCase
extends FullSpecTestCase {
    public static final String SPEC_RESOURCE = "/ast_spec.md";
    protected final SpecExample example;

    @Override
    public abstract String getSpecResourceName();

    public ComboSpecTestCase(SpecExample example) {
        this.example = example;
    }

    @Override
    public SpecExample example() {
        return this.example;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        List<SpecExample> examples = SpecReader.readExamples();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{SpecExample.getNull()});
        for (SpecExample example : examples) {
            data.add(new Object[]{example});
        }
        return data;
    }

    @Override
    public boolean outputActualFullSpec() {
        return false;
    }

    @Override
    public boolean includeExampleCoords() {
        return true;
    }

    protected String readResource(String resourcePath) {
        InputStream stream = ComboSpecTestCase.class.getResourceAsStream(resourcePath);
        return this.readStream(stream);
    }

    protected String readStream(InputStream stream) {
        try {
            String line;
            StringBuilder out = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                out.append(line).append('\n');
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testHtmlRendering() {
        if (!this.example.isSpecExample()) {
            return;
        }
        if (this.example.getAst() != null) {
            this.assertRenderingAst(this.example.getFileUrl(), this.example.getSource(), this.example.getHtml(), this.example.getAst(), this.example.getOptionsSet());
        } else {
            this.assertRendering(this.example.getFileUrl(), this.example.getSource(), this.example.getHtml(), this.example.getOptionsSet());
        }
    }

    protected boolean fullTestSpecStarting() {
        return true;
    }

    protected void fullTestSpecComplete() {
    }

    @Override
    @Test
    public void testFullSpec() throws Exception {
        if (!this.example.isFullSpecExample()) {
            return;
        }
        if (this.fullTestSpecStarting()) {
            String specResourcePath = this.getSpecResourceName();
            String fullSpec = SpecReader.readSpec(specResourcePath);
            SpecReader reader = this.example == null || this.example.getFileUrl() == null ? SpecReader.createAndReadExamples(specResourcePath, this) : SpecReader.createAndReadExamples(specResourcePath, this, this.example.getFileUrl().toString());
            String actual = this.dumpSpecReader.getFullSpec();
            if (this.outputActualFullSpec()) {
                System.out.println(actual);
            }
            this.fullTestSpecComplete();
            if (reader.getFileUrl() != null) {
                Assert.assertEquals((String)reader.getFileUrl().toString(), (Object)fullSpec, (Object)actual);
            } else {
                Assert.assertEquals((Object)fullSpec, (Object)actual);
            }
        }
    }
}

