/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;

public abstract class IRenderBase
implements IRender {
    public static final IRender NullRenderer = new IRenderBase(){

        public void render(Node node, Appendable output) {
        }

        public IRender withOptions(DataHolder options) {
            return this;
        }
    };
    public static final IRender TextRenderer = new IRenderBase(){

        public void render(Node node, Appendable output) {
            try {
                output.append((CharSequence)node.getChars());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public IRender withOptions(DataHolder options) {
            return this;
        }
    };
    private final MutableDataSet myOptions;

    public IRenderBase() {
        this(null);
    }

    public IRenderBase(DataHolder options) {
        this.myOptions = options != null ? new MutableDataSet(options) : new MutableDataSet();
    }

    public String render(Node node) {
        StringBuilder out = new StringBuilder();
        this.render(node, out);
        return out.toString();
    }

    public MutableDataSet getOptions() {
        return this.myOptions;
    }
}

