/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.UrlString;
import com.vladsch.flexmark.test.ActualExampleModifier;
import com.vladsch.flexmark.test.AstCollectingVisitor;
import com.vladsch.flexmark.test.DumpSpecReader;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.RichCharSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class RenderingTestCase
implements ActualExampleModifier {
    public static final String IGNORE_OPTION_NAME = "IGNORE";
    public static final String FAIL_OPTION_NAME = "FAIL";
    public static final String NO_FILE_EOL_OPTION_NAME = "NO_FILE_EOL";
    public static final String FILE_EOL_OPTION_NAME = "FILE_EOL";
    public static final String TIMED_ITERATIONS_NAME = "TIMED_ITERATIONS_NAME";
    public static final String TIMED_OPTION_NAME = "TIMED";
    public static final String EMBED_TIMED_OPTION_NAME = "EMBED_TIMED";
    public static final String TIMED_FORMAT_STRING = "Timing %s: parse %.3f ms, render %.3f ms, total %.3f\n";
    public static final DataKey<Boolean> FAIL = new DataKey("FAIL", (Object)false);
    public static final DataKey<Boolean> IGNORE = new DataKey("IGNORE", (Object)false);
    public static final DataKey<Boolean> NO_FILE_EOL = new DataKey("NO_FILE_EOL", (Object)true);
    public static final DataKey<Boolean> TIMED = new DataKey("TIMED", (Object)false);
    public static final DataKey<Integer> TIMED_ITERATIONS = new DataKey("TIMED_ITERATIONS_NAME", (Object)100);
    public static final DataKey<Boolean> EMBED_TIMED = new DataKey("TIMED", (Object)false);
    public static final DataKey<String> INCLUDED_DOCUMENT = new DataKey("INCLUDED_DOCUMENT", (Object)"");
    public static final DataKey<String> SOURCE_PREFIX = new DataKey("SOURCE_PREFIX", (Object)"");
    public static final DataKey<String> SOURCE_SUFFIX = new DataKey("SOURCE_SUFFIX", (Object)"");
    public static final DataKey<String> SOURCE_INDENT = new DataKey("SOURCE_INDENT", (Object)"");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public abstract IParse parser();

    public abstract IRender renderer();

    public abstract SpecExample example();

    public DataHolder options(String optionSet) {
        assert (optionSet == null);
        return null;
    }

    public DataHolder getOptions(SpecExample example, String optionSets) {
        if (optionSets == null) {
            return null;
        }
        String[] optionNames = optionSets.replace('\u00a0', ' ').split(",");
        MutableDataSet options = null;
        boolean isFirst = true;
        for (String optionName : optionNames) {
            String option = optionName.trim();
            if (option.isEmpty() || option.startsWith("-")) continue;
            if (option.equals(IGNORE_OPTION_NAME)) {
                this.throwIgnoredOption(example, optionSets, option);
                continue;
            }
            if (option.equals(FAIL_OPTION_NAME)) {
                options = this.addOption((DataHolder)options, (DataKey)FAIL, true);
                continue;
            }
            if (option.equals(NO_FILE_EOL_OPTION_NAME)) {
                options = this.addOption((DataHolder)options, NO_FILE_EOL, true);
                continue;
            }
            if (option.equals(FILE_EOL_OPTION_NAME)) {
                options = this.addOption((DataHolder)options, NO_FILE_EOL, false);
                continue;
            }
            if (option.equals(TIMED_OPTION_NAME)) {
                options = this.addOption((DataHolder)options, TIMED, true);
                continue;
            }
            if (option.equals(EMBED_TIMED_OPTION_NAME)) {
                options = this.addOption((DataHolder)options, EMBED_TIMED, true);
                continue;
            }
            if (options == null) {
                options = this.options(option);
                if (options == null) {
                    throw new IllegalStateException("Option " + option + " is not implemented in the RenderingTestCase subclass");
                }
            } else {
                DataHolder dataSet = this.options(option);
                if (dataSet != null) {
                    if (isFirst) {
                        options = new MutableDataSet((DataHolder)options);
                        isFirst = false;
                    }
                    options.setAll(dataSet);
                } else {
                    throw new IllegalStateException("Option " + option + " is not implemented in the RenderingTestCase subclass");
                }
            }
            if (!((Boolean)IGNORE.getFrom((DataHolder)options)).booleanValue()) continue;
            this.throwIgnoredOption(example, optionSets, option);
        }
        return options;
    }

    private <T> MutableDataSet addOption(DataHolder options, DataKey<T> key, T value) {
        if (options == null) {
            return new MutableDataSet().set(key, value);
        }
        return new MutableDataSet(options).set(key, value);
    }

    private void throwIgnoredOption(SpecExample example, String optionSets, String option) {
        if (example == null) {
            throw new AssumptionViolatedException("Ignored: SpecExample test case options(" + optionSets + ") is using " + option + " option");
        }
        throw new AssumptionViolatedException("Ignored: example(" + example.getSection() + ": " + example.getExampleNumber() + ") options(" + optionSets + ") is using " + option + " option");
    }

    public String ast(Node node) {
        return new AstCollectingVisitor().collectAndGetAstText(node);
    }

    @Override
    public String actualSource(String source, String optionSet) {
        return source;
    }

    protected void testCase(Node node, DataHolder options) {
    }

    @Override
    public String actualHtml(String html, String optionSet) {
        return html;
    }

    @Override
    public String actualAst(String ast, String optionSet) {
        return ast;
    }

    protected void specExample(String expected, String actual, String optionSet) {
    }

    protected IParse adjustParserForInclusion(IParse parserWithOptions, Document includedDocument) {
        return parserWithOptions;
    }

    protected void assertRendering(UrlString fileUrl, String source, String expectedHtml) {
        this.assertRendering(fileUrl, source, expectedHtml, null);
    }

    protected void assertRendering(String source, String expectedHtml) {
        this.assertRendering(null, source, expectedHtml, null);
    }

    public boolean useActualHtml() {
        return true;
    }

    public static BasedSequence stripIndent(BasedSequence input, CharSequence sourceIndent) {
        BasedSequence result = input;
        if (sourceIndent.length() != 0) {
            ArrayList<RichCharSequence> segments = new ArrayList<RichCharSequence>();
            int lastPos = 0;
            int length = input.length();
            while (lastPos < length) {
                int end;
                int pos = input.indexOf(sourceIndent, lastPos);
                int n = end = pos == -1 ? length : pos;
                if (lastPos < end && (pos <= 0 || input.charAt(pos - 1) == '\n')) {
                    segments.add(input.subSequence(lastPos, end));
                }
                lastPos = end + sourceIndent.length();
            }
            result = SegmentedSequence.of(segments);
        }
        return result;
    }

    protected void assertRendering(UrlString fileUrl, String source, String expectedHtml, String optionsSet) {
        String actual;
        String expected;
        boolean timed;
        BasedSequence input;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = source;
        IParse parserWithOptions = this.parser().withOptions(options);
        IRender rendererWithOptions = this.renderer().withOptions(options);
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        String sourcePrefix = (String)SOURCE_PREFIX.getFrom(parserWithOptions.getOptions());
        String sourceSuffix = (String)SOURCE_SUFFIX.getFrom(parserWithOptions.getOptions());
        String sourceIndent = (String)SOURCE_INDENT.getFrom(parserWithOptions.getOptions());
        if (!sourcePrefix.isEmpty() || !sourceSuffix.isEmpty()) {
            String combinedSource = sourcePrefix + Utils.suffixWith((String)parseSource, (String)"\n") + sourceSuffix;
            input = (BasedSequence)BasedSequenceImpl.of((CharSequence)combinedSource).subSequence(sourcePrefix.length(), combinedSource.length() - sourceSuffix.length());
        } else {
            input = BasedSequenceImpl.of((CharSequence)parseSource);
        }
        input = RenderingTestCase.stripIndent(input, sourceIndent);
        Node includedDocument = null;
        String includedText = (String)INCLUDED_DOCUMENT.getFrom(parserWithOptions.getOptions());
        if (includedText != null && !includedText.isEmpty() && (includedDocument = parserWithOptions.parse(includedText)) instanceof Document) {
            parserWithOptions = this.adjustParserForInclusion(parserWithOptions, (Document)includedDocument);
        }
        int iterations = (timed = ((Boolean)TIMED.getFrom(parserWithOptions.getOptions())).booleanValue()) ? (Integer)TIMED_ITERATIONS.getFrom(parserWithOptions.getOptions()) : 1;
        String inputText = input.toString();
        String useSource = this.actualSource(inputText, optionsSet);
        BasedSequence inputSource = inputText == useSource ? input : BasedSequenceImpl.of((CharSequence)useSource);
        long start = System.nanoTime();
        Node node = parserWithOptions.parse(inputSource);
        for (int i = 1; i < iterations; ++i) {
            parserWithOptions.parse(input);
        }
        long parse = System.nanoTime();
        if (node instanceof Document && includedDocument instanceof Document) {
            parserWithOptions.transferReferences((Document)node, (Document)includedDocument);
        }
        String html = rendererWithOptions.render(node);
        for (int i = 1; i < iterations; ++i) {
            rendererWithOptions.render(node);
        }
        long render = System.nanoTime();
        boolean embedTimed = (Boolean)EMBED_TIMED.getFrom((DataHolder)node.getDocument());
        if (timed || embedTimed) {
            System.out.print(String.format(TIMED_FORMAT_STRING, "", (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
        }
        this.testCase(node, options);
        html = this.actualHtml(html, optionsSet);
        boolean useActualHtml = this.useActualHtml();
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            if (embedTimed) {
                outExpected.append(String.format(TIMED_FORMAT_STRING, "", (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
            }
            DumpSpecReader.addSpecExample(outExpected, source, expectedHtml, "", optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, useActualHtml ? html : expectedHtml, "", optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            if (embedTimed) {
                StringBuilder outExpected = new StringBuilder();
                outExpected.append(String.format(TIMED_FORMAT_STRING, "", (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
                outExpected.append(DumpSpecReader.addSpecExample(source, expectedHtml, "", optionsSet));
                expected = outExpected.toString();
            } else {
                expected = DumpSpecReader.addSpecExample(source, expectedHtml, "", optionsSet);
            }
            actual = DumpSpecReader.addSpecExample(source, useActualHtml ? html : expectedHtml, "", optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        if (fileUrl != null) {
            Assert.assertEquals((String)fileUrl.toString(), (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected void assertRenderingAst(UrlString fileUrl, String source, String expectedHtml, String expectedAst, String optionsSet) {
        String actual;
        String expected;
        boolean timed;
        BasedSequence input;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = source;
        IParse parserWithOptions = this.parser().withOptions(options);
        IRender rendererWithOptions = this.renderer().withOptions(options);
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        String sourcePrefix = (String)SOURCE_PREFIX.getFrom(parserWithOptions.getOptions());
        String sourceSuffix = (String)SOURCE_SUFFIX.getFrom(parserWithOptions.getOptions());
        String sourceIndent = (String)SOURCE_INDENT.getFrom(parserWithOptions.getOptions());
        if (!sourcePrefix.isEmpty() || !sourceSuffix.isEmpty()) {
            String combinedSource = sourcePrefix + Utils.suffixWith((String)parseSource, (String)"\n") + sourceSuffix;
            input = (BasedSequence)BasedSequenceImpl.of((CharSequence)combinedSource).subSequence(sourcePrefix.length(), combinedSource.length() - sourceSuffix.length());
        } else {
            input = BasedSequenceImpl.of((CharSequence)parseSource);
        }
        input = RenderingTestCase.stripIndent(input, sourceIndent);
        Node includedDocument = null;
        String includedText = (String)INCLUDED_DOCUMENT.getFrom(parserWithOptions.getOptions());
        if (includedText != null && !includedText.isEmpty() && (includedDocument = parserWithOptions.parse(includedText)) instanceof Document) {
            parserWithOptions = this.adjustParserForInclusion(parserWithOptions, (Document)includedDocument);
        }
        int iterations = (timed = ((Boolean)TIMED.getFrom(parserWithOptions.getOptions())).booleanValue()) ? (Integer)TIMED_ITERATIONS.getFrom(parserWithOptions.getOptions()) : 1;
        String inputText = input.toString();
        String useSource = this.actualSource(inputText, optionsSet);
        BasedSequence inputSource = inputText == useSource ? input : BasedSequenceImpl.of((CharSequence)useSource);
        long start = System.nanoTime();
        Node node = parserWithOptions.parse(inputSource);
        for (int i = 1; i < iterations; ++i) {
            parserWithOptions.parse(input);
        }
        long parse = System.nanoTime();
        if (node instanceof Document && includedDocument instanceof Document) {
            parserWithOptions.transferReferences((Document)node, (Document)includedDocument);
        }
        String html = rendererWithOptions.render(node);
        for (int i = 1; i < iterations; ++i) {
            rendererWithOptions.render(node);
        }
        long render = System.nanoTime();
        boolean embedTimed = (Boolean)EMBED_TIMED.getFrom((DataHolder)node.getDocument());
        if (timed || embedTimed) {
            System.out.print(String.format(TIMED_FORMAT_STRING, "", (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
        }
        this.testCase(node, options);
        html = this.actualHtml(html, optionsSet);
        String ast = this.ast(node);
        ast = this.actualAst(ast, optionsSet);
        boolean useActualHtml = this.useActualHtml();
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            DumpSpecReader.addSpecExample(outExpected, source, expectedHtml, expectedAst, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, useActualHtml ? html : expectedHtml, ast, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            if (embedTimed) {
                StringBuilder outExpected = new StringBuilder();
                outExpected.append(String.format(TIMED_FORMAT_STRING, (double)(parse - start) / 1000000.0 / (double)iterations, (double)(render - parse) / 1000000.0 / (double)iterations, (double)(render - start) / 1000000.0 / (double)iterations));
                outExpected.append(DumpSpecReader.addSpecExample(source, expectedHtml, "", optionsSet));
                expected = outExpected.toString();
            } else {
                expected = DumpSpecReader.addSpecExample(source, expectedHtml, "", optionsSet);
            }
            actual = DumpSpecReader.addSpecExample(source, useActualHtml ? html : expectedHtml, ast, optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        if (fileUrl != null) {
            Assert.assertEquals((String)fileUrl.toString(), (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected void assertAst(UrlString fileUrl, String source, String expectedAst, String optionsSet) {
        String actual;
        String expected;
        DataHolder options = optionsSet == null ? null : this.getOptions(this.example(), optionsSet);
        String parseSource = this.actualSource(source, optionsSet);
        if (options != null && ((Boolean)options.get(NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        Node node = this.parser().withOptions(options).parse(parseSource);
        String ast = this.ast(node);
        ast = this.actualAst(ast, optionsSet);
        if (this.example() != null && this.example().getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            DumpSpecReader.addSpecExample(outExpected, source, "", expectedAst, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            DumpSpecReader.addSpecExample(outActual, source, "", ast, optionsSet, true, this.example().getSection(), this.example().getExampleNumber());
            actual = outActual.toString();
        } else {
            expected = DumpSpecReader.addSpecExample(source, "", expectedAst, optionsSet);
            actual = DumpSpecReader.addSpecExample(source, "", ast, optionsSet);
        }
        this.specExample(expected, actual, optionsSet);
        if (options != null && ((Boolean)options.get(FAIL)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        if (fileUrl != null) {
            Assert.assertEquals((String)fileUrl.toString(), (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

