/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.spec.SpecReaderFactory;
import com.vladsch.flexmark.spec.UrlString;
import com.vladsch.flexmark.test.DumpSpecReader;
import com.vladsch.flexmark.test.RenderingTestCase;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class FullSpecTestCase
extends RenderingTestCase
implements SpecReaderFactory {
    public static final String SPEC_RESOURCE = "/ast_spec.md";
    protected DumpSpecReader dumpSpecReader;

    @Override
    public SpecReader create(InputStream inputStream, String fileUrl) {
        this.dumpSpecReader = new DumpSpecReader(inputStream, this, fileUrl, this);
        return this.dumpSpecReader;
    }

    public SpecReader create(InputStream inputStream) {
        return this.create(inputStream, new UrlString(SpecReader.getSpecInputFileUrl(this.getSpecResourceName())).toString());
    }

    public abstract String getSpecResourceName();

    public void addSpecExample(SpecExample example, Node node, DataHolder options, boolean ignoredCase, String html, String ast) {
    }

    public boolean outputActualFullSpec() {
        return false;
    }

    public boolean includeExampleCoords() {
        return true;
    }

    @Test
    public void testFullSpec() throws Exception {
        String specResourcePath = this.getSpecResourceName();
        SpecReader reader = this.dumpSpecReader == null || this.dumpSpecReader.getFileUrl() == null ? SpecReader.createAndReadExamples(specResourcePath, this) : SpecReader.createAndReadExamples(specResourcePath, this, this.dumpSpecReader.getFileUrl().toString());
        String fullSpec = SpecReader.readSpec(specResourcePath);
        String actual = this.dumpSpecReader.getFullSpec();
        if (this.outputActualFullSpec()) {
            System.out.println(actual);
        }
        if (reader.getFileUrl() != null) {
            Assert.assertEquals((String)reader.getFileUrl().toString(), (Object)fullSpec, (Object)actual);
        } else {
            Assert.assertEquals((Object)fullSpec, (Object)actual);
        }
    }
}

