/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.spec.SpecReaderFactory;
import com.vladsch.flexmark.test.DumpSpecReader;
import com.vladsch.flexmark.test.RenderingTestCase;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class FullSpecTestCase
extends RenderingTestCase
implements SpecReaderFactory {
    public static final String SPEC_RESOURCE = "/ast_spec.md";
    protected DumpSpecReader dumpSpecReader;

    @Override
    public SpecReader create(InputStream inputStream) {
        this.dumpSpecReader = new DumpSpecReader(inputStream, this);
        return this.dumpSpecReader;
    }

    public abstract String getSpecResourceName();

    public void addSpecExample(SpecExample example, Node node, DataHolder options, boolean ignoredCase, String html, String ast) {
    }

    @Override
    public boolean useActualHtml() {
        return true;
    }

    public boolean outputActualFullSpec() {
        return false;
    }

    public boolean includeExampleCoords() {
        return true;
    }

    @Test
    public void testFullSpec() throws Exception {
        String specResourcePath = this.getSpecResourceName();
        SpecReader.readExamples(specResourcePath, this);
        String fullSpec = SpecReader.readSpec(specResourcePath);
        String actual = this.dumpSpecReader.getFullSpec();
        if (this.outputActualFullSpec()) {
            System.out.println(actual);
        }
        Assert.assertEquals((Object)fullSpec, (Object)actual);
    }
}

