/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReaderFactory;
import com.vladsch.flexmark.test.DumpSpecReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecReader {
    public static final String EXAMPLE_KEYWORD = "example";
    public static final String EXAMPLE_BREAK = "````````````````````````````````";
    public static final String EXAMPLE_START = "```````````````````````````````` example";
    public static final String EXAMPLE_START_NBSP = "````````````````````````````````\u00a0example";
    public static final String EXAMPLE_TEST_BREAK = "````````````````";
    public static final String EXAMPLE_TEST_START = "```````````````` example";
    public static final String OPTIONS_KEYWORD = "options";
    public static final String OPTIONS_STRING = " options";
    public static final Pattern OPTIONS_PATTERN = Pattern.compile(".*(?:\\s|\u00a0)\\Qoptions\\E(?:\\s|\u00a0)*\\((?:\\s|\u00a0)*(.*)(?:\\s|\u00a0)*\\)(?:\\s|\u00a0)*");
    public static final String TYPE_BREAK = ".";
    public static final String TYPE_TEST_BREAK = "\u2026";
    protected static final Pattern SECTION_PATTERN = Pattern.compile("#{1,6} *(.*)");
    protected final InputStream inputStream;
    protected State state = State.BEFORE;
    protected String section;
    protected String optionsSet;
    protected StringBuilder source;
    protected StringBuilder html;
    protected StringBuilder ast;
    protected int exampleNumber = 0;
    protected List<SpecExample> examples = new ArrayList<SpecExample>();

    protected SpecReader(InputStream stream) {
        this.inputStream = stream;
    }

    public static List<SpecExample> readExamples() {
        return SpecReader.readExamples(null, null);
    }

    public static List<SpecExample> readExamples(String specResource) {
        List<SpecExample> examples = SpecReader.readExamples(specResource, null);
        if (examples.size() == 0) {
            throw new IllegalStateException("No examples were found in " + specResource);
        }
        return examples;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<SpecExample> readExamples(String specResource, SpecReaderFactory readerFactory) {
        try (InputStream stream = SpecReader.getSpecInputStream(specResource);){
            SpecReader reader = readerFactory == null ? new SpecReader(stream) : readerFactory.create(stream);
            List<SpecExample> list = reader.read();
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readExamplesAsString() {
        return SpecReader.readExamplesAsString(null, null);
    }

    public static List<String> readExamplesAsString(String specResource) {
        return SpecReader.readExamplesAsString(specResource, null);
    }

    public static List<String> readExamplesAsString(String specResource, SpecReaderFactory readerFactory) {
        List<SpecExample> examples = SpecReader.readExamples(specResource, readerFactory);
        ArrayList<String> result = new ArrayList<String>();
        for (SpecExample example : examples) {
            result.add(example.getSource());
        }
        return result;
    }

    public static String readSpec() {
        return SpecReader.readSpec(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSpec(String specResource) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SpecReader.getSpecInputStream(specResource), Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getSpecInputStream() {
        return SpecReader.getSpecInputStream(null);
    }

    public static InputStream getSpecInputStream(String specResource) {
        String specPath = specResource != null ? specResource : "/spec.txt";
        InputStream stream = SpecReader.class.getResourceAsStream(specPath);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + specResource + " classpath resource");
        }
        return stream;
    }

    protected List<SpecExample> read() throws IOException {
        this.resetContents();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        return this.examples;
    }

    protected void addSpecLine(String line) {
    }

    protected void addSpecExample(SpecExample example) {
        this.examples.add(example);
    }

    protected void processLine(String line) {
        boolean lineAbsorbed = false;
        switch (this.state) {
            case BEFORE: {
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    this.section = matcher.group(1);
                    this.exampleNumber = 0;
                    break;
                }
                if (!line.startsWith(EXAMPLE_START) && !line.startsWith(EXAMPLE_START_NBSP)) break;
                Matcher option_matcher = OPTIONS_PATTERN.matcher(line.subSequence(EXAMPLE_START.length(), line.length()));
                if (option_matcher.matches()) {
                    this.optionsSet = option_matcher.group(1);
                }
                this.state = State.SOURCE;
                ++this.exampleNumber;
                lineAbsorbed = true;
                break;
            }
            case SOURCE: {
                if (line.equals(TYPE_BREAK)) {
                    this.state = State.HTML;
                    lineAbsorbed = true;
                    break;
                }
                String processedLine = DumpSpecReader.unShowTabs(line);
                this.source.append(processedLine).append('\n');
                lineAbsorbed = true;
                break;
            }
            case HTML: {
                if (line.equals(EXAMPLE_BREAK)) {
                    this.state = State.BEFORE;
                    this.addSpecExample(new SpecExample(this.optionsSet, this.section, this.exampleNumber, this.source.toString(), this.html.toString(), null));
                    this.resetContents();
                    lineAbsorbed = true;
                    break;
                }
                if (line.equals(TYPE_BREAK)) {
                    this.state = State.AST;
                    lineAbsorbed = true;
                    break;
                }
                String processedLine = DumpSpecReader.unShowTabs(line);
                this.html.append(processedLine).append('\n');
                lineAbsorbed = true;
                break;
            }
            case AST: {
                if (line.equals(EXAMPLE_BREAK)) {
                    this.state = State.BEFORE;
                    this.addSpecExample(new SpecExample(this.optionsSet, this.section, this.exampleNumber, this.source.toString(), this.html.toString(), this.ast.toString()));
                    this.resetContents();
                    lineAbsorbed = true;
                    break;
                }
                this.ast.append(line).append('\n');
                lineAbsorbed = true;
            }
        }
        if (!lineAbsorbed) {
            this.addSpecLine(line);
        }
    }

    protected void resetContents() {
        this.optionsSet = "";
        this.source = new StringBuilder();
        this.html = new StringBuilder();
        this.ast = new StringBuilder();
    }

    protected static enum State {
        BEFORE,
        SOURCE,
        HTML,
        AST;

    }
}

