/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.spec.SpecReaderFactory;
import com.vladsch.flexmark.test.DumpSpecReader;
import com.vladsch.flexmark.test.RenderingTestCase;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class FullSpecTestCase
extends RenderingTestCase
implements SpecReaderFactory {
    public static final String SPEC_RESOURCE = "/ast_spec.md";
    private DumpSpecReader dumpSpecReader;

    @Override
    public SpecReader create(InputStream inputStream) {
        this.dumpSpecReader = new DumpSpecReader(inputStream, this);
        return this.dumpSpecReader;
    }

    protected abstract String getSpecResourceName();

    @Override
    protected boolean useActualHtml() {
        return true;
    }

    protected boolean outputActualFullSpec() {
        return false;
    }

    protected boolean includeExampleCoords() {
        return true;
    }

    @Test
    public void testFullSpec() throws Exception {
        String specResourcePath = this.getSpecResourceName();
        SpecReader.readExamples(specResourcePath, this);
        String fullSpec = SpecReader.readSpec(specResourcePath);
        String actual = this.dumpSpecReader.getFullSpec();
        if (this.outputActualFullSpec()) {
            System.out.println(actual);
        }
        Assert.assertEquals((Object)fullSpec, (Object)actual);
    }
}

