/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.spec.SpecExample;
import com.vladsch.flexmark.spec.SpecReader;
import com.vladsch.flexmark.test.FullSpecTestCase;
import com.vladsch.flexmark.test.RenderingTestCase;
import com.vladsch.flexmark.util.options.DataHolder;
import java.io.InputStream;
import org.junit.AssumptionViolatedException;

public class DumpSpecReader
extends SpecReader {
    private final StringBuilder sb = new StringBuilder();
    private final FullSpecTestCase testCase;

    public DumpSpecReader(InputStream stream, FullSpecTestCase testCase) {
        super(stream);
        this.testCase = testCase;
    }

    public String getFullSpec() {
        return this.sb.toString();
    }

    @Override
    protected void addSpecLine(String line) {
        this.sb.append(line).append("\n");
    }

    @Override
    protected void addSpecExample(SpecExample example) {
        String html;
        DataHolder options;
        boolean ignoredCase = false;
        try {
            options = this.testCase.getOptions(example, example.getOptionsSet());
        }
        catch (AssumptionViolatedException ignored) {
            ignoredCase = true;
            options = null;
        }
        if (options != null && ((Boolean)options.get(RenderingTestCase.FAIL)).booleanValue()) {
            ignoredCase = true;
        }
        String parseSource = example.getSource();
        if (options != null && ((Boolean)options.get(RenderingTestCase.NO_FILE_EOL)).booleanValue()) {
            parseSource = DumpSpecReader.trimTrailingEOL(parseSource);
        }
        Node node = this.testCase.parser().withOptions(options).parse(parseSource);
        String string = html = !ignoredCase && this.testCase.useActualHtml() ? this.testCase.renderer().withOptions(options).render(node) : example.getHtml();
        String ast = example.getAst() == null ? null : (!ignoredCase ? this.testCase.ast(node) : example.getAst());
        DumpSpecReader.addSpecExample(this.sb, example.getSource(), html, ast, example.getOptionsSet(), this.testCase.includeExampleCoords(), example.getSection(), example.getExampleNumber());
    }

    public static String addSpecExample(String source, String html, String ast, String optionsSet) {
        StringBuilder sb = new StringBuilder();
        DumpSpecReader.addSpecExample(sb, source, html, ast, optionsSet, false, "", 0);
        return sb.toString();
    }

    public static void addSpecExample(StringBuilder sb, String source, String html, String ast, String optionsSet, boolean includeExampleCoords, String section, int number) {
        StringBuilder header = new StringBuilder();
        header.append("```````````````````````````````` example");
        if (includeExampleCoords) {
            if (optionsSet != null) {
                header.append("(").append(section == null ? "" : section.trim()).append(": ").append(number).append(")");
            } else {
                header.append(" ").append(section == null ? "" : section.trim()).append(": ").append(number);
            }
        }
        if (optionsSet != null) {
            header.append(" options(").append(optionsSet).append(")");
        }
        header.append("\n");
        if (includeExampleCoords) {
            sb.append(header.toString().replace(' ', '\u00a0'));
        } else {
            sb.append(header.toString());
        }
        if (ast != null) {
            sb.append(DumpSpecReader.showTabs(source + "." + "\n" + html)).append(".").append("\n").append(ast).append("````````````````````````````````").append("\n");
        } else {
            sb.append(DumpSpecReader.showTabs(source + "." + "\n" + html)).append("````````````````````````````````").append("\n");
        }
    }

    public static String showTabs(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\u2192", "&#2192;").replace("\t", "\u2192").replace("\u23ae", "&#23ae;").replace("\u001f", "\u23ae").replace("\u23ce", "&#23ce").replace("\r", "\u23ce");
    }

    public static String unShowTabs(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\u23ce", "\r").replace("&#23ce", "\u23ce").replace("\u23ae", "\u001f").replace("&#23ae;", "\u23ae").replace('\u2192', '\t').replace("&#2192;", "\u2192");
    }

    public static String trimTrailingEOL(String parseSource) {
        if (!parseSource.isEmpty() && parseSource.charAt(parseSource.length() - 1) == '\n') {
            int pos = parseSource.lastIndexOf(10, parseSource.length() - 2);
            if (pos == -1 || !parseSource.substring(pos + 1).trim().isEmpty()) {
                parseSource = parseSource.substring(0, parseSource.length() - 1);
            } else {
                boolean bl = false;
            }
        }
        return parseSource;
    }
}

