/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.pdf.converter;

import com.openhtmltopdf.DOMBuilder;
import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class PdfConverterExtension {
    public static final DataKey<BaseRendererBuilder.TextDirection> DEFAULT_TEXT_DIRECTION = new DataKey("DEFAULT_TEXT_DIRECTION", (Object)null);
    public static final DataKey<ProtectionPolicy> PROTECTION_POLICY = new DataKey("PROTECTION_POLICY", (Object)null);

    public static void exportToPdf(String out, String html, String url, DataHolder options) {
        PdfConverterExtension.exportToPdf(out, html, url, (BaseRendererBuilder.TextDirection)options.get(DEFAULT_TEXT_DIRECTION), (ProtectionPolicy)options.get(PROTECTION_POLICY));
    }

    public static void exportToPdf(String out, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection) {
        PdfConverterExtension.exportToPdf(out, html, url, defaultTextDirection, null);
    }

    public static void exportToPdf(String out, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection, ProtectionPolicy protectionPolicy) {
        try {
            FileOutputStream os = new FileOutputStream(out);
            PdfConverterExtension.exportToPdf(os, html, url, defaultTextDirection, protectionPolicy);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void exportToPdf(OutputStream os, String html, String url, DataHolder options) {
        PdfConverterExtension.exportToPdf(os, html, url, (BaseRendererBuilder.TextDirection)options.get(DEFAULT_TEXT_DIRECTION), (ProtectionPolicy)options.get(PROTECTION_POLICY));
    }

    public static void exportToPdf(OutputStream os, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection) {
        PdfConverterExtension.exportToPdf(os, html, url, defaultTextDirection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToPdf(OutputStream os, String html, String url, BaseRendererBuilder.TextDirection defaultTextDirection, ProtectionPolicy protectionPolicy) {
        PdfBoxRenderer renderer = null;
        try {
            PdfRendererBuilder builder = new PdfRendererBuilder();
            PdfConverterExtension.handleTextDirection(defaultTextDirection, builder);
            PdfConverterExtension.handleW3cDocument(html, url, builder);
            builder.toStream(os);
            renderer = builder.buildPdfRenderer();
            PDDocument document = renderer.getPdfDocument();
            if (protectionPolicy != null) {
                document.protect(protectionPolicy);
            }
            renderer.layout();
            renderer.createPDF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (renderer != null) {
                    renderer.close();
                }
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void handleW3cDocument(String html, String url, PdfRendererBuilder builder) {
        Document doc = Jsoup.parse((String)html);
        org.w3c.dom.Document dom = DOMBuilder.jsoup2DOM((Document)doc);
        builder.withW3cDocument(dom, url);
    }

    private static void handleTextDirection(BaseRendererBuilder.TextDirection defaultTextDirection, PdfRendererBuilder builder) {
        if (defaultTextDirection != null) {
            builder.useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory());
            builder.useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer());
            builder.defaultTextDirection(defaultTextDirection);
        }
    }
}

