/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.options.MessageProvider;
import com.vladsch.flexmark.util.options.OptionParser;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.options.ParsedOptionStatus;
import com.vladsch.flexmark.util.options.ParserMessage;
import com.vladsch.flexmark.util.options.ParserParams;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TocLevelsOptionParser
implements OptionParser<TocOptions> {
    public static final String OPTION_0_VALUE_1_NOT_IN_RANGE = "{0} option value {1} is not an integer in the range [1, 6]";
    public static final String KEY_OPTION_0_VALUE_1_NOT_IN_RANGE = "options.parser.toc-levels-option.not-in-range";
    public static final String OPTION_0_VALUE_1_NOT_INTEGER = "{0} option value {1} is not an integer";
    public static final String KEY_OPTION_0_VALUE_1_NOT_INTEGER = "options.parser.toc-levels-option.not-integer";
    public static final String OPTION_0_VALUE_1_TRUNCATED_TO_RANGE_2 = "{0} option value {1} truncated to range [{2}]";
    public static final String KEY_OPTION_0_VALUE_1_TRUNCATED_TO_RANGE_2 = "options.parser.toc-levels-option.truncated-to-range";
    public static final String OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE = "{0} option value {1} truncated to empty range []";
    public static final String KEY_OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE = "options.parser.toc-levels-option.truncated-to-empty";
    private final String myOptionName;
    private static final Map<Integer, String> TOC_LEVELS_MAP = new HashMap<Integer, String>();

    public TocLevelsOptionParser(String optionName) {
        this.myOptionName = optionName;
    }

    @Override
    public String getOptionName() {
        return this.myOptionName;
    }

    @Override
    public Pair<TocOptions, List<ParsedOption<TocOptions>>> parseOption(BasedSequence optionText, TocOptions options, MessageProvider provider) {
        TocOptions result = options;
        BasedSequence[] levelsOptionValue = (BasedSequence[])optionText.split(",");
        ParserParams parserParams = new ParserParams();
        if (provider == null) {
            provider = MessageProvider.DEFAULT;
        }
        int newLevels = 0;
        int i = 0;
        MessageProvider finalProvider = provider;
        Function<BasedSequence, Integer> convertWithMessage = option -> {
            try {
                return option.isEmpty() ? null : Integer.valueOf(Integer.parseInt(option.toString()));
            }
            catch (Exception ignored) {
                parserParams.add(new ParserMessage((BasedSequence)option, ParsedOptionStatus.ERROR, finalProvider.message(KEY_OPTION_0_VALUE_1_NOT_INTEGER, OPTION_0_VALUE_1_NOT_INTEGER, this.myOptionName, option)));
                parserParams.skip = true;
                return null;
            }
        };
        for (BasedSequence option2 : levelsOptionValue) {
            Integer rangeEnd;
            Integer rangeStart;
            BasedSequence[] optionRange = (BasedSequence[])option2.split("-", 2, 2);
            parserParams.skip = false;
            if (optionRange.length == 2) {
                rangeStart = convertWithMessage.apply(optionRange[0]);
                rangeEnd = convertWithMessage.apply(optionRange[1]);
                if (rangeStart == null) {
                    rangeStart = 1;
                }
                if (rangeEnd == null) {
                    rangeEnd = 6;
                }
            } else {
                rangeEnd = rangeStart = convertWithMessage.apply(optionRange[0]);
            }
            if (!parserParams.skip) {
                if (rangeStart == null) {
                    parserParams.add(new ParserMessage(option2, ParsedOptionStatus.IGNORED, finalProvider.message(KEY_OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE, OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE, this.myOptionName, option2)));
                } else {
                    if (rangeEnd < rangeStart) {
                        int tmp = rangeStart;
                        rangeStart = rangeEnd;
                        rangeEnd = tmp;
                    }
                    if (rangeEnd < 1 || rangeStart > 6) {
                        if (rangeStart.intValue() == rangeEnd.intValue()) {
                            parserParams.add(new ParserMessage(option2, ParsedOptionStatus.IGNORED, provider.message(KEY_OPTION_0_VALUE_1_NOT_IN_RANGE, OPTION_0_VALUE_1_NOT_IN_RANGE, this.myOptionName, option2)));
                        } else {
                            parserParams.add(new ParserMessage(option2, ParsedOptionStatus.WARNING, finalProvider.message(KEY_OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE, OPTION_0_VALUE_1_TRUNCATED_TO_EMPTY_RANGE, this.myOptionName, option2)));
                        }
                    } else {
                        int wasStart = rangeStart;
                        int wasEnd = rangeEnd;
                        rangeStart = Utils.minLimit(rangeStart, 1);
                        rangeEnd = Utils.maxLimit(rangeEnd, 6);
                        if (wasStart != rangeStart || wasEnd != rangeEnd) {
                            parserParams.add(new ParserMessage(option2, ParsedOptionStatus.WEAK_WARNING, finalProvider.message(KEY_OPTION_0_VALUE_1_TRUNCATED_TO_RANGE_2, OPTION_0_VALUE_1_TRUNCATED_TO_RANGE_2, this.myOptionName, option2, rangeStart + ", " + rangeEnd)));
                        }
                        for (int b = rangeStart.intValue(); b <= rangeEnd; ++b) {
                            newLevels |= 1 << b;
                        }
                    }
                }
            }
            ++i;
        }
        if (newLevels != 0) {
            result = result.withLevels(newLevels);
        }
        return new Pair<TocOptions, List<ParsedOption<TocOptions>>>(result, Collections.singletonList(new ParsedOption<TocOptions>(optionText, this, parserParams.status, parserParams.messages)));
    }

    @Override
    public String getOptionText(TocOptions options, TocOptions defaultOptions) {
        if (defaultOptions == null || options.levels != defaultOptions.levels) {
            DelimitedBuilder out = new DelimitedBuilder();
            out.append("levels=");
            String fixedLevels = TOC_LEVELS_MAP.get(options.levels);
            if (fixedLevels != null) {
                out.append(fixedLevels).mark();
            } else {
                out.push(",");
                int firstBit = 0;
                int lastBit = 0;
                for (int i = 1; i <= 6; ++i) {
                    if (!options.isLevelIncluded(i)) continue;
                    if (firstBit == 0) {
                        firstBit = i;
                        lastBit = i;
                        continue;
                    }
                    if (lastBit + 1 != i) {
                        if (firstBit != lastBit) {
                            if (firstBit + 1 == lastBit) {
                                out.append(firstBit).mark().append(lastBit).mark();
                            } else {
                                out.append(firstBit).append('-').append(lastBit).mark();
                            }
                        } else {
                            out.append(firstBit).mark();
                        }
                        firstBit = i;
                        lastBit = i;
                        continue;
                    }
                    lastBit = i;
                }
                if (firstBit != 0) {
                    if (firstBit != lastBit) {
                        if (firstBit == 2) {
                            out.append(lastBit).mark();
                        } else if (firstBit + 1 == lastBit) {
                            out.append(firstBit).mark().append(lastBit).mark();
                        } else {
                            out.append(firstBit).append('-').append(lastBit).mark();
                        }
                    } else {
                        out.append(firstBit).mark();
                    }
                }
                out.pop().mark();
            }
            return out.toString();
        }
        return "";
    }

    static {
        TOC_LEVELS_MAP.put(4, "2");
        TOC_LEVELS_MAP.put(12, "3");
        TOC_LEVELS_MAP.put(28, "4");
        TOC_LEVELS_MAP.put(60, "5");
        TOC_LEVELS_MAP.put(124, "6");
        TOC_LEVELS_MAP.put(2, "1");
        TOC_LEVELS_MAP.put(8, "3,3");
        TOC_LEVELS_MAP.put(16, "4,4");
        TOC_LEVELS_MAP.put(32, "5,5");
        TOC_LEVELS_MAP.put(64, "6,6");
    }
}

