/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ext.gitlab.GitLabBlockQuote;
import com.vladsch.flexmark.ext.gitlab.GitLabDel;
import com.vladsch.flexmark.ext.gitlab.GitLabInlineMath;
import com.vladsch.flexmark.ext.gitlab.GitLabIns;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitLabNodeRenderer
implements NodeRenderer {
    public static final AttributablePart VIDEO = new AttributablePart("VIDEO");
    public static final AttributablePart VIDEO_LINK = new AttributablePart("VIDEO_LINK");
    final GitLabOptions options;
    private final boolean codeContentBlock;
    private final ReferenceRepository referenceRepository;
    private final boolean recheckUndefinedReferences;

    public GitLabNodeRenderer(DataHolder options) {
        this.options = new GitLabOptions(options);
        this.codeContentBlock = Parser.FENCED_CODE_CONTENT_BLOCK.get(options);
        this.referenceRepository = Parser.REFERENCES.get(options);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<GitLabIns>(GitLabIns.class, this::render));
        set.add(new NodeRenderingHandler<GitLabDel>(GitLabDel.class, this::render));
        set.add(new NodeRenderingHandler<GitLabInlineMath>(GitLabInlineMath.class, this::render));
        set.add(new NodeRenderingHandler<GitLabBlockQuote>(GitLabBlockQuote.class, this::render));
        if (this.options.renderBlockMath || this.options.renderBlockMermaid) {
            set.add(new NodeRenderingHandler<FencedCodeBlock>(FencedCodeBlock.class, this::render));
        }
        if (this.options.renderVideoImages) {
            set.add(new NodeRenderingHandler<Image>(Image.class, this::render));
            set.add(new NodeRenderingHandler<ImageRef>(ImageRef.class, this::render));
        }
        return set;
    }

    private void render(GitLabIns node, NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tag("ins", false, false, () -> context.renderChildren(node));
    }

    private void render(GitLabDel node, NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tag("del", false, false, () -> context.renderChildren(node));
    }

    private void render(GitLabInlineMath node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.withAttr().attr("class", this.options.inlineMathClass)).withAttr().tag("span");
        html.text(node.getText());
        html.tag("/span");
    }

    private void render(GitLabBlockQuote node, NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagLineIndent("blockquote", () -> context.renderChildren(node));
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence info = node.getInfoDelimitedByAny(this.options.blockInfoDelimiterSet);
        if (this.options.renderBlockMath && info.equals("math")) {
            html.line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).attr("class", this.options.blockMathClass)).withAttr().tag("div")).line()).openPre();
            if (this.codeContentBlock) {
                context.renderChildren(node);
            } else {
                html.text(node.getContentChars().normalizeEOL());
            }
            ((HtmlWriter)html.closePre()).tag("/div");
            html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
        } else if (this.options.renderBlockMermaid && info.equals("mermaid")) {
            html.line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).attr("class", this.options.blockMermaidClass)).withAttr().tag("div")).line()).openPre();
            if (this.codeContentBlock) {
                context.renderChildren(node);
            } else {
                html.text(node.getContentChars().normalizeEOL());
            }
            ((HtmlWriter)html.closePre()).tag("/div");
            html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
        } else {
            context.delegateRender();
        }
    }

    private boolean renderVideoImage(Node srcNode, String url, String altText, Attributes attributes, HtmlWriter html) {
        String extension;
        String bareUrl = url;
        int pos = url.indexOf(63);
        if (pos != -1) {
            bareUrl = url.substring(0, pos);
        }
        if ((pos = bareUrl.lastIndexOf(46)) != -1 && this.options.videoImageExtensionSet.contains(extension = bareUrl.substring(pos + 1))) {
            ((HtmlWriter)((HtmlWriter)html.attr("class", this.options.videoImageClass)).attr(attributes)).withAttr().tagLineIndent("div", () -> {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(srcNode.getChars()).attr("src", url)).attr("width", "400")).attr("controls", "true")).withAttr(VIDEO).tag("video")).tag("/video")).line();
                if (this.options.renderVideoLink) {
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag("p")).attr("href", url)).attr("target", "_blank")).attr("rel", "noopener noreferrer")).attr("title", String.format(this.options.videoImageLinkTextFormat, altText))).withAttr(VIDEO_LINK).tag("a")).text(altText)).tag("/a")).tag("/p")).line();
                }
            });
            return true;
        }
        return false;
    }

    private void render(Image node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks() && !CoreNodeRenderer.isSuppressedLinkPrefix(node.getUrl(), context)) {
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null, null);
            String url = resolvedLink.getUrl();
            if (node.getUrlContent().isEmpty()) {
                Attributes attributes = resolvedLink.getNonNullAttributes();
                if (this.renderVideoImage(node, url, altText, attributes = context.extendRenderingNodeAttributes(node, AttributablePart.NODE, attributes), html)) {
                    return;
                }
            }
            context.delegateRender();
        }
    }

    private void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
        ResolvedLink resolvedLink = null;
        boolean isSuppressed = false;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            isSuppressed = CoreNodeRenderer.isSuppressedLinkPrefix(url, context);
            resolvedLink = context.resolveLink(LinkType.IMAGE, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue("title", reference.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove("title");
            }
        } else {
            String normalizeRef = this.referenceRepository.normalizeKey(node.getReference());
            resolvedLink = context.resolveLink(LinkType.IMAGE_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink != null && !context.isDoNotRenderLinks() && !isSuppressed) {
            Attributes attributes;
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            String url = resolvedLink.getUrl();
            if (this.renderVideoImage(node, url, altText, attributes = resolvedLink.getNonNullAttributes(), html)) {
                return;
            }
        }
        context.delegateRender();
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new GitLabNodeRenderer(options);
        }
    }
}

