/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskListItemBlockPreProcessor
implements BlockPreProcessor {
    public TaskListItemBlockPreProcessor(DataHolder options) {
    }

    @Override
    public void preProcess(ParserState state, Block block) {
        ListItem listItem;
        BasedSequence markerSuffix;
        if ((block instanceof BulletListItem || block instanceof OrderedListItem) && ((markerSuffix = (listItem = (ListItem)block).getMarkerSuffix()).matches("[ ]") || markerSuffix.matches("[x]") || markerSuffix.matches("[X]"))) {
            TaskListItem taskListItem = new TaskListItem(listItem);
            taskListItem.setTight(listItem.isOwnTight());
            listItem.insertBefore(taskListItem);
            listItem.unlink();
            state.blockAdded(taskListItem);
            state.blockRemoved(listItem);
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        @Override
        @NotNull
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(BulletListItem.class);
            set.add(OrderedListItem.class);
            return set;
        }

        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return true;
        }

        @Override
        @NotNull
        public BlockPreProcessor apply(@NotNull ParserState state) {
            return new TaskListItemBlockPreProcessor(state.getProperties());
        }
    }
}

