/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.Attributes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AttributesNodeRenderer
implements NodeRenderer {
    private final AttributesOptions myOptions;

    public AttributesNodeRenderer(DataHolder options) {
        this.myOptions = new AttributesOptions(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<AttributesNode>(AttributesNode.class, (node, context, html) -> {}));
        set.add(new NodeRenderingHandler<TextBase>(TextBase.class, (node, context, html) -> {
            Attributes nodeAttributes;
            if (this.myOptions.assignTextAttributes && !(nodeAttributes = context.extendRenderingNodeAttributes(AttributablePart.NODE, null)).isEmpty()) {
                ((HtmlWriter)html.setAttributes(nodeAttributes)).withAttr().tag("span");
                context.delegateRender();
                html.closeTag("span");
                return;
            }
            context.delegateRender();
        }));
        return set;
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new AttributesNodeRenderer(options);
        }
    }
}

