/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class NodeCollectingVisitor {
    public static final Function<Node, Class<?>> NODE_CLASSIFIER = Object::getClass;
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    @NotNull
    private final HashMap<Class<?>, List<Class<?>>> subClassMap;
    @NotNull
    private final HashSet<Class<?>> included;
    @NotNull
    private final HashSet<Class<?>> excluded;
    @NotNull
    private final ClassificationBag<Class<?>, Node> nodes;
    @NotNull
    private final Class<?>[] classes;

    public NodeCollectingVisitor(@NotNull Set<Class<?>> classes) {
        this.classes = classes.toArray(EMPTY_CLASSES);
        this.subClassMap = new HashMap();
        this.included = new HashSet();
        this.included.addAll(classes);
        for (Class<?> clazz : classes) {
            ArrayList classList = new ArrayList(1);
            classList.add(clazz);
            this.subClassMap.put(clazz, classList);
        }
        this.excluded = new HashSet();
        this.nodes = new ClassificationBag(NODE_CLASSIFIER);
    }

    public void collect(@NotNull Node node) {
        this.visit(node);
    }

    public SubClassingBag<Node> getSubClassingBag() {
        return new SubClassingBag<Node>(this.nodes, this.subClassMap);
    }

    private void visit(@NotNull Node node) {
        Class<?> nodeClass = node.getClass();
        if (this.included.contains(nodeClass)) {
            this.nodes.add(node);
        } else if (!this.excluded.contains(nodeClass)) {
            for (Class<?> clazz : this.classes) {
                if (!clazz.isInstance(node)) continue;
                this.included.add(nodeClass);
                List<Class<?>> classList = this.subClassMap.get(clazz);
                if (classList == null) {
                    classList = new ArrayList(2);
                    classList.add(clazz);
                    classList.add(nodeClass);
                    this.subClassMap.put(clazz, classList);
                } else {
                    classList.add(nodeClass);
                }
                this.nodes.add(node);
                this.visitChildren(node);
                return;
            }
            this.excluded.add(nodeClass);
        }
        this.visitChildren(node);
    }

    private void visitChildren(@NotNull Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.visit(node);
            node = next;
        }
    }
}

