/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.dependency.FirstDependent;
import com.vladsch.flexmark.util.misc.FileUtil;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeNodePostProcessor
extends NodePostProcessor {
    final HashMap<JekyllTagBlock, String> includedDocuments = new HashMap();
    final HashMap<String, ResolvedLink> resolvedLinks = new HashMap();
    final Parser parser;
    final List<LinkResolver> linkResolvers;
    final boolean isIncluding = false;
    final Document document;
    final LinkResolverBasicContext context;

    public IncludeNodePostProcessor(final @NotNull Document document) {
        this.document = document;
        this.parser = Parser.builder(document).build();
        this.context = new LinkResolverBasicContext(){

            @Override
            @NotNull
            public DataHolder getOptions() {
                return document;
            }

            @Override
            @NotNull
            public Document getDocument() {
                return document;
            }
        };
        List<LinkResolverFactory> resolverFactories = DependencyResolver.resolveFlatDependencies(JekyllTagExtension.LINK_RESOLVER_FACTORIES.get(document), null, null);
        assert (!resolverFactories.isEmpty());
        this.linkResolvers = new ArrayList<LinkResolver>(resolverFactories.size());
        for (LinkResolverFactory resolverFactory : resolverFactories) {
            this.linkResolvers.add(resolverFactory.apply(this.context));
        }
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        if (node instanceof JekyllTagBlock && !this.includedDocuments.containsKey(node)) {
            for (Node tag : node.getChildren()) {
                File includedFile;
                String url;
                JekyllTag jekyllTag;
                if (!(tag instanceof JekyllTag) || !(jekyllTag = (JekyllTag)tag).getTag().equals("include")) continue;
                BasedSequence parameters = jekyllTag.getParameters();
                String rawUrl = parameters.unescape();
                ResolvedLink resolvedLink = this.resolvedLinks.get(rawUrl);
                if (resolvedLink == null) {
                    LinkResolver linkResolver;
                    resolvedLink = new ResolvedLink(LinkType.LINK, rawUrl);
                    Iterator<LinkResolver> iterator = this.linkResolvers.iterator();
                    while (iterator.hasNext() && (resolvedLink = (linkResolver = iterator.next()).resolveLink(node, this.context, resolvedLink)).getStatus() == LinkStatus.UNKNOWN) {
                    }
                    this.resolvedLinks.put(rawUrl, resolvedLink);
                }
                if (resolvedLink.getStatus() != LinkStatus.VALID || !(url = resolvedLink.getUrl()).startsWith("file://") || !(includedFile = new File(url.substring("file://".length()))).isFile() || !includedFile.exists()) continue;
                String fileContent = FileUtil.getFileContent(includedFile);
                this.includedDocuments.put((JekyllTagBlock)node, fileContent);
                Document includedDoc = this.parser.parse(fileContent);
                this.parser.transferReferences(this.document, includedDoc, null);
                if (includedDoc.contains(Parser.REFERENCES)) {
                    this.document.set(HtmlRenderer.RECHECK_UNDEFINED_REFERENCES, Boolean.valueOf(true));
                }
                Node child = includedDoc.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    node.appendChild(child);
                    state.nodeAddedWithDescendants(child);
                    child = next;
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(JekyllTagBlock.class);
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return Collections.singleton(FirstDependent.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document) {
            return new IncludeNodePostProcessor(document);
        }
    }
}

