/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.renderer.DelegatingNodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.dependency.Dependent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

class DelegatingNodeRendererFactoryWrapper
implements Function<DataHolder, NodeRenderer>,
Dependent<DelegatingNodeRendererFactoryWrapper>,
DelegatingNodeRendererFactory {
    private final NodeRendererFactory nodeRendererFactory;
    private List<DelegatingNodeRendererFactoryWrapper> nodeRenderers;
    private Set<Class> myDelegates = null;

    public DelegatingNodeRendererFactoryWrapper(List<DelegatingNodeRendererFactoryWrapper> nodeRenderers, NodeRendererFactory nodeRendererFactory) {
        this.nodeRendererFactory = nodeRendererFactory;
        this.nodeRenderers = nodeRenderers;
    }

    @Override
    public NodeRenderer apply(DataHolder options) {
        return this.nodeRendererFactory.apply(options);
    }

    public NodeRendererFactory getFactory() {
        return this.nodeRendererFactory;
    }

    @Override
    public Set<Class<? extends NodeRendererFactory>> getDelegates() {
        return this.nodeRendererFactory instanceof DelegatingNodeRendererFactory ? ((DelegatingNodeRendererFactory)this.nodeRendererFactory).getDelegates() : null;
    }

    @Override
    public final Set<? extends Class> getAfterDependents() {
        return null;
    }

    @Override
    public Set<? extends Class> getBeforeDependents() {
        if (this.myDelegates == null && this.nodeRenderers != null) {
            Set<Class<? extends NodeRendererFactory>> delegates = this.getDelegates();
            if (delegates != null) {
                this.myDelegates = new HashSet<Class>();
                for (DelegatingNodeRendererFactoryWrapper factory : this.nodeRenderers) {
                    if (!delegates.contains(factory.getFactory().getClass())) continue;
                    this.myDelegates.add(factory.getFactory().getClass());
                }
            }
            this.nodeRenderers = null;
        }
        return this.myDelegates;
    }

    @Override
    public final boolean affectsGlobalScope() {
        return false;
    }
}

