/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.escaped.character.internal;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacter;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.ReplacedTextRegion;
import java.util.ArrayList;

public class EscapedCharacterNodePostProcessor
extends NodePostProcessor {
    public EscapedCharacterNodePostProcessor(Document document) {
    }

    @Override
    public void process(NodeTracker state, Node node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape(original, textMapper);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        ArrayList<ReplacedTextRegion> replacedRegions = textMapper.getRegions();
        for (ReplacedTextRegion region : replacedRegions) {
            int startOffset = region.getOriginalRange().getStart();
            int endOffset = region.getOriginalRange().getEnd();
            if (original.charAt(startOffset) != '\\' || region.getReplacedRange().length() != 1 || startOffset + 1 >= original.length()) continue;
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore(textBase);
                state.nodeAdded(textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = (BasedSequence)original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            BasedSequence origToDecorateText = (BasedSequence)original.subSequence(startOffset, endOffset);
            BasedSequence text = (BasedSequence)origToDecorateText.subSequence(1);
            EscapedCharacter decorationNode = new EscapedCharacter((BasedSequence)origToDecorateText.subSequence(0, 1), text);
            textBase.appendChild(decorationNode);
            state.nodeAdded(decorationNode);
            lastEscaped = endOffset;
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = (BasedSequence)original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, DoNotDecorate.class);
        }

        @Override
        public NodePostProcessor apply(Document document) {
            return new EscapedCharacterNodePostProcessor(document);
        }
    }
}

