/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataValueFactory;

public class DataKey<T> {
    private final String name;
    private final DataValueFactory<T> factory;
    private final T defaultValue;

    public DataKey(String name, DataValueFactory<T> factory) {
        this.name = name;
        this.defaultValue = factory.apply(null);
        this.factory = factory;
    }

    public DataKey(String name, DataKey<? extends T> defaultKey) {
        this(name, defaultKey::getFrom);
    }

    public DataKey(String name, T defaultValue) {
        this(name, options -> defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public DataValueFactory<T> getFactory() {
        return this.factory;
    }

    public T getDefaultValue(DataHolder holder) {
        return (T)(holder == null ? this.defaultValue : this.factory.apply(holder));
    }

    public T getFrom(DataHolder holder) {
        return holder == null ? this.defaultValue : holder.get(this);
    }

    public String toString() {
        if (this.defaultValue != null) {
            return "DataKey<" + this.defaultValue.getClass().getName().substring(this.defaultValue.getClass().getPackage().getName().length() + 1) + "> " + this.name;
        }
        Object defaultValue = this.factory.apply(null);
        if (defaultValue != null) {
            return "DataKey<" + defaultValue.getClass().getName().substring(defaultValue.getClass().getPackage().getName().length() + 1) + "> " + this.name;
        }
        return "DataKey<unknown> " + this.name;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.factory.hashCode();
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }
}

