/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.regex.Pattern;

public class Parsing {
    public static final char INTELLIJ_DUMMY_IDENTIFIER_CHAR = '\u001f';
    public static final String INTELLIJ_DUMMY_IDENTIFIER = "\u001f";
    public final DataHolder options;
    public final String ADDITIONAL_CHARS;
    public final String EXCLUDED_0_TO_SPACE;
    public final String EOL;
    public final String ESCAPED_CHAR;
    public final Pattern LINK_LABEL;
    public final Pattern LINK_DESTINATION_ANGLES;
    public final String LINK_TITLE_STRING;
    public final Pattern LINK_TITLE;
    public final String REG_CHAR;
    public final String REG_CHAR_SP;
    public final String IN_PARENS_NOSP;
    public final String IN_PARENS_W_SP;
    public final String IN_BRACES_W_SP;
    public final Pattern LINK_DESTINATION;
    public final Pattern LINK_DESTINATION_MATCHED_PARENS;
    public final Pattern LINK_DESTINATION_MATCHED_PARENS_NOSP;
    public final String HTMLCOMMENT;
    public final String PROCESSINGINSTRUCTION;
    public final String DECLARATION;
    public final String CDATA;
    public final String ENTITY;
    public final Pattern ENTITY_HERE;
    public final String ASCII_PUNCTUATION;
    public final String ASCII_OPEN_PUNCTUATION;
    public final String ASCII_CLOSE_PUNCTUATION;
    public final Pattern PUNCTUATION;
    public final Pattern PUNCTUATION_OPEN;
    public final Pattern PUNCTUATION_CLOSE;
    public final Pattern PUNCTUATION_ONLY;
    public final Pattern PUNCTUATION_OPEN_ONLY;
    public final Pattern PUNCTUATION_CLOSE_ONLY;
    public final Pattern ESCAPABLE;
    public final Pattern TICKS;
    public final Pattern TICKS_HERE;
    public final Pattern EMAIL_AUTOLINK;
    public final Pattern AUTOLINK;
    public final Pattern WWW_AUTOLINK;
    public final Pattern SPNL;
    public final Pattern SPNL_URL;
    public final Pattern SPNI;
    public final Pattern SP;
    public final Pattern REST_OF_LINE;
    public final Pattern UNICODE_WHITESPACE_CHAR;
    public final Pattern WHITESPACE;
    public final Pattern FINAL_SPACE;
    public final Pattern LINE_END;
    public final String TAGNAME;
    public final String ATTRIBUTENAME;
    public final String UNQUOTEDVALUE;
    public final String SINGLEQUOTEDVALUE;
    public final String DOUBLEQUOTEDVALUE;
    public final String ATTRIBUTEVALUE;
    public final String ATTRIBUTEVALUESPEC;
    public final String ATTRIBUTE;
    public final String OPENTAG;
    public final String CLOSETAG;
    public final String HTMLTAG;
    public final Pattern HTML_TAG;
    public final Pattern LIST_ITEM_MARKER;
    public final int CODE_BLOCK_INDENT;
    public final boolean intellijDummyIdentifier;
    public final boolean htmlForTranslator;
    public final String translationHtmlInlineTagPattern;
    public final String translationAutolinkTagPattern;
    public final String INVALID_LINK_CHARS;
    public final String IN_MATCHED_PARENS_NOSP;
    public final String IN_MATCHED_PARENS_W_SP;
    public final String REG_CHAR_PARENS;
    public final String REG_CHAR_SP_PARENS;

    public Parsing(DataHolder options) {
        this.options = options;
        this.intellijDummyIdentifier = Parser.INTELLIJ_DUMMY_IDENTIFIER.getFrom(options);
        this.htmlForTranslator = Parser.HTML_FOR_TRANSLATOR.getFrom(options);
        this.translationHtmlInlineTagPattern = Parser.TRANSLATION_HTML_INLINE_TAG_PATTERN.getFrom(options);
        this.translationAutolinkTagPattern = Parser.TRANSLATION_AUTOLINK_TAG_PATTERN.getFrom(options);
        this.EOL = "(?:\r\n|\r|\n)";
        this.ADDITIONAL_CHARS = this.ADDITIONAL_CHARS();
        this.EXCLUDED_0_TO_SPACE = this.EXCLUDED_0_TO_SPACE();
        this.ESCAPED_CHAR = "\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
        this.LINK_LABEL = Pattern.compile("^\\[(?:[^\\\\\\[\\]]|" + this.ESCAPED_CHAR + "|\\\\){0,999}\\]");
        this.LINK_DESTINATION_ANGLES = Parser.SPACE_IN_LINK_URLS.getFrom(options) != false ? Pattern.compile("^(?:[<](?:[^<> \\t\\n\\\\\\x00]|" + this.ESCAPED_CHAR + '|' + "\\\\| (?![\"]))*[>])") : Pattern.compile("^(?:[<](?:[^<> \\t\\n\\\\\\x00]|" + this.ESCAPED_CHAR + '|' + "\\\\)*[>])");
        this.LINK_TITLE_STRING = "(?:\"(" + this.ESCAPED_CHAR + "|[^\"\\x00])*\"" + '|' + "'(" + this.ESCAPED_CHAR + "|[^'\\x00])*'" + '|' + "\\((" + this.ESCAPED_CHAR + "|[^)\\x00])*\\))";
        this.LINK_TITLE = Pattern.compile("^" + this.LINK_TITLE_STRING);
        this.REG_CHAR = "[^\\\\()" + this.EXCLUDED_0_TO_SPACE + "]";
        this.REG_CHAR_PARENS = "[^\\\\" + this.EXCLUDED_0_TO_SPACE + "]";
        this.REG_CHAR_SP = "[^\\\\()" + this.EXCLUDED_0_TO_SPACE + "]| (?!\")";
        this.REG_CHAR_SP_PARENS = "[^\\\\" + this.EXCLUDED_0_TO_SPACE + "]| (?!\")";
        this.IN_PARENS_NOSP = "\\((" + this.REG_CHAR + '|' + this.ESCAPED_CHAR + ")*\\)";
        this.IN_PARENS_W_SP = "\\((" + this.REG_CHAR_SP + '|' + this.ESCAPED_CHAR + ")*\\)";
        this.IN_MATCHED_PARENS_NOSP = "\\((" + this.REG_CHAR + '|' + this.ESCAPED_CHAR + ")*\\)";
        this.IN_MATCHED_PARENS_W_SP = "\\((" + this.REG_CHAR_SP + '|' + this.ESCAPED_CHAR + ")*\\)";
        this.IN_BRACES_W_SP = "\\{\\{(?:[^{}\\\\" + this.EXCLUDED_0_TO_SPACE + "]| |\t)*\\}\\}";
        this.LINK_DESTINATION = Pattern.compile("^(?:" + (Parser.PARSE_JEKYLL_MACROS_IN_URLS.getFrom(options) != false ? this.IN_BRACES_W_SP + "|" : "") + (Parser.SPACE_IN_LINK_URLS.getFrom(options) != false ? "(?:" + this.REG_CHAR_SP + ")+|" : this.REG_CHAR + "+|") + this.ESCAPED_CHAR + "|\\\\|" + (Parser.SPACE_IN_LINK_URLS.getFrom(options) != false ? this.IN_PARENS_W_SP : this.IN_PARENS_NOSP) + ")*");
        this.LINK_DESTINATION_MATCHED_PARENS = Pattern.compile("^(?:" + (Parser.PARSE_JEKYLL_MACROS_IN_URLS.getFrom(options) != false ? this.IN_BRACES_W_SP + "|" : "") + (Parser.SPACE_IN_LINK_URLS.getFrom(options) != false ? "(?:" + this.REG_CHAR_SP + ")+|" : this.REG_CHAR + "+|") + this.ESCAPED_CHAR + "|\\\\|\\(|\\))*");
        this.LINK_DESTINATION_MATCHED_PARENS_NOSP = Pattern.compile("^(?:" + (Parser.PARSE_JEKYLL_MACROS_IN_URLS.getFrom(options) != false ? this.IN_BRACES_W_SP + "|" : "") + this.REG_CHAR + "+|" + this.ESCAPED_CHAR + "|\\\\|\\(|\\))*");
        this.HTMLCOMMENT = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
        this.PROCESSINGINSTRUCTION = "[<][?].*?[?][>]";
        this.DECLARATION = "<![A-Z" + this.ADDITIONAL_CHARS + "]+\\s+[^>]*>";
        this.CDATA = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
        this.ENTITY = "&(?:#x[a-f0-9" + this.ADDITIONAL_CHARS + "]{1,8}|#[0-9]{1,8}|[a-z" + this.ADDITIONAL_CHARS + "][a-z0-9" + this.ADDITIONAL_CHARS + "]{1,31});";
        this.ENTITY_HERE = Pattern.compile('^' + this.ENTITY, 2);
        this.ASCII_PUNCTUATION = "'!\"#\\$%&\\*\\+,\\-\\./:;=\\?@\\\\\\^_`\\|~";
        this.ASCII_OPEN_PUNCTUATION = "\\(<\\[\\{";
        this.ASCII_CLOSE_PUNCTUATION = "\\)>\\]\\}";
        this.PUNCTUATION = Pattern.compile("^[" + this.ASCII_PUNCTUATION + this.ASCII_OPEN_PUNCTUATION + this.ASCII_CLOSE_PUNCTUATION + "\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]");
        this.PUNCTUATION_OPEN = Pattern.compile("^[" + this.ASCII_PUNCTUATION + this.ASCII_OPEN_PUNCTUATION + "]|[\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]&&[^" + this.ASCII_CLOSE_PUNCTUATION + "]");
        this.PUNCTUATION_CLOSE = Pattern.compile("^[" + this.ASCII_PUNCTUATION + this.ASCII_CLOSE_PUNCTUATION + "]|[\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]&&[^" + this.ASCII_OPEN_PUNCTUATION + "]");
        this.PUNCTUATION_ONLY = Pattern.compile("^[" + this.ASCII_PUNCTUATION + "\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]&&[^" + this.ASCII_OPEN_PUNCTUATION + this.ASCII_CLOSE_PUNCTUATION + "]");
        this.PUNCTUATION_OPEN_ONLY = Pattern.compile("^[" + this.ASCII_OPEN_PUNCTUATION + "]");
        this.PUNCTUATION_CLOSE_ONLY = Pattern.compile("^[" + this.ASCII_CLOSE_PUNCTUATION + "]");
        this.ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");
        this.TICKS = Pattern.compile("`+");
        this.TICKS_HERE = Pattern.compile("^`+");
        this.EMAIL_AUTOLINK = Pattern.compile("^<((?:[a-zA-Z0-9" + this.ADDITIONAL_CHARS + ".!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "](?:[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "-]{0,61}[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "])?(?:\\.[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "](?:[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "-]{0,61}[a-zA-Z0-9" + this.ADDITIONAL_CHARS + "])?)*)" + (this.htmlForTranslator ? "|(?:" + this.translationAutolinkTagPattern + ")" : "") + ")>");
        this.AUTOLINK = Pattern.compile("^<((?:[a-zA-Z][a-zA-Z0-9" + this.ADDITIONAL_CHARS + ".+-]{1,31}:[^<>" + this.EXCLUDED_0_TO_SPACE + "]*)" + (this.htmlForTranslator ? "|(?:" + this.translationAutolinkTagPattern + ")" : "") + ")>");
        this.WWW_AUTOLINK = Pattern.compile("^<((?:w" + this.ADDITIONAL_CHARS + "?){3,3}\\.[^<>" + this.EXCLUDED_0_TO_SPACE + "]*" + (this.htmlForTranslator ? "|(?:" + this.translationAutolinkTagPattern + ")" : "") + ")>");
        this.SPNL = Pattern.compile("^(?:[ \t])*(?:" + this.EOL + "(?:[ \t])*)?");
        this.SPNL_URL = Pattern.compile("^(?:[ \t])*" + this.EOL);
        this.SPNI = Pattern.compile("^ {0,3}");
        this.SP = Pattern.compile("^(?:[ \t])*");
        this.REST_OF_LINE = Pattern.compile("^.*" + this.EOL);
        this.UNICODE_WHITESPACE_CHAR = Pattern.compile("^[\\p{Zs}\t\r\n\f]");
        this.WHITESPACE = Pattern.compile("\\s+");
        this.FINAL_SPACE = Pattern.compile(" *$");
        this.LINE_END = Pattern.compile("^[ \t]*(?:" + this.EOL + "|$)");
        this.TAGNAME = "[A-Za-z" + this.ADDITIONAL_CHARS + "][A-Za-z0-9" + this.ADDITIONAL_CHARS + "-]*";
        this.ATTRIBUTENAME = "[a-zA-Z" + this.ADDITIONAL_CHARS + "_:][a-zA-Z0-9" + this.ADDITIONAL_CHARS + ":._-]*";
        this.UNQUOTEDVALUE = "[^\"'=<>{}`" + this.EXCLUDED_0_TO_SPACE + "]+";
        this.SINGLEQUOTEDVALUE = "'[^']*'";
        this.DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
        this.ATTRIBUTEVALUE = "(?:" + this.UNQUOTEDVALUE + "|" + this.SINGLEQUOTEDVALUE + "|" + this.DOUBLEQUOTEDVALUE + ")";
        this.ATTRIBUTEVALUESPEC = "(?:\\s*=\\s*" + this.ATTRIBUTEVALUE + ")";
        this.ATTRIBUTE = "(?:\\s+" + this.ATTRIBUTENAME + this.ATTRIBUTEVALUESPEC + "?)";
        this.OPENTAG = "<" + this.TAGNAME + this.ATTRIBUTE + "*\\s*/?>";
        this.CLOSETAG = "</" + this.TAGNAME + "\\s*[>]";
        this.HTMLTAG = "(?:" + this.OPENTAG + "|" + this.CLOSETAG + "|" + this.HTMLCOMMENT + "|" + this.PROCESSINGINSTRUCTION + "|" + this.DECLARATION + "|" + this.CDATA + (this.htmlForTranslator ? "|<(?:" + this.translationHtmlInlineTagPattern + ")>|</(?:" + this.translationHtmlInlineTagPattern + ")>" : "") + ")";
        this.HTML_TAG = Pattern.compile('^' + this.HTMLTAG, 2);
        String itemPrefixChars = Parser.LISTS_ITEM_PREFIX_CHARS.getFrom(options);
        this.LIST_ITEM_MARKER = Parser.LISTS_ITEM_MARKER_SPACE.getFrom(options).booleanValue() ? (Parser.LISTS_ORDERED_ITEM_DOT_ONLY.getFrom(options).booleanValue() ? Pattern.compile("^([\\Q" + itemPrefixChars + "\\E])(?=[ \t])|^(\\d{1,9})([.])(?=[ \t])") : Pattern.compile("^([\\Q" + itemPrefixChars + "\\E])(?=[ \t])|^(\\d{1,9})([.)])(?=[ \t])")) : (Parser.LISTS_ORDERED_ITEM_DOT_ONLY.getFrom(options) != false ? Pattern.compile("^([\\Q" + itemPrefixChars + "\\E])(?= |\t|$)|^(\\d{1,9})([.])(?= |\t|$)") : Pattern.compile("^([\\Q" + itemPrefixChars + "\\E])(?= |\t|$)|^(\\d{1,9})([.)])(?= |\t|$)"));
        this.CODE_BLOCK_INDENT = Parser.CODE_BLOCK_INDENT.getFrom(options);
        this.INVALID_LINK_CHARS = " \t";
    }

    public String EXCLUDED_0_TO_SPACE() {
        return this.intellijDummyIdentifier ? "\u0000-\u001e " : "\u0000- ";
    }

    public String ADDITIONAL_CHARS() {
        return this.intellijDummyIdentifier ? INTELLIJ_DUMMY_IDENTIFIER : "";
    }

    public String ADDITIONAL_CHARS_SET(String quantifier) {
        return this.intellijDummyIdentifier ? "[\u001f]" + quantifier : "";
    }

    public static int columnsToNextTabStop(int column) {
        return 4 - column % 4;
    }

    public static int findLineBreak(CharSequence s, int startIndex) {
        for (int i = startIndex; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s) {
        return Parsing.findNonSpace(s, 0) == -1;
    }

    public static boolean isLetter(CharSequence s, int index) {
        int codePoint = Character.codePointAt(s, index);
        return Character.isLetter(codePoint);
    }

    public static boolean isSpaceOrTab(CharSequence s, int index) {
        if (index < s.length()) {
            switch (s.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    private static int findNonSpace(CharSequence s, int startIndex) {
        block3: for (int i = startIndex; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return -1;
    }
}

