/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormatterSubContext;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.formatter.TranslationHandlerFactory;
import com.vladsch.flexmark.formatter.TranslationPlaceholderGenerator;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.formatter.internal.FormatterOptions;
import com.vladsch.flexmark.formatter.internal.TranslationHandlerImpl;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGeneratorFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.IRender;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.DynamicDefaultKey;
import com.vladsch.flexmark.util.collection.NodeCollectingVisitor;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.ScopedDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Formatter
implements IRender {
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey<Integer>("FORMAT_FLAGS", 0);
    public static final int FORMAT_CONVERT_TABS = 1;
    public static final int FORMAT_COLLAPSE_WHITESPACE = 2;
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = 4;
    public static final int FORMAT_ALL_OPTIONS = 7;
    public static final DataKey<Integer> MAX_BLANK_LINES = new DataKey<Integer>("MAX_BLANK_LINES", 2);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = new DataKey<Integer>("MAX_TRAILING_BLANK_LINES", 1);
    public static final DataKey<DiscretionaryText> SPACE_AFTER_ATX_MARKER = new DataKey<DiscretionaryText>("SPACE_AFTER_ATX_MARKER", DiscretionaryText.ADD);
    public static final DataKey<Boolean> SETEXT_HEADER_EQUALIZE_MARKER = new DataKey<Boolean>("SETEXT_HEADER_EQUALIZE_MARKER", true);
    public static final DataKey<EqualizeTrailingMarker> ATX_HEADER_TRAILING_MARKER = new DataKey<EqualizeTrailingMarker>("ATX_HEADER_TRAILING_MARKER", EqualizeTrailingMarker.AS_IS);
    public static final DataKey<String> THEMATIC_BREAK = new DataKey<String>("THEMATIC_BREAK", (String)null);
    public static final DataKey<Boolean> BLOCK_QUOTE_BLANK_LINES = new DataKey<Boolean>("BLOCK_QUOTE_BLANK_LINES", true);
    public static final DataKey<BlockQuoteMarker> BLOCK_QUOTE_MARKERS = new DataKey<BlockQuoteMarker>("BLOCK_QUOTE_MARKERS", BlockQuoteMarker.ADD_COMPACT_WITH_SPACE);
    public static final DataKey<Boolean> INDENTED_CODE_MINIMIZE_INDENT = new DataKey<Boolean>("INDENTED_CODE_MINIMIZE_INDENT", true);
    public static final DataKey<Boolean> FENCED_CODE_MINIMIZE_INDENT = new DataKey<Boolean>("FENCED_CODE_MINIMIZE_INDENT", true);
    public static final DataKey<Boolean> FENCED_CODE_MATCH_CLOSING_MARKER = new DataKey<Boolean>("FENCED_CODE_MATCH_CLOSING_MARKER", true);
    public static final DataKey<Boolean> FENCED_CODE_SPACE_BEFORE_INFO = new DataKey<Boolean>("FENCED_CODE_SPACE_BEFORE_INFO", false);
    public static final DataKey<Integer> FENCED_CODE_MARKER_LENGTH = new DataKey<Integer>("FENCED_CODE_MARKER_LENGTH", 3);
    public static final DataKey<CodeFenceMarker> FENCED_CODE_MARKER_TYPE = new DataKey<CodeFenceMarker>("FENCED_CODE_MARKER_TYPE", CodeFenceMarker.ANY);
    public static final DataKey<Boolean> LIST_ADD_BLANK_LINE_BEFORE = new DataKey<Boolean>("LIST_ADD_BLANK_LINE_BEFORE", false);
    public static final DataKey<Boolean> LIST_RENUMBER_ITEMS = new DataKey<Boolean>("LIST_RENUMBER_ITEMS", true);
    public static final DataKey<Boolean> LIST_REMOVE_EMPTY_ITEMS = new DataKey<Boolean>("LIST_REMOVE_EMPTY_ITEMS", false);
    public static final DataKey<ListBulletMarker> LIST_BULLET_MARKER = new DataKey<ListBulletMarker>("LIST_BULLET_MARKER", ListBulletMarker.ANY);
    public static final DataKey<ListNumberedMarker> LIST_NUMBERED_MARKER = new DataKey<ListNumberedMarker>("LIST_NUMBERED_MARKER", ListNumberedMarker.ANY);
    public static final DataKey<ListSpacing> LIST_SPACING = new DataKey<ListSpacing>("LIST_SPACING", ListSpacing.AS_IS);
    public static final DataKey<ElementPlacement> REFERENCE_PLACEMENT = new DataKey<ElementPlacement>("REFERENCE_PLACEMENT", ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> REFERENCE_SORT = new DataKey<ElementPlacementSort>("REFERENCE_SORT", ElementPlacementSort.AS_IS);
    public static final DataKey<Boolean> KEEP_IMAGE_LINKS_AT_START = new DataKey<Boolean>("KEEP_IMAGE_LINKS_AT_START", false);
    public static final DataKey<Boolean> KEEP_EXPLICIT_LINKS_AT_START = new DataKey<Boolean>("KEEP_EXPLICIT_LINKS_AT_START", false);
    public static final DataKey<Boolean> OPTIMIZED_INLINE_RENDERING = new DataKey<Boolean>("OPTIMIZED_INLINE_RENDERING", false);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = TableFormatOptions.FORMAT_CHAR_WIDTH_PROVIDER;
    @Deprecated
    public static final DataKey<CharWidthProvider> CHAR_WIDTH_PROVIDER = TableFormatOptions.FORMAT_CHAR_WIDTH_PROVIDER;
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = TableFormatOptions.FORMAT_TABLE_CAPTION_SPACES;
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = TableFormatOptions.FORMAT_TABLE_INDENT_PREFIX;
    public static final DataKey<ParserEmulationProfile> FORMATTER_EMULATION_PROFILE = new DynamicDefaultKey<ParserEmulationProfile>("FORMATTER_EMULATION_PROFILE", Parser.PARSER_EMULATION_PROFILE);
    public static final DataKey<String> TRANSLATION_ID_FORMAT = new DataKey<String>("TRANSLATION_ID_FORMAT", "_%d_");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_PREFIX = new DataKey<String>("TRANSLATION_HTML_BLOCK_PREFIX", "_");
    public static final DataKey<String> TRANSLATION_EXCLUDE_PATTERN = new DataKey<String>("TRANSLATION_EXCLUDE_PATTERN", "^[^\\p{IsAlphabetic}]*$");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_TAG_PATTERN = Parser.TRANSLATION_HTML_BLOCK_TAG_PATTERN;
    public static final DataKey<String> TRANSLATION_HTML_INLINE_TAG_PATTERN = Parser.TRANSLATION_HTML_INLINE_TAG_PATTERN;
    public static final DataKey<Boolean> KEEP_HARD_LINE_BREAKS = new DataKey<Boolean>("KEEP_HARD_LINE_BREAKS", true);
    public static final DataKey<Boolean> KEEP_SOFT_LINE_BREAKS = new DataKey<Boolean>("KEEP_SOFT_LINE_BREAKS", true);
    public static final DataKey<Boolean> APPEND_TRANSFERRED_REFERENCES = new DataKey<Boolean>("APPEND_TRANSFERRED_REFERENCES", false);
    final List<NodeFormatterFactory> nodeFormatterFactories;
    final FormatterOptions formatterOptions;
    private final DataHolder options;
    private final Builder builder;
    private static final Iterator<? extends Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    public static final Iterable<? extends Node> NULL_ITERABLE = new Iterable<Node>(){

        @Override
        public Iterator<Node> iterator() {
            return null;
        }
    };

    private Formatter(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet(builder);
        this.formatterOptions = new FormatterOptions(this.options);
        this.nodeFormatterFactories = new ArrayList<NodeFormatterFactory>(builder.nodeFormatterFactories.size() + 1);
        this.nodeFormatterFactories.addAll(builder.nodeFormatterFactories);
        this.nodeFormatterFactories.add(new NodeFormatterFactory(){

            @Override
            public NodeFormatter create(DataHolder options) {
                return new CoreNodeFormatter(options);
            }
        });
    }

    public TranslationHandler getTranslationHandler(TranslationHandlerFactory translationHandlerFactory, HtmlIdGeneratorFactory idGeneratorFactory) {
        return translationHandlerFactory.create(this.options, this.formatterOptions, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler(HtmlIdGeneratorFactory idGeneratorFactory) {
        return new TranslationHandlerImpl(this.options, this.formatterOptions, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler() {
        return new TranslationHandlerImpl(this.options, this.formatterOptions, new HeaderIdGenerator.Factory());
    }

    @Override
    public DataHolder getOptions() {
        return new DataSet(this.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    @Override
    public void render(Node node, Appendable output) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument(), null);
        renderer.render(node);
        renderer.flush(this.formatterOptions.maxTrailingBlankLines);
    }

    public void render(Node node, Appendable output, int maxTrailingBlankLines) {
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument(), null);
        renderer.render(node);
        renderer.flush(maxTrailingBlankLines);
    }

    @Override
    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    public void translationRender(Node node, Appendable output, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        translationHandler.setRenderPurpose(renderPurpose);
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument(), translationHandler);
        renderer.render(node);
        renderer.flush(this.formatterOptions.maxTrailingBlankLines);
    }

    public void translationRender(Node node, Appendable output, int maxTrailingBlankLines, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        translationHandler.setRenderPurpose(renderPurpose);
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(output, this.formatterOptions.formatFlags), node.getDocument(), translationHandler);
        renderer.render(node);
        renderer.flush(maxTrailingBlankLines);
    }

    public String translationRender(Node node, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        StringBuilder sb = new StringBuilder();
        this.translationRender(node, sb, translationHandler, renderPurpose);
        return sb.toString();
    }

    @Override
    public Formatter withOptions(DataHolder options) {
        return options == null ? this : new Formatter(new Builder(this.builder, options));
    }

    private class MainNodeFormatter
    extends NodeFormatterSubContext {
        private final Document document;
        private final Map<Class<?>, NodeFormattingHandler> renderers;
        private final SubClassingBag<Node> collectedNodes;
        private final List<PhasedNodeFormatter> phasedFormatters;
        private final Set<FormattingPhase> renderingPhases;
        private final DataHolder options;
        private FormattingPhase phase;
        final TranslationHandler myTranslationHandler;

        MainNodeFormatter(DataHolder options, MarkdownWriter out, Document document, TranslationHandler translationHandler) {
            super(out);
            this.myTranslationHandler = translationHandler;
            this.options = new ScopedDataSet(document, options);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<FormattingPhase>(FormattingPhase.values().length);
            HashSet<Class> collectNodeTypes = new HashSet<Class>(100);
            this.phasedFormatters = new ArrayList<PhasedNodeFormatter>(Formatter.this.nodeFormatterFactories.size());
            out.setContext(this);
            for (int i = Formatter.this.nodeFormatterFactories.size() - 1; i >= 0; --i) {
                NodeFormatterFactory nodeFormatterFactory = Formatter.this.nodeFormatterFactories.get(i);
                NodeFormatter nodeFormatter = nodeFormatterFactory.create(this.options);
                Set<NodeFormattingHandler<?>> formattingHandlers = nodeFormatter.getNodeFormattingHandlers();
                if (formattingHandlers == null) continue;
                for (NodeFormattingHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getNodeType(), nodeType);
                }
                Set<Class<?>> nodeClasses = nodeFormatter.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if (!(nodeFormatter instanceof PhasedNodeFormatter)) continue;
                Set<FormattingPhase> phases = ((PhasedNodeFormatter)nodeFormatter).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeFormatter)nodeFormatter);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect(document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
        }

        @Override
        public RenderPurpose getRenderPurpose() {
            return this.myTranslationHandler == null ? RenderPurpose.FORMAT : this.myTranslationHandler.getRenderPurpose();
        }

        @Override
        public boolean isTransformingText() {
            return this.myTranslationHandler != null && this.myTranslationHandler.isTransformingText();
        }

        @Override
        public CharSequence transformNonTranslating(CharSequence prefix, CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
            return this.myTranslationHandler == null ? nonTranslatingText : this.myTranslationHandler.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
        }

        @Override
        public CharSequence transformTranslating(CharSequence prefix, CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
            return this.myTranslationHandler == null ? translatingText : this.myTranslationHandler.transformTranslating(prefix, translatingText, suffix, suffix2);
        }

        @Override
        public CharSequence transformAnchorRef(CharSequence pageRef, CharSequence anchorRef) {
            return this.myTranslationHandler == null ? anchorRef : this.myTranslationHandler.transformAnchorRef(pageRef, anchorRef);
        }

        @Override
        public void translatingSpan(TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.translatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void nonTranslatingSpan(TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.nonTranslatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void translatingRefTargetSpan(Node target, TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.translatingRefTargetSpan(target, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public MutableDataHolder getTranslationStore() {
            if (this.myTranslationHandler != null) {
                return this.myTranslationHandler.getTranslationStore();
            }
            return this.document;
        }

        @Override
        public void customPlaceholderFormat(TranslationPlaceholderGenerator generator, TranslatingSpanRender render) {
            if (this.myTranslationHandler != null) {
                this.myTranslationHandler.customPlaceholderFormat(generator, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public FormatterOptions getFormatterOptions() {
            return Formatter.this.formatterOptions;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public FormattingPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(Node node) {
            this.renderNode(node, this);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        @Override
        public NodeFormatterContext getSubContext(Appendable out) {
            MarkdownWriter writer = new MarkdownWriter(out, this.getMarkdown().getOptions());
            writer.setContext(this);
            return new SubNodeFormatter(this, writer);
        }

        void renderNode(Node node, NodeFormatterSubContext subContext) {
            if (node instanceof Document) {
                if (this.myTranslationHandler != null) {
                    this.myTranslationHandler.beginRendering((Document)node, subContext, subContext.markdown);
                }
                for (FormattingPhase phase : FormattingPhase.values()) {
                    if (phase != FormattingPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == FormattingPhase.DOCUMENT) {
                        NodeFormattingHandler nodeRenderer = this.renderers.get(node.getClass());
                        if (nodeRenderer == null) continue;
                        subContext.renderingNode = node;
                        nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                        subContext.renderingNode = null;
                        continue;
                    }
                    for (PhasedNodeFormatter phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        subContext.renderingNode = node;
                        phasedFormatter.renderDocument(subContext, subContext.markdown, (Document)node, phase);
                        subContext.renderingNode = null;
                    }
                }
            } else {
                NodeFormattingHandler nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(Node.class);
                }
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    subContext.renderingNode = node;
                    nodeRenderer.render(node, (NodeFormatterContext)subContext, subContext.markdown);
                    subContext.renderingNode = oldNode;
                } else {
                    throw new IllegalStateException("Core Node Formatter should implement generic Node renderer");
                }
            }
        }

        @Override
        public void renderChildren(Node parent) {
            this.renderChildrenNode(parent, this);
        }

        protected void renderChildrenNode(Node parent, NodeFormatterSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeFormatter
        extends NodeFormatterSubContext
        implements NodeFormatterContext {
            private final MainNodeFormatter myMainNodeRenderer;

            public SubNodeFormatter(MainNodeFormatter mainNodeRenderer, MarkdownWriter out) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
            }

            @Override
            public MutableDataHolder getTranslationStore() {
                return this.myMainNodeRenderer.getTranslationStore();
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            public FormatterOptions getFormatterOptions() {
                return this.myMainNodeRenderer.getFormatterOptions();
            }

            @Override
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            public FormattingPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public Node getCurrentNode() {
                return this.myMainNodeRenderer.getCurrentNode();
            }

            @Override
            public NodeFormatterContext getSubContext(Appendable out) {
                MarkdownWriter htmlWriter = new MarkdownWriter(out, this.markdown.getOptions());
                htmlWriter.setContext(this);
                return new SubNodeFormatter(this.myMainNodeRenderer, htmlWriter);
            }

            @Override
            public void renderChildren(Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            public MarkdownWriter getMarkdown() {
                return this.markdown;
            }

            @Override
            public RenderPurpose getRenderPurpose() {
                return this.myMainNodeRenderer.getRenderPurpose();
            }

            @Override
            public boolean isTransformingText() {
                return this.myMainNodeRenderer.isTransformingText();
            }

            @Override
            public CharSequence transformNonTranslating(CharSequence prefix, CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
            }

            @Override
            public CharSequence transformTranslating(CharSequence prefix, CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformTranslating(prefix, translatingText, suffix, suffix2);
            }

            @Override
            public CharSequence transformAnchorRef(CharSequence pageRef, CharSequence anchorRef) {
                return this.myMainNodeRenderer.transformAnchorRef(pageRef, anchorRef);
            }

            @Override
            public void translatingSpan(TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingSpan(render);
            }

            @Override
            public void nonTranslatingSpan(TranslatingSpanRender render) {
                this.myMainNodeRenderer.nonTranslatingSpan(render);
            }

            @Override
            public void translatingRefTargetSpan(Node target, TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingRefTargetSpan(target, render);
            }

            @Override
            public void customPlaceholderFormat(TranslationPlaceholderGenerator generator, TranslatingSpanRender render) {
                this.myMainNodeRenderer.customPlaceholderFormat(generator, render);
            }
        }
    }

    public static interface FormatterExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends MutableDataSet {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeFormatterFactory> nodeFormatterFactories = new ArrayList<NodeFormatterFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        private final HashSet<FormatterExtension> loadedExtensions = new HashSet();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            if (options.contains(Parser.EXTENSIONS)) {
                this.extensions(this.get(Parser.EXTENSIONS));
            }
        }

        public Builder(Builder other) {
            super(other);
            this.attributeProviderFactories.addAll(other.attributeProviderFactories);
            this.nodeFormatterFactories.addAll(other.nodeFormatterFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
            this.loadedExtensions.addAll(other.loadedExtensions);
            this.htmlIdGeneratorFactory = other.htmlIdGeneratorFactory;
        }

        public Builder(Builder other, DataHolder options) {
            super(other);
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (Extension extension : this.get(Parser.EXTENSIONS)) {
                extensions.add(extension);
            }
            if (options != null) {
                for (DataKey key : options.keySet()) {
                    if (key == Parser.EXTENSIONS) {
                        for (Extension extension : options.get(Parser.EXTENSIONS)) {
                            extensions.add(extension);
                        }
                        continue;
                    }
                    this.set(key, options.get(key));
                }
            }
            this.set((DataKey)Parser.EXTENSIONS, extensions);
            this.extensions(extensions);
        }

        public Formatter build() {
            return new Formatter(this);
        }

        public Builder nodeFormatterFactory(NodeFormatterFactory nodeFormatterFactory) {
            this.nodeFormatterFactories.add(nodeFormatterFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            FormatterExtension formatterExtension;
            for (Extension extension : extensions) {
                if (!(extension instanceof FormatterExtension) || this.loadedExtensions.contains(extension)) continue;
                formatterExtension = (FormatterExtension)extension;
                formatterExtension.rendererOptions(this);
            }
            for (Extension extension : extensions) {
                if (!(extension instanceof FormatterExtension) || this.loadedExtensions.contains(extension)) continue;
                formatterExtension = (FormatterExtension)extension;
                formatterExtension.extend(this);
                this.loadedExtensions.add(formatterExtension);
            }
            return this;
        }
    }
}

