/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableColumnSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableParserOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.CharacterNodeFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.ReferencePreProcessorFactory;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeIterator;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class TableParagraphPreProcessor
implements ParagraphPreProcessor {
    private static BitSet pipeCharacters = new BitSet();
    private static BitSet separatorCharacters = new BitSet();
    private static HashMap<Character, CharacterNodeFactory> pipeNodeMap;
    private static HashMap<Character, CharacterNodeFactory> pipeIntelliJNodeMap;
    private final TableParserOptions options;
    Pattern TABLE_HEADER_SEPARATOR;

    public static ParagraphPreProcessorFactory Factory() {
        return new ParagraphPreProcessorFactory(){

            @Override
            public boolean affectsGlobalScope() {
                return false;
            }

            @Override
            public Set<Class<? extends ParagraphPreProcessorFactory>> getAfterDependents() {
                HashSet<Class<? extends ParagraphPreProcessorFactory>> set = new HashSet<Class<? extends ParagraphPreProcessorFactory>>();
                set.add(ReferencePreProcessorFactory.class);
                return set;
            }

            @Override
            public Set<Class<? extends ParagraphPreProcessorFactory>> getBeforeDependents() {
                return null;
            }

            @Override
            public ParagraphPreProcessor create(ParserState state) {
                return new TableParagraphPreProcessor(state.getProperties());
            }
        };
    }

    public static Pattern getTableHeaderSeparator(int minColumnDashes, String intellijDummyIdentifier) {
        int minCol = minColumnDashes >= 1 ? minColumnDashes : 1;
        int minColDash = minColumnDashes >= 2 ? minColumnDashes - 1 : 1;
        int minColDashes = minColumnDashes >= 3 ? minColumnDashes - 2 : 1;
        String COL = String.format("(?:\\s*-{%d,}\\s*|\\s*:-{%d,}\\s*|\\s*-{%d,}:\\s*|\\s*:-{%d,}:\\s*)", minCol, minColDash, minColDash, minColDashes);
        boolean noIntelliJ = intellijDummyIdentifier.isEmpty();
        String add = noIntelliJ ? "" : "\u001f";
        String sp = noIntelliJ ? "\\s" : "(?:\\s" + add + "?)";
        String ds = noIntelliJ ? "-" : "(?:-" + add + "?)";
        String pipe = noIntelliJ ? "\\|" : "(?:" + add + "?\\|" + add + "?)";
        String regex = "\\|" + COL + "\\|?\\s*|" + COL + "\\|\\s*|\\|?(?:" + COL + "\\|)+" + COL + "\\|?\\s*";
        String withIntelliJ = regex.replace("\\s", sp).replace("\\|", pipe).replace("-", ds);
        return Pattern.compile(withIntelliJ);
    }

    private TableParagraphPreProcessor(DataHolder options) {
        this.options = new TableParserOptions(options);
        this.TABLE_HEADER_SEPARATOR = TableParagraphPreProcessor.getTableHeaderSeparator(this.options.minSeparatorDashes, "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int preProcessBlock(Paragraph block, ParserState state) {
        void var14_19;
        InlineParser inlineParser = state.getInlineParser();
        ArrayList<BasedSequence> tableLines = new ArrayList<BasedSequence>();
        int separatorLineNumber = -1;
        BasedSequence separatorLine = null;
        int blockIndent = block.getLineIndent(0);
        BasedSequence captionLine = null;
        BitSet separators = separatorCharacters;
        HashMap<Character, CharacterNodeFactory> nodeMap = pipeNodeMap;
        int i = 0;
        for (BasedSequence basedSequence : block.getContentLines()) {
            BasedSequence fullRowLine;
            int n = tableLines.size();
            if (separatorLineNumber == -1 && n > this.options.maxHeaderRows) {
                return 0;
            }
            if (basedSequence.indexOf('|') < 0) {
                BasedSequence trimmed;
                if (separatorLineNumber == -1) {
                    return 0;
                }
                if (!this.options.withCaption || !(trimmed = basedSequence.trim()).startsWith("[") || !trimmed.endsWith("]")) break;
                captionLine = trimmed;
                break;
            }
            BasedSequence basedSequence2 = fullRowLine = block.getLineIndent(n) <= blockIndent ? basedSequence.trimEOL() : basedSequence.baseSubSequence(basedSequence.getStartOffset() - (block.getLineIndent(n) - blockIndent), basedSequence.getEndOffset() - basedSequence.eolLength());
            if (separatorLineNumber == -1) {
                if (n >= this.options.minHeaderRows && this.TABLE_HEADER_SEPARATOR.matcher(basedSequence).matches()) {
                    if (fullRowLine.charAt(0) != ' ' && fullRowLine.charAt(0) != '\t' || basedSequence.charAt(0) != '|') {
                        separatorLineNumber = n;
                        separatorLine = basedSequence;
                    } else if (fullRowLine.charAt(0) == ' ' || fullRowLine.charAt(0) == '\t') {
                        block.setHasTableSeparator(true);
                    }
                }
            } else if (this.options.multiLineRows) {
                // empty if block
            }
            tableLines.add(basedSequence);
            ++i;
        }
        if (separatorLineNumber == -1) {
            return 0;
        }
        ArrayList<Object> tableRows = new ArrayList<Object>();
        for (BasedSequence basedSequence : tableLines) {
            int n;
            List<Node> sepList;
            int rowNumber = tableRows.size();
            BasedSequence fullRowLine = block.getLineIndent(rowNumber) <= blockIndent ? basedSequence.trimEOL() : basedSequence.baseSubSequence(basedSequence.getStartOffset() - (block.getLineIndent(rowNumber) - blockIndent), basedSequence.getEndOffset() - basedSequence.eolLength());
            boolean isSeparator = rowNumber == separatorLineNumber;
            TableRow tableRow = new TableRow(fullRowLine);
            if (isSeparator) {
                TableSeparatorRow fakeRow = new TableSeparatorRow(fullRowLine);
                sepList = inlineParser.parseCustom(fullRowLine, fakeRow, separators, nodeMap);
                tableRow.takeChildren(fakeRow);
                n = 0;
            } else {
                sepList = inlineParser.parseCustom(fullRowLine, tableRow, pipeCharacters, pipeNodeMap);
                n = rowNumber < separatorLineNumber ? rowNumber + 1 : rowNumber - separatorLineNumber;
                sepList = this.cleanUpInlinedSeparators(inlineParser, tableRow, sepList);
            }
            if (sepList == null) {
                if (rowNumber > separatorLineNumber) break;
                return 0;
            }
            tableRow.setRowNumber(n);
            tableRows.add(tableRow);
        }
        TableBlock tableBlock = new TableBlock(tableLines.subList(0, tableRows.size()));
        TableHead tableHead = new TableHead(((BasedSequence)tableLines.get(0)).subSequence(0, 0));
        tableBlock.appendChild(tableHead);
        List<TableCell.Alignment> alignments = this.parseAlignment(separatorLine);
        int rowNumber = 0;
        int separatorColumns = alignments.size();
        for (TableRow tableRow : tableRows) {
            TableCell tableCell;
            if (rowNumber == separatorLineNumber) {
                var14_19.setCharsFromContent();
                TableSeparator tableSeparator = new TableSeparator();
                tableBlock.appendChild(tableSeparator);
            } else if (rowNumber == separatorLineNumber + 1) {
                var14_19.setCharsFromContent();
                TableBody tableBody = new TableBody();
                tableBlock.appendChild(tableBody);
            }
            boolean firstCell = true;
            int cellCount = 0;
            NodeIterator nodes = new NodeIterator(tableRow.getFirstChild());
            TableRow newTableRow = new TableRow(tableRow.getChars());
            newTableRow.setRowNumber(tableRow.getRowNumber());
            int accumulatedSpanOffset = 0;
            while (nodes.hasNext()) {
                if (cellCount >= separatorColumns && this.options.discardExtraColumns) {
                    if (!this.options.headerSeparatorColumnMatch || rowNumber >= separatorLineNumber) break;
                    return 0;
                }
                tableCell = new TableCell();
                if (firstCell && nodes.peek() instanceof TableColumnSeparator) {
                    Node columnSep = nodes.next();
                    tableCell.setOpeningMarker(columnSep.getChars());
                    columnSep.unlink();
                    firstCell = false;
                }
                TableCell.Alignment alignment = cellCount + accumulatedSpanOffset < separatorColumns ? alignments.get(cellCount + accumulatedSpanOffset) : null;
                tableCell.setHeader(rowNumber < separatorLineNumber);
                tableCell.setAlignment(alignment);
                while (nodes.hasNext() && !(nodes.peek() instanceof TableColumnSeparator)) {
                    tableCell.appendChild(nodes.next());
                }
                BasedSequence closingMarker = null;
                int span = 1;
                while (nodes.hasNext() && nodes.peek() instanceof TableColumnSeparator) {
                    if (closingMarker == null) {
                        closingMarker = nodes.next().getChars();
                        if (this.options.columnSpans) continue;
                        break;
                    }
                    BasedSequence nextSep = nodes.peek().getChars();
                    if (!closingMarker.isContinuedBy(nextSep)) break;
                    closingMarker = closingMarker.spliceAtEnd(nextSep);
                    nodes.next().unlink();
                    ++span;
                }
                accumulatedSpanOffset += span - 1;
                if (closingMarker != null) {
                    tableCell.setClosingMarker(closingMarker);
                }
                tableCell.setChars(tableCell.getChildChars());
                if (this.options.trimCellWhitespace) {
                    tableCell.trimWhiteSpace();
                } else {
                    tableCell.mergeWhiteSpace();
                }
                tableCell.setText(tableCell.getChildChars());
                tableCell.setCharsFromContent();
                tableCell.setSpan(span);
                newTableRow.appendChild(tableCell);
                ++cellCount;
            }
            if (this.options.headerSeparatorColumnMatch && rowNumber < separatorLineNumber && cellCount < separatorColumns) {
                return 0;
            }
            while (this.options.appendMissingColumns && cellCount < separatorColumns) {
                tableCell = new TableCell();
                tableCell.setHeader(rowNumber < separatorLineNumber);
                tableCell.setAlignment(alignments.get(cellCount));
                newTableRow.appendChild(tableCell);
                ++cellCount;
            }
            newTableRow.setCharsFromContent();
            var14_19.appendChild(newTableRow);
            ++rowNumber;
        }
        var14_19.setCharsFromContent();
        if (var14_19 instanceof TableSeparator) {
            TableBody tableBody = new TableBody(var14_19.getChars().subSequence(var14_19.getChars().length()));
            tableBlock.appendChild(tableBody);
        }
        if (captionLine != null) {
            TableCaption caption = new TableCaption(captionLine.subSequence(0, 1), captionLine.subSequence(1, captionLine.length() - 1), captionLine.subSequence(captionLine.length() - 1));
            inlineParser.parse(caption.getText(), caption);
            caption.setCharsFromContent();
            tableBlock.appendChild(caption);
        }
        tableBlock.setCharsFromContent();
        block.insertBefore(tableBlock);
        state.blockAdded(tableBlock);
        return tableBlock.getChars().length();
    }

    List<Node> cleanUpInlinedSeparators(InlineParser inlineParser, TableRow tableRow, List<Node> sepList) {
        ArrayList<Node> removedSeparators = null;
        ArrayList<Node> mergeTextParents = null;
        for (Node node : sepList) {
            if (node.getParent() == null || node.getParent() == tableRow) continue;
            Node firstNode = node.getPrevious() instanceof WhiteSpace ? node.getPrevious() : node;
            Node lastNode = node.getNext() instanceof WhiteSpace ? node.getNext() : node;
            Text text = new Text(node.getChars().baseSubSequence(firstNode.getStartOffset(), lastNode.getEndOffset()));
            node.insertBefore(text);
            node.unlink();
            firstNode.unlink();
            lastNode.unlink();
            if (removedSeparators == null) {
                removedSeparators = new ArrayList<Node>();
                mergeTextParents = new ArrayList<Node>();
            }
            removedSeparators.add(node);
            mergeTextParents.add(text.getParent());
        }
        if (mergeTextParents != null) {
            for (Node parent : mergeTextParents) {
                inlineParser.mergeTextNodes(parent.getFirstChild(), parent.getLastChild());
            }
            if (removedSeparators.size() == sepList.size()) {
                return null;
            }
            ArrayList<Node> newSeparators = new ArrayList<Node>(sepList);
            newSeparators.removeAll(removedSeparators);
            return newSeparators;
        }
        return sepList;
    }

    private List<TableCell.Alignment> parseAlignment(BasedSequence separatorLine) {
        List<BasedSequence> parts = TableParagraphPreProcessor.split(separatorLine, false, false);
        ArrayList<TableCell.Alignment> alignments = new ArrayList<TableCell.Alignment>();
        for (BasedSequence part : parts) {
            BasedSequence trimmed = part.trim();
            boolean left = trimmed.startsWith(":");
            boolean right = trimmed.endsWith(":");
            TableCell.Alignment alignment = TableParagraphPreProcessor.getAlignment(left, right);
            alignments.add(alignment);
        }
        return alignments;
    }

    private static List<BasedSequence> split(BasedSequence input, boolean columnSpans, boolean wantPipes) {
        BasedSequence line = input.trim();
        int lineLength = line.length();
        ArrayList<BasedSequence> segments = new ArrayList<BasedSequence>();
        if (line.startsWith("|")) {
            if (wantPipes) {
                segments.add(line.subSequence(0, 1));
            }
            line = line.subSequence(1, lineLength);
            --lineLength;
        }
        boolean escape = false;
        int lastPos = 0;
        int cellChars = 0;
        block4: for (int i = 0; i < lineLength; ++i) {
            char c = line.charAt(i);
            if (escape) {
                escape = false;
                ++cellChars;
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    ++cellChars;
                    continue block4;
                }
                case '|': {
                    if (!columnSpans || lastPos < i) {
                        segments.add(line.subSequence(lastPos, i));
                    }
                    if (wantPipes) {
                        segments.add(line.subSequence(i, i + 1));
                    }
                    lastPos = i + 1;
                    cellChars = 0;
                    continue block4;
                }
                default: {
                    ++cellChars;
                }
            }
        }
        if (cellChars > 0) {
            segments.add(line.subSequence(lastPos, lineLength));
        }
        return segments;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    static {
        pipeCharacters.set(124);
        separatorCharacters.set(124);
        separatorCharacters.set(58);
        separatorCharacters.set(45);
        pipeNodeMap = new HashMap();
        pipeNodeMap.put(Character.valueOf('|'), new CharacterNodeFactory(){

            @Override
            public boolean skipNext(char c) {
                return c == ' ' || c == '\t';
            }

            @Override
            public boolean skipPrev(char c) {
                return c == ' ' || c == '\t';
            }

            @Override
            public boolean wantSkippedWhitespace() {
                return true;
            }

            @Override
            public Node create() {
                return new TableColumnSeparator();
            }
        });
        pipeIntelliJNodeMap = new HashMap();
        pipeIntelliJNodeMap.put(Character.valueOf('|'), new CharacterNodeFactory(){

            @Override
            public boolean skipNext(char c) {
                return c == ' ' || c == '\t';
            }

            @Override
            public boolean skipPrev(char c) {
                return c == ' ' || c == '\t';
            }

            @Override
            public boolean wantSkippedWhitespace() {
                return true;
            }

            @Override
            public Node create() {
                return new TableColumnSeparator();
            }
        });
    }

    private static class TableSeparatorRow
    extends TableRow
    implements DoNotDecorate {
        public TableSeparatorRow() {
        }

        public TableSeparatorRow(BasedSequence chars) {
            super(chars);
        }
    }
}

