/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DelimitedLinkNode;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkNodePostProcessor
extends NodePostProcessor {
    private static final Pattern URI_SUFFIX = Pattern.compile("\\b([a-z][a-z0-9+.-]*://\\s*)$");
    private final Pattern ignoredLinks;
    private final boolean intellijDummyIdentifier;
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.WWW, LinkType.EMAIL)).build();

    public AutolinkNodePostProcessor(Document document) {
        String ignoreLinks = AutolinkExtension.IGNORE_LINKS.getFrom(document);
        this.ignoredLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
        this.intellijDummyIdentifier = Parser.INTELLIJ_DUMMY_IDENTIFIER.getFrom(document);
    }

    public boolean isIgnoredLinkPrefix(CharSequence url) {
        if (this.ignoredLinks != null) {
            Matcher matcher = this.ignoredLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public void process(NodeTracker state, Node node) {
        if (node.getAncestorOfType(DoNotDecorate.class, DoNotLinkDecorate.class) != null) {
            return;
        }
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape(original, textMapper);
        if (this.intellijDummyIdentifier) {
            literal = Escaping.removeAll(literal, "\u001f", textMapper);
        }
        Iterable<LinkSpan> links = this.linkExtractor.extractLinks(literal);
        ArrayList<DummyLinkSpan> linksList = null;
        Matcher matcher = URI_SUFFIX.matcher(literal);
        if (matcher.find()) {
            linksList = new ArrayList<DummyLinkSpan>();
            linksList.add(new DummyLinkSpan(LinkType.URL, matcher.start(1), matcher.end(1)));
        }
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase || !(node.getParent() instanceof TextBase) ? null : (TextBase)node.getParent();
        boolean processedNode = false;
        int iMax = linksList == null ? 0 : linksList.size();
        int i = 0;
        Iterator<LinkSpan> iterator = links.iterator();
        while (true) {
            DelimitedLinkNode linkNode;
            LinkSpan link;
            if (iterator.hasNext()) {
                link = iterator.next();
            } else {
                if (i >= iMax) break;
                link = (LinkSpan)linksList.get(i++);
            }
            BasedSequence linkText = literal.subSequence(link.getBeginIndex(), link.getEndIndex()).trimEnd();
            if (this.isIgnoredLinkPrefix(linkText)) continue;
            int startOffset = textMapper.originalOffset(link.getBeginIndex());
            processedNode = true;
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore(textBase);
                state.nodeAdded(textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                if (textBase != null) {
                    textBase.appendChild(node1);
                } else {
                    node.insertBefore(node1);
                }
                state.nodeAdded(node1);
            }
            BasedSequence linkChars = linkText.baseSubSequence(linkText.getStartOffset(), linkText.getEndOffset());
            Text contentNode = new Text(linkChars);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                linkNode.setText(linkChars);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkChars);
                ((AutoLink)linkNode).setUrlChars(linkChars);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild(contentNode);
            if (textBase != null) {
                textBase.appendChild(linkNode);
            } else {
                node.insertBefore(linkNode);
            }
            state.nodeAddedWithChildren(linkNode);
            lastEscaped = textMapper.originalOffset(link.getBeginIndex() + linkText.length());
        }
        if (lastEscaped > 0 && lastEscaped != original.length()) {
            BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
            Text node1 = new Text(escapedChars);
            if (textBase != null) {
                textBase.appendChild(node1);
            } else {
                node.insertBefore(node1);
            }
            state.nodeAdded(node1);
        }
        if (processedNode) {
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(Text.class);
        }

        @Override
        public NodePostProcessor create(Document document) {
            return new AutolinkNodePostProcessor(document);
        }
    }

    private static class DummyLinkSpan
    implements LinkSpan {
        private final LinkType linkType;
        private final int beginIndex;
        private final int endIndex;

        public DummyLinkSpan(LinkType linkType, int beginIndex, int endIndex) {
            this.linkType = linkType;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public LinkType getType() {
            return this.linkType;
        }

        @Override
        public int getBeginIndex() {
            return this.beginIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

