/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.util.Consumer;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.FormattingAppendableImpl;
import java.io.IOException;

public class MarkdownWriter
implements FormattingAppendable {
    private final FormattingAppendable myAppendable;
    private NodeFormatterContext context;

    public MarkdownWriter(Appendable out) {
        this(out, 0);
    }

    public String toString() {
        return this.myAppendable.getAppendable().toString();
    }

    public MarkdownWriter(Appendable out, int formatOptions) {
        this.myAppendable = new FormattingAppendableImpl(out, formatOptions);
    }

    public void setContext(NodeFormatterContext context) {
        this.context = context;
    }

    public NodeFormatterContext getContext() {
        return this.context;
    }

    public MarkdownWriter tailBlankLine() {
        return this.tailBlankLine(1);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public MarkdownWriter tailBlankLine(int count) {
        Node node = this.context.getCurrentNode();
        if (this.isLastBlockQuoteChild(node) && this.getPushedPrefixCount() > 0) {
            this.flush(-1);
            this.popPrefix();
            this.pushPrefix();
        }
        this.blankLine(count);
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence csq) {
        return this.appendNonTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendNonTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendNonTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2, Consumer<String> placeholderConsumer) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendTranslating(CharSequence csq) {
        return this.appendTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformTranslating(prefix, csq, suffix, suffix2));
        } else {
            if (prefix != null) {
                this.append(prefix);
            }
            this.append(csq);
            if (suffix != null) {
                this.append(suffix);
            }
        }
        return this;
    }

    @Override
    public Appendable getAppendable() {
        return this.myAppendable.getAppendable();
    }

    @Override
    public boolean isPendingEOL() {
        return this.myAppendable.isPendingEOL();
    }

    @Override
    public boolean isPendingSpace() {
        return this.myAppendable.isPendingSpace();
    }

    @Override
    public boolean isPreFormatted() {
        return this.myAppendable.isPreFormatted();
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myAppendable.getIndentPrefix();
    }

    @Override
    public CharSequence getPrefix() {
        return this.myAppendable.getPrefix();
    }

    @Override
    public CharSequence getTotalIndentPrefix() {
        return this.myAppendable.getTotalIndentPrefix();
    }

    @Override
    public int getIndent() {
        return this.myAppendable.getIndent();
    }

    @Override
    public int getLineCount() {
        return this.myAppendable.getLineCount();
    }

    @Override
    public int getModCount() {
        return this.myAppendable.getModCount();
    }

    @Override
    public int offset() {
        return this.myAppendable.offset();
    }

    @Override
    public int offsetWithPending() {
        return this.myAppendable.offsetWithPending();
    }

    @Override
    public int column() {
        return this.myAppendable.column();
    }

    @Override
    public int columnWith(CharSequence csq, int start, int end) {
        return this.myAppendable.columnWith(csq, start, end);
    }

    @Override
    public int lastOffset() {
        return this.myAppendable.lastOffset();
    }

    @Override
    public int getOptions() {
        return this.myAppendable.getOptions();
    }

    @Override
    public int getPushedPrefixCount() {
        return this.myAppendable.getPushedPrefixCount();
    }

    @Override
    public int getPendingEOL() {
        return this.myAppendable.getPendingEOL();
    }

    @Override
    public IOException getIOException() {
        return this.myAppendable.getIOException();
    }

    @Override
    public String getText() {
        return this.myAppendable.getText();
    }

    @Override
    public String getText(int maxBlankLines) {
        return this.myAppendable.getText(maxBlankLines);
    }

    @Override
    public MarkdownWriter addAfterEolRunnable(int atPendingEOL, Runnable runnable) {
        this.myAppendable.addAfterEolRunnable(atPendingEOL, runnable);
        return this;
    }

    @Override
    public MarkdownWriter addLine() {
        this.myAppendable.addLine();
        return this;
    }

    @Override
    public MarkdownWriter addPrefix(CharSequence prefix) {
        this.myAppendable.addPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter append(char c) {
        this.myAppendable.append(c);
        return this;
    }

    @Override
    public MarkdownWriter append(CharSequence csq) {
        this.myAppendable.append(csq);
        return this;
    }

    @Override
    public MarkdownWriter append(CharSequence csq, int start, int end) {
        this.myAppendable.append(csq, start, end);
        return this;
    }

    @Override
    public MarkdownWriter blankLine() {
        this.myAppendable.blankLine();
        return this;
    }

    @Override
    public MarkdownWriter blankLine(int count) {
        this.myAppendable.blankLine(count);
        return this;
    }

    @Override
    public MarkdownWriter blankLineIf(boolean predicate) {
        this.myAppendable.blankLineIf(predicate);
        return this;
    }

    @Override
    public MarkdownWriter closeConditional(ConditionalFormatter closeFormatter) {
        this.myAppendable.closeConditional(closeFormatter);
        return this;
    }

    @Override
    public MarkdownWriter closePreFormatted() {
        this.myAppendable.closePreFormatted();
        return this;
    }

    @Override
    public MarkdownWriter flush() {
        this.myAppendable.flush();
        return this;
    }

    @Override
    public MarkdownWriter flushWhitespaces() {
        this.myAppendable.flushWhitespaces();
        return this;
    }

    @Override
    public MarkdownWriter flush(int maxBlankLines) {
        this.myAppendable.flush(maxBlankLines);
        return this;
    }

    @Override
    public MarkdownWriter lastOffset(Ref<Integer> refOffset) {
        this.myAppendable.lastOffset(refOffset);
        return this;
    }

    @Override
    public MarkdownWriter indent() {
        this.myAppendable.indent();
        return this;
    }

    @Override
    public MarkdownWriter line() {
        this.myAppendable.line();
        return this;
    }

    @Override
    public MarkdownWriter line(Ref<Boolean> lineRef) {
        this.myAppendable.line(lineRef);
        return this;
    }

    @Override
    public MarkdownWriter lineIf(boolean predicate) {
        this.myAppendable.lineIf(predicate);
        return this;
    }

    @Override
    public MarkdownWriter lineIf(Ref<Boolean> lineRef) {
        this.myAppendable.lineIf(lineRef);
        return this;
    }

    @Override
    public MarkdownWriter openConditional(ConditionalFormatter openFormatter) {
        this.myAppendable.openConditional(openFormatter);
        return this;
    }

    @Override
    public MarkdownWriter openPreFormatted(boolean keepIndent) {
        this.myAppendable.openPreFormatted(keepIndent);
        return this;
    }

    @Override
    public MarkdownWriter popPrefix() {
        this.myAppendable.popPrefix();
        return this;
    }

    @Override
    public MarkdownWriter pushPrefix() {
        this.myAppendable.pushPrefix();
        return this;
    }

    @Override
    public MarkdownWriter repeat(char c, int count) {
        this.myAppendable.repeat(c, count);
        return this;
    }

    @Override
    public MarkdownWriter repeat(CharSequence csq, int count) {
        this.myAppendable.repeat(csq, count);
        return this;
    }

    @Override
    public MarkdownWriter repeat(CharSequence csq, int start, int end, int count) {
        this.myAppendable.repeat(csq, start, end, count);
        return this;
    }

    @Override
    public MarkdownWriter setIndentOffset(int indentOffset) {
        this.myAppendable.setIndentOffset(indentOffset);
        return this;
    }

    @Override
    public MarkdownWriter setIndentPrefix(CharSequence prefix) {
        this.myAppendable.setIndentPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter setOptions(int options) {
        this.myAppendable.setOptions(options);
        return this;
    }

    @Override
    public MarkdownWriter setPrefix(CharSequence prefix) {
        this.myAppendable.setPrefix(prefix);
        return this;
    }

    @Override
    public MarkdownWriter unIndent() {
        this.myAppendable.unIndent();
        return this;
    }

    @Override
    public MarkdownWriter willIndent() {
        this.myAppendable.willIndent();
        return this;
    }
}

