/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceRepository;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashMap;

public class EnumeratedReferences {
    public static final String EMPTY_TYPE = "";
    private final EnumeratedReferenceRepository referenceRepository;
    private final HashMap<String, Integer> enumerationCounters;
    private final HashMap<String, Integer> enumeratedReferenceOrdinals;

    public EnumeratedReferences(DataHolder options) {
        this.referenceRepository = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom(options);
        this.enumerationCounters = new HashMap();
        this.enumeratedReferenceOrdinals = new HashMap();
    }

    public void add(String text) {
        int ordinal;
        String type = EnumeratedReferenceRepository.getType(text);
        if (!this.enumerationCounters.containsKey(type)) {
            this.enumerationCounters.put(type, 2);
            ordinal = 1;
        } else {
            ordinal = this.enumerationCounters.get(type);
            this.enumerationCounters.put(type, ordinal + 1);
        }
        this.enumeratedReferenceOrdinals.put(text, ordinal);
    }

    public int getOrdinal(String text) {
        Integer ordinal = this.enumeratedReferenceOrdinals.get(text);
        return ordinal == null ? 0 : ordinal;
    }

    public Node getFormatNode(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        return (Node)this.referenceRepository.get(type);
    }
}

