/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.formatter.internal.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;

public class FormatterOptions {
    public final boolean itemContentIndent;
    public final ParserEmulationProfile emulationProfile;
    public final boolean setextHeaderEqualizeMarker;
    public final int formatFlags;
    public final int maxBlankLines;
    public final int maxTrailingBlankLines;
    public final int minSetextMarkerLength;
    public final DiscretionaryText spaceAfterAtxMarker;
    public final EqualizeTrailingMarker atxHeaderTrailingMarker;
    public final boolean blockQuoteBlankLines;
    public final BlockQuoteMarker blockQuoteMarkers;
    public final String thematicBreak;
    public final String translationIdFormat;
    public final String translationHtmlBlockPrefix;
    public final String translationExcludePattern;
    public final String translationHtmlBlockTagPattern;
    public final String translationHtmlInlineTagPattern;
    public final boolean indentedCodeMinimizeIndent;
    public final boolean fencedCodeMinimizeIndent;
    public final boolean fencedCodeMatchClosingMarker;
    public final boolean fencedCodeSpaceBeforeInfo;
    public final int fencedCodeMarkerLength;
    public final CodeFenceMarker fencedCodeMarkerType;
    public final boolean listAddBlankLineBefore;
    public final boolean listRenumberItems;
    public final boolean listRemoveEmptyItems;
    public final ListBulletMarker listBulletMarker;
    public final ListNumberedMarker listNumberedMarker;
    public final ListSpacing listSpacing;
    public final ElementPlacement referencePlacement;
    public final ElementPlacementSort referenceSort;
    public final boolean keepImageLinksAtStart;
    public final boolean keepExplicitLinksAtStart;
    public final boolean keepHardLineBreaks;
    public final boolean keepSoftLineBreaks;
    public final boolean appendTransferredReferences;
    public final CharWidthProvider charWidthProvider;

    public FormatterOptions(DataHolder options) {
        this.emulationProfile = Formatter.FORMATTER_EMULATION_PROFILE.getFrom(options);
        this.itemContentIndent = this.emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;
        this.setextHeaderEqualizeMarker = Formatter.SETEXT_HEADER_EQUALIZE_MARKER.getFrom(options);
        this.formatFlags = Formatter.FORMAT_FLAGS.getFrom(options);
        this.maxBlankLines = Formatter.MAX_BLANK_LINES.getFrom(options);
        this.maxTrailingBlankLines = Formatter.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.minSetextMarkerLength = Parser.HEADING_SETEXT_MARKER_LENGTH.getFrom(options);
        this.spaceAfterAtxMarker = Formatter.SPACE_AFTER_ATX_MARKER.getFrom(options);
        this.atxHeaderTrailingMarker = Formatter.ATX_HEADER_TRAILING_MARKER.getFrom(options);
        this.thematicBreak = Formatter.THEMATIC_BREAK.getFrom(options);
        this.translationIdFormat = Formatter.TRANSLATION_ID_FORMAT.getFrom(options);
        this.translationHtmlBlockPrefix = Formatter.TRANSLATION_HTML_BLOCK_PREFIX.getFrom(options);
        this.translationExcludePattern = Formatter.TRANSLATION_EXCLUDE_PATTERN.getFrom(options);
        this.translationHtmlBlockTagPattern = Formatter.TRANSLATION_HTML_BLOCK_TAG_PATTERN.getFrom(options);
        this.translationHtmlInlineTagPattern = Formatter.TRANSLATION_HTML_INLINE_TAG_PATTERN.getFrom(options);
        this.blockQuoteBlankLines = Formatter.BLOCK_QUOTE_BLANK_LINES.getFrom(options);
        this.blockQuoteMarkers = Formatter.BLOCK_QUOTE_MARKERS.getFrom(options);
        this.indentedCodeMinimizeIndent = Formatter.INDENTED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMinimizeIndent = Formatter.FENCED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMatchClosingMarker = Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.getFrom(options);
        this.fencedCodeSpaceBeforeInfo = Formatter.FENCED_CODE_SPACE_BEFORE_INFO.getFrom(options);
        this.fencedCodeMarkerLength = Formatter.FENCED_CODE_MARKER_LENGTH.getFrom(options);
        this.fencedCodeMarkerType = Formatter.FENCED_CODE_MARKER_TYPE.getFrom(options);
        this.listAddBlankLineBefore = Formatter.LIST_ADD_BLANK_LINE_BEFORE.getFrom(options);
        this.listRenumberItems = Formatter.LIST_RENUMBER_ITEMS.getFrom(options);
        this.listRemoveEmptyItems = Formatter.LIST_REMOVE_EMPTY_ITEMS.getFrom(options);
        this.listBulletMarker = Formatter.LIST_BULLET_MARKER.getFrom(options);
        this.listNumberedMarker = Formatter.LIST_NUMBERED_MARKER.getFrom(options);
        this.listSpacing = Formatter.LIST_SPACING.getFrom(options);
        this.referencePlacement = Formatter.REFERENCE_PLACEMENT.getFrom(options);
        this.referenceSort = Formatter.REFERENCE_SORT.getFrom(options);
        this.keepImageLinksAtStart = Formatter.KEEP_IMAGE_LINKS_AT_START.getFrom(options);
        this.keepExplicitLinksAtStart = Formatter.KEEP_EXPLICIT_LINKS_AT_START.getFrom(options);
        this.charWidthProvider = Formatter.FORMAT_CHAR_WIDTH_PROVIDER.getFrom(options);
        this.keepHardLineBreaks = Formatter.KEEP_HARD_LINE_BREAKS.getFrom(options);
        this.keepSoftLineBreaks = Formatter.KEEP_SOFT_LINE_BREAKS.getFrom(options);
        this.appendTransferredReferences = Formatter.APPEND_TRANSFERRED_REFERENCES.getFrom(options);
    }
}

