/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal;

import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.parser.delimiter.DelimiterRun;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class Delimiter
implements DelimiterRun {
    final Text node;
    final BasedSequence input;
    final char delimiterChar;
    int index;
    final boolean canOpen;
    final boolean canClose;
    boolean matched = false;
    Delimiter previous;
    Delimiter next;
    int numDelims = 1;

    @Override
    public DelimiterRun getPrevious() {
        return this.previous;
    }

    @Override
    public DelimiterRun getNext() {
        return this.next;
    }

    @Override
    public char getDelimiterChar() {
        return this.delimiterChar;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public int getNumDelims() {
        return this.numDelims;
    }

    @Override
    public Text getNode() {
        return this.node;
    }

    public BasedSequence getInput() {
        return this.input;
    }

    public int getStartIndex() {
        return this.index;
    }

    public int getEndIndex() {
        return this.index + this.numDelims;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public BasedSequence getTailChars(int delimiterUse) {
        return this.input.subSequence(this.getEndIndex() - delimiterUse, this.getEndIndex());
    }

    public BasedSequence getLeadChars(int delimiterUse) {
        return this.input.subSequence(this.getStartIndex(), this.getStartIndex() + delimiterUse);
    }

    Delimiter(BasedSequence input, Text node, char delimiterChar, boolean canOpen, boolean canClose, Delimiter previous, int index) {
        this.input = input;
        this.node = node;
        this.delimiterChar = delimiterChar;
        this.canOpen = canOpen;
        this.canClose = canClose;
        this.previous = previous;
        this.index = index;
    }

    Text getPreviousNonDelimiterTextNode() {
        Node previousNode = this.node.getPrevious();
        if (previousNode instanceof Text && (this.previous == null || this.previous.node != previousNode)) {
            return (Text)previousNode;
        }
        return null;
    }

    Text getNextNonDelimiterTextNode() {
        Node nextNode = this.node.getNext();
        if (nextNode instanceof Text && (this.next == null || this.next.node != nextNode)) {
            return (Text)nextNode;
        }
        return null;
    }

    public void moveNodesBetweenDelimitersTo(DelimitedNode delimitedNode, Delimiter closer) {
        Node tmp = this.getNode().getNext();
        while (tmp != null && tmp != closer.getNode()) {
            Node next = tmp.getNext();
            ((Node)((Object)delimitedNode)).appendChild(tmp);
            tmp = next;
        }
        delimitedNode.setText(this.input.subSequence(this.getEndIndex(), closer.getStartIndex()));
        this.getNode().insertAfter((Node)((Object)delimitedNode));
    }

    public void convertDelimitersToText(int delimitersUsed, Delimiter closer) {
        Text openerText = new Text();
        openerText.setChars(this.getTailChars(delimitersUsed));
        Text closerText = new Text();
        closerText.setChars(closer.getLeadChars(delimitersUsed));
        this.getNode().insertAfter(openerText);
        closer.getNode().insertBefore(closerText);
    }

    @Override
    public boolean canOpen() {
        return this.canOpen;
    }

    @Override
    public boolean canClose() {
        return this.canClose;
    }

    @Override
    public int length() {
        return this.numDelims;
    }
}

